/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.freemarker.layout;

import com.jtech.marble.freemarker.util.DirectiveUtil;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.Map;

public class ExtendsDirective
implements TemplateDirectiveModel {
    public static final String DIRECTIVE_NAME = "extends";

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String name = DirectiveUtil.getRequiredParam(params, "name");
        params.remove("name");
        if (!name.endsWith(".ftl")) {
            name = name + ".ftl";
        }
        String encoding = DirectiveUtil.getParam(params, "encoding", "UTF-8");
        String templatePath = this.getTemplatePath(env);
        String includeTemplateName = env.toFullTemplateName(templatePath, name);
        Configuration configuration = env.getConfiguration();
        Template template = configuration.getTemplate(includeTemplateName, env.getLocale(), encoding, true);
        for (Object key : params.keySet()) {
            SimpleScalar paramModule = new SimpleScalar(params.get(key).toString());
            env.setVariable(key.toString(), (TemplateModel)paramModule);
        }
        env.include(template);
    }

    private String getTemplatePath(Environment env) {
        String templateName = env.getMainTemplate().getName();
        return templateName.lastIndexOf(47) == -1 ? "" : templateName.substring(0, templateName.lastIndexOf(47) + 1);
    }
}

