/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.util.text;

import com.github.stuxuhai.jpinyin.PinyinException;
import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinHelper;
import com.google.common.base.Strings;
import com.jtech.marble.util.text.StrUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinYinUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinYinUtil.class);

    public static String domain(String cnName) {
        try {
            return PinyinHelper.convertToPinyinString((String)cnName, (String)"", (PinyinFormat)PinyinFormat.WITHOUT_TONE);
        }
        catch (PinyinException e) {
            LOGGER.error("Domain Function has error!", (Throwable)e);
            return "";
        }
    }

    public static String firstCharDomain(String cnName) {
        String domain;
        try {
            domain = PinyinHelper.convertToPinyinString((String)cnName, (String)",", (PinyinFormat)PinyinFormat.WITHOUT_TONE);
        }
        catch (PinyinException e) {
            LOGGER.error("Domain Function has error!", (Throwable)e);
            return "";
        }
        if (Strings.isNullOrEmpty((String)domain)) {
            return "";
        }
        List namesPinyin = StrUtil.createSplitter(",").splitToList((CharSequence)domain);
        StringBuilder firstChatDominas = new StringBuilder();
        for (String namePinyin : namesPinyin) {
            firstChatDominas.append(StringUtils.left((String)namePinyin, (int)1));
        }
        return firstChatDominas.toString();
    }

    public static String firstCharDomainToUpperCase(String cnName) {
        String domain = PinYinUtil.domain(cnName);
        return StringUtils.upperCase((String)StringUtils.left((String)domain, (int)1));
    }

    public static String firstCharDomainToLowerCase(String cnName) {
        String domain = PinYinUtil.domain(cnName);
        return StringUtils.lowerCase((String)StringUtils.left((String)domain, (int)1));
    }
}

