/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.auth.handler;

import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.base.Strings;
import com.jtech.toa.auth.exception.MissingTokenException;
import com.jtech.toa.auth.service.IJwtTokenService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class JwtInterceptor
extends HandlerInterceptorAdapter {
    public static final String HTTPHEADERNAME = "Authorization";
    private static final String HTTPHEADERPREFIX = "Bearer:";
    private static final String XML_HTTP_REQUEST = "XMLHttpRequest";
    private final IJwtTokenService jwtTokenService;

    @Autowired
    public JwtInterceptor(IJwtTokenService jwtTokenService) {
        this.jwtTokenService = jwtTokenService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        String headToken = request.getHeader(HTTPHEADERNAME);
        if (Strings.isNullOrEmpty((String)headToken) || !StringUtils.startsWith((CharSequence)headToken, (CharSequence)HTTPHEADERPREFIX)) {
            String requestHeader = request.getHeader("x-requested-with");
            if (requestHeader != null && StringUtils.equalsIgnoreCase((CharSequence)XML_HTTP_REQUEST, (CharSequence)requestHeader)) {
                throw new MissingTokenException();
            }
            response.sendRedirect("/login");
            return false;
        }
        String token = StringUtils.replace((String)headToken, (String)HTTPHEADERPREFIX, (String)"");
        DecodedJWT decodedJWT = this.jwtTokenService.verify(token);
        Claim uidClaim = decodedJWT.getClaim("uid");
        String userId = uidClaim.isNull() ? "" : (null != uidClaim.asString() ? uidClaim.asString() : (null != uidClaim.asInt() ? uidClaim.asInt() + "" : ""));
        if (StringUtils.equals((CharSequence)userId, (CharSequence)"")) {
            response.setStatus(400);
            return false;
        }
        request.setAttribute("TOA_REQUEST_CURRENT_KEY", (Object)userId);
        return true;
    }
}

