/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.auth.service.impl;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.jtech.toa.auth.service.IJwtTokenService;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JwtTokenServiceImpl
implements IJwtTokenService {
    private static final String JWT_SECRET = Base64.encodeBase64String((byte[])"toa#hefei@shushanqu$jingtong^tech".getBytes());
    private static final String ISSUER = "http://xh.jing-tong.com";
    private static final Algorithm HMAC_ALGORITHM;
    private static final Logger logger;

    @Override
    public String createToken(long userId, int expiresDays) {
        if (expiresDays <= 0) {
            expiresDays = 1;
        }
        DateTime now = DateTime.now();
        Date expiresAtDate = now.plusDays(expiresDays).toDate();
        return JWT.create().withClaim("uid", Long.valueOf(userId)).withClaim("exp", expiresAtDate).withClaim("iat", now.plusDays(-1).toDate()).withIssuer(ISSUER).sign(HMAC_ALGORITHM);
    }

    @Override
    public DecodedJWT verify(String jwt) {
        JWTVerifier verifier = JWT.require((Algorithm)HMAC_ALGORITHM).withIssuer(ISSUER).build();
        return verifier.verify(jwt);
    }

    static {
        logger = LoggerFactory.getLogger(JwtTokenServiceImpl.class);
        try {
            HMAC_ALGORITHM = Algorithm.HMAC256((String)JWT_SECRET);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("create Algorithm has error!", (Throwable)e);
            throw new RuntimeException("create Algorithm has error!", e);
        }
    }
}

