/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.bill.manager.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.toa.bill.manager.IBillBpmnManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BillBpmnManagerImpl
implements IBillBpmnManager {
    private final RepositoryService repositoryService;

    @Autowired
    public BillBpmnManagerImpl(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Override
    public ProcessDefinition findLastVersionByFlowId(String flowId) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(flowId).latestVersion().singleResult();
    }

    @Override
    public List<FlowElement> findNodesByType(String definitionId, int maxIndex, Class<? extends FlowElement> eleClas) {
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(definitionId);
        if (bpmnModel != null) {
            ArrayList nodes = Lists.newArrayList();
            Collection flowElements = bpmnModel.getMainProcess().getFlowElements();
            if (CollectionUtil.isNotEmpty((Collection)flowElements)) {
                int nodeIndex = 0;
                for (FlowElement flowElement : flowElements) {
                    String name;
                    if (!(flowElement instanceof UserTask) || Strings.isNullOrEmpty((String)(name = flowElement.getName()))) continue;
                    if (nodeIndex < maxIndex) {
                        nodes.add(flowElement);
                    }
                    ++nodeIndex;
                }
            }
            return nodes;
        }
        return Collections.emptyList();
    }

    @Override
    public void startFlow(String processKey) {
    }
}

