/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.bill.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.jtech.marble.exception.DaoException;
import com.jtech.toa.bill.dao.BillDataJsonMapper;
import com.jtech.toa.bill.domain.Bill;
import com.jtech.toa.bill.domain.BillDataJson;
import com.jtech.toa.bill.service.IBillDataJsonService;
import com.jtech.toa.form.domain.FormDesinger;
import com.jtech.toa.form.service.IFormDesingerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillDataJsonServiceImpl
extends ServiceImpl<BillDataJsonMapper, BillDataJson>
implements IBillDataJsonService {
    private final IFormDesingerService formDesingerService;

    @Autowired
    public BillDataJsonServiceImpl(IFormDesingerService formDesingerService) {
        this.formDesingerService = formDesingerService;
    }

    @Override
    @Transactional(readOnly=true)
    public BillDataJson selectByBillId(long billId) {
        return ((BillDataJsonMapper)this.baseMapper).selectByBillId(billId);
    }

    @Override
    public BillDataJson saveByProcessId(long processId, String formDataJSON, Bill bill) {
        FormDesinger formDesinger = this.formDesingerService.selectByProcessId(processId);
        BillDataJson dataJson = new BillDataJson();
        dataJson.setFormData(formDataJSON);
        dataJson.setFormSchema(formDesinger.getDesingerJson());
        dataJson.setBillId(bill.getId());
        boolean insertState = this.insert((Object)dataJson);
        if (!insertState) {
            throw new DaoException("\u6570\u636eJSON\u4fdd\u5b58\u5931\u8d25");
        }
        return dataJson;
    }
}

