/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.bill.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.jtech.marble.exception.DaoException;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.bill.dao.BillTallyMapper;
import com.jtech.toa.bill.domain.BillTally;
import com.jtech.toa.bill.model.dto.BillTallyDto;
import com.jtech.toa.bill.service.IBillTallyDailyService;
import com.jtech.toa.bill.service.IBillTallyService;
import com.jtech.toa.sys.exception.EmployeeNotFoundException;
import com.jtech.toa.user.domain.Employee;
import com.jtech.toa.user.service.IEmployeeService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillTallyServiceImpl
extends ServiceImpl<BillTallyMapper, BillTally>
implements IBillTallyService {
    private final IEmployeeService employeeService;
    private final IBillTallyDailyService billTallyDailyService;

    @Autowired
    public BillTallyServiceImpl(IEmployeeService employeeService, IBillTallyDailyService billTallyDailyService) {
        this.employeeService = employeeService;
        this.billTallyDailyService = billTallyDailyService;
    }

    @Override
    @Transactional
    public BillTally tally(long userId, Date date, BigDecimal amount, long type, String remark) {
        Employee employee = this.employeeService.selectByUserId(userId);
        if (employee == null) {
            throw new EmployeeNotFoundException("\u65e0\u6cd5\u627e\u5230\u5458\u5de5\u4fe1\u606f");
        }
        int unixTime = DateUtil.unixTime();
        long employeeId = employee.getId();
        BillTally billTally = new BillTally();
        billTally.setRemark(remark);
        billTally.setAmount(amount);
        billTally.setType(type);
        billTally.setEmployeeId(employeeId);
        if (date == null) {
            billTally.setDateline(unixTime);
        } else {
            billTally.setDateline(DateUtil.unixTime((Date)date));
        }
        billTally.setCreateTime(unixTime);
        billTally.setCreater(userId);
        Integer insertRows = ((BillTallyMapper)this.baseMapper).insert((Object)billTally);
        if (insertRows <= 0) {
            throw new DaoException("\u8bb0\u8d26\u5931\u8d25");
        }
        boolean resDaily = this.billTallyDailyService.tallyDaily(employeeId, date, amount);
        if (!resDaily) {
            throw new DaoException("\u8bb0\u8d26\u5931\u8d25");
        }
        return billTally;
    }

    @Override
    public List<BillTallyDto> selectByTypeAndDay(long userId, Date day, long type) {
        DateTime dateTime = new DateTime((Object)day);
        DateTime.Property millisOfDay = dateTime.millisOfDay();
        int maxTime = DateUtil.unixTime((Date)millisOfDay.withMaximumValue().toDate());
        int minTime = DateUtil.unixTime((Date)millisOfDay.withMinimumValue().toDate());
        return ((BillTallyMapper)this.baseMapper).selectByTypeAndDayAndUser(userId, minTime, maxTime, type);
    }
}

