/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.toa.form.constants.FormValueType;
import com.jtech.toa.form.dao.FormFieldMapper;
import com.jtech.toa.form.domain.FormField;
import com.jtech.toa.form.model.define.FormXtype;
import com.jtech.toa.form.model.vo.FormFieldVO;
import com.jtech.toa.form.service.IFormFieldService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FormFieldServiceImpl
extends ServiceImpl<FormFieldMapper, FormField>
implements IFormFieldService {
    @Override
    @Transactional(readOnly=true)
    public List<FormField> selectByFormId(long formId) {
        if (formId <= 0L) {
            return Collections.emptyList();
        }
        return ((FormFieldMapper)this.baseMapper).selectByFormId(formId);
    }

    @Override
    public FormField selectByValueType(FormValueType valueType) {
        return ((FormFieldMapper)this.baseMapper).selectByValueType(valueType.toString());
    }

    @Override
    @Transactional(readOnly=true)
    public List<FormFieldVO> selectByProcesId(long processId) {
        if (processId <= 0L) {
            return Collections.emptyList();
        }
        List<FormField> fields = ((FormFieldMapper)this.baseMapper).selectByProcessId(processId);
        if (CollectionUtil.isEmpty(fields)) {
            return Collections.emptyList();
        }
        ArrayList fieldVOS = Lists.newArrayListWithCapacity((int)fields.size());
        HashMap detailGroup = Maps.newHashMap();
        for (FormField field : fields) {
            Long fieldId;
            FormFieldVO formFieldVO = new FormFieldVO();
            formFieldVO.setId(field.getId());
            formFieldVO.setWidgetName(field.getWidgetName());
            formFieldVO.setTitle(field.getTitle());
            formFieldVO.setType(field.getType());
            formFieldVO.setDescription(field.getDescription());
            formFieldVO.setFormId(field.getFormId());
            formFieldVO.setPlaceholder(field.getPlaceholder());
            String props = field.getProps();
            Map map = (Map)JSON.parseObject((String)props, Map.class);
            if (map.get("widget") != null) {
                formFieldVO.setProps(JSON.toJSONString(map.get("widget")));
            } else {
                formFieldVO.setProps(field.getProps());
            }
            formFieldVO.setRequired(field.isRequired());
            ArrayList formFieldVOS = Lists.newArrayList();
            formFieldVO.setDetailFields(formFieldVOS);
            if (StringUtils.equals((CharSequence)field.getType(), (CharSequence)FormXtype.detailgroup.name())) {
                detailGroup.put(field.getId(), formFieldVO);
            }
            if ((fieldId = field.getFieldId()) != null && fieldId > 0L) {
                FormFieldVO detailGroupField = (FormFieldVO)detailGroup.get(fieldId);
                detailGroupField.getDetailFields().add(formFieldVO);
                continue;
            }
            fieldVOS.add(formFieldVO);
        }
        return fieldVOS;
    }
}

