/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.process.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.toa.process.constants.DataSourceCode;
import com.jtech.toa.process.domain.Datasource;
import com.jtech.toa.process.domain.DatasourceCombo;
import com.jtech.toa.process.exception.ProcessBizException;
import com.jtech.toa.process.manager.IDatasourceManager;
import com.jtech.toa.process.model.vo.DatasourceComboVO;
import com.jtech.toa.process.service.IDatasourceComboService;
import com.jtech.toa.process.service.IDatasourcePopoverService;
import com.jtech.toa.process.service.IDatasourceService;
import com.jtech.toa.sys.constants.CommonConst;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DatasourceManagerImpl
implements IDatasourceManager {
    private final IDatasourceService datasourceService;
    private final IDatasourceComboService datasourceComboService;
    private final IDatasourcePopoverService datasourcePopoverService;

    @Autowired
    public DatasourceManagerImpl(IDatasourceService datasourceService, IDatasourceComboService datasourceComboService, IDatasourcePopoverService datasourcePopoverService) {
        this.datasourceService = datasourceService;
        this.datasourceComboService = datasourceComboService;
        this.datasourcePopoverService = datasourcePopoverService;
    }

    @Override
    @Transactional(readOnly=true)
    public DatasourceComboVO execWithCombo(String table, String field, String keyword) {
        Datasource datasource = this.datasourceService.selectByCode(table);
        if (datasource == null) {
            throw new ProcessBizException(DataSourceCode.DS_NOT_FOUND);
        }
        DatasourceCombo datasourceCombo = this.datasourceComboService.selectByDatasourceId(datasource.getId());
        if (datasourceCombo == null) {
            throw new ProcessBizException(DataSourceCode.COMBO_ERROR);
        }
        int dsType = (Integer)MoreObjects.firstNonNull((Object)datasource.getDsType(), (Object)0);
        switch (dsType) {
            case 1: 
            case 2: {
                String sql = datasource.getSqlScript();
                List<Map<String, Object>> data = this.datasourceService.executeSql(sql, field, keyword);
                DatasourceComboVO datasourceComboVO = new DatasourceComboVO();
                datasourceComboVO.setData(data);
                datasourceComboVO.setDisplayField(datasourceCombo.getDisplayField());
                datasourceComboVO.setValueField(datasourceCombo.getValueField());
                return datasourceComboVO;
            }
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> execWithSelect(String table, String query) {
        Datasource datasource;
        HashMap sqlParams = Maps.newHashMap();
        if (!Strings.isNullOrEmpty((String)query)) {
            Map queryMap;
            try {
                queryMap = (Map)JSON.parseObject((String)query, (TypeReference)CommonConst.TF_MAP_STR_OBJ, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                throw new ProcessBizException(DataSourceCode.QUERY_JSON_ERROR);
            }
            if (CollectionUtil.isNotEmpty((Map)queryMap)) {
                for (String queryField : queryMap.keySet()) {
                    String value = String.valueOf(queryMap.get(queryField));
                    sqlParams.put(queryField, value);
                }
            }
        }
        if ((datasource = this.datasourceService.selectByCode(table)) == null) {
            throw new ProcessBizException(DataSourceCode.DS_NOT_FOUND);
        }
        int dsType = (Integer)MoreObjects.firstNonNull((Object)datasource.getDsType(), (Object)0);
        switch (dsType) {
            case 1: 
            case 2: {
                String sql = datasource.getSqlScript();
                return this.datasourceService.executeSql(sql, sqlParams);
            }
        }
        return null;
    }

    private List<Map<String, Object>> execSql(String sql, String field, String keyword) {
        return this.datasourceService.executeSql(sql, field, keyword);
    }
}

