/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.process.model.vo;

import com.baomidou.mybatisplus.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.process.domain.NodeFormApprover;
import com.jtech.toa.process.domain.NodeFormCondition;
import com.jtech.toa.process.domain.NodeFormField;
import com.jtech.toa.process.domain.NodeSpecuser;
import com.jtech.toa.process.model.vo.ProcessNodeConditionVO;
import com.jtech.toa.process.model.vo.ProcessUserVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ProcessNodeVO
implements Serializable {
    private static final long serialVersionUID = -8473379548632314058L;
    private String desc;
    private String nodeId;
    private String ntype;
    private String title;
    private List<ProcessUserVO> assignUsers;
    private long assignPosition;
    private String assignFormItemWidget;
    private List<ProcessNodeConditionVO> conditionsItems;
    private Map<String, Integer> permissions;
    private int approverType;

    public List<NodeFormField> toFormField(long processId) {
        if (CollectionUtil.isEmpty(this.permissions)) {
            return Collections.emptyList();
        }
        ArrayList formFields = Lists.newArrayListWithCapacity((int)this.permissions.size());
        int unixTime = DateUtil.unixTime();
        for (String key : this.permissions.keySet()) {
            NodeFormField nodeFormField = new NodeFormField();
            nodeFormField.setFormWidgetName(key);
            nodeFormField.setNodeId(this.nodeId);
            int type = this.permissions.get(key);
            switch (type) {
                case 0: {
                    nodeFormField.setEditFlag(false);
                    nodeFormField.setVisibleFlag(false);
                    break;
                }
                case 1: {
                    nodeFormField.setEditFlag(true);
                    nodeFormField.setVisibleFlag(false);
                    break;
                }
                case 2: {
                    nodeFormField.setEditFlag(false);
                    nodeFormField.setVisibleFlag(true);
                    break;
                }
                case 3: {
                    nodeFormField.setEditFlag(true);
                    nodeFormField.setVisibleFlag(true);
                    break;
                }
                default: {
                    nodeFormField.setEditFlag(false);
                    nodeFormField.setVisibleFlag(false);
                }
            }
            nodeFormField.setDateline(unixTime);
            nodeFormField.setProcessId(processId);
            formFields.add(nodeFormField);
        }
        return formFields;
    }

    public List<NodeFormCondition> toFormCondition(long operId, long processId) {
        if (CollectionUtil.isNotEmpty(this.conditionsItems)) {
            int dateline = DateUtil.unixTime();
            int conditionSize = this.conditionsItems.size();
            ArrayList formConditions = Lists.newArrayListWithCapacity((int)conditionSize);
            for (ProcessNodeConditionVO conditionsItem : this.conditionsItems) {
                long conditionId = IdWorker.getId();
                NodeFormCondition formCondition = new NodeFormCondition();
                formCondition.setOperId(operId);
                formCondition.setId(conditionId);
                formCondition.setFactor(conditionsItem.getAo());
                formCondition.setConditionVal(conditionsItem.getValue());
                formCondition.setRelation(conditionsItem.getJudge());
                formCondition.setProcessId(processId);
                formCondition.setFormWidgetName(conditionsItem.getFormItemWidgetName());
                formCondition.setDateline(dateline);
                List<ProcessUserVO> itemUsers = conditionsItem.getUsers();
                if (CollectionUtil.isNotEmpty(itemUsers)) {
                    ArrayList approvers = Lists.newArrayListWithCapacity((int)itemUsers.size());
                    for (ProcessUserVO itemUser : itemUsers) {
                        NodeFormApprover approver = new NodeFormApprover();
                        approver.setApprover(itemUser.getId());
                        approver.setApproverName(itemUser.getName());
                        approver.setApproverType(1);
                        approver.setConditionId(conditionId);
                        approver.setProcessId(processId);
                        approver.setDateline(dateline);
                        approvers.add(approver);
                    }
                    formCondition.setApprovers(approvers);
                }
                formConditions.add(formCondition);
            }
            return formConditions;
        }
        return Collections.emptyList();
    }

    public List<NodeSpecuser> toSpecUsers(long nodeOperId) {
        if (CollectionUtil.isEmpty(this.assignUsers)) {
            return Collections.emptyList();
        }
        ArrayList specusers = Lists.newArrayListWithCapacity((int)this.assignUsers.size());
        for (ProcessUserVO assignUser : this.assignUsers) {
            NodeSpecuser nodeSpecuser = new NodeSpecuser();
            nodeSpecuser.setOperId(nodeOperId);
            nodeSpecuser.setEmployeeId(assignUser.getId());
            nodeSpecuser.setDateline(DateUtil.unixTime());
            specusers.add(nodeSpecuser);
        }
        return specusers;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getNtype() {
        return this.ntype;
    }

    public String getTitle() {
        return this.title;
    }

    public List<ProcessUserVO> getAssignUsers() {
        return this.assignUsers;
    }

    public long getAssignPosition() {
        return this.assignPosition;
    }

    public String getAssignFormItemWidget() {
        return this.assignFormItemWidget;
    }

    public List<ProcessNodeConditionVO> getConditionsItems() {
        return this.conditionsItems;
    }

    public Map<String, Integer> getPermissions() {
        return this.permissions;
    }

    public int getApproverType() {
        return this.approverType;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setNtype(String ntype) {
        this.ntype = ntype;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAssignUsers(List<ProcessUserVO> assignUsers) {
        this.assignUsers = assignUsers;
    }

    public void setAssignPosition(long assignPosition) {
        this.assignPosition = assignPosition;
    }

    public void setAssignFormItemWidget(String assignFormItemWidget) {
        this.assignFormItemWidget = assignFormItemWidget;
    }

    public void setConditionsItems(List<ProcessNodeConditionVO> conditionsItems) {
        this.conditionsItems = conditionsItems;
    }

    public void setPermissions(Map<String, Integer> permissions) {
        this.permissions = permissions;
    }

    public void setApproverType(int approverType) {
        this.approverType = approverType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessNodeVO)) {
            return false;
        }
        ProcessNodeVO other = (ProcessNodeVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        String this$nodeId = this.getNodeId();
        String other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !this$nodeId.equals(other$nodeId)) {
            return false;
        }
        String this$ntype = this.getNtype();
        String other$ntype = other.getNtype();
        if (this$ntype == null ? other$ntype != null : !this$ntype.equals(other$ntype)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List<ProcessUserVO> this$assignUsers = this.getAssignUsers();
        List<ProcessUserVO> other$assignUsers = other.getAssignUsers();
        if (this$assignUsers == null ? other$assignUsers != null : !((Object)this$assignUsers).equals(other$assignUsers)) {
            return false;
        }
        if (this.getAssignPosition() != other.getAssignPosition()) {
            return false;
        }
        String this$assignFormItemWidget = this.getAssignFormItemWidget();
        String other$assignFormItemWidget = other.getAssignFormItemWidget();
        if (this$assignFormItemWidget == null ? other$assignFormItemWidget != null : !this$assignFormItemWidget.equals(other$assignFormItemWidget)) {
            return false;
        }
        List<ProcessNodeConditionVO> this$conditionsItems = this.getConditionsItems();
        List<ProcessNodeConditionVO> other$conditionsItems = other.getConditionsItems();
        if (this$conditionsItems == null ? other$conditionsItems != null : !((Object)this$conditionsItems).equals(other$conditionsItems)) {
            return false;
        }
        Map<String, Integer> this$permissions = this.getPermissions();
        Map<String, Integer> other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        return this.getApproverType() == other.getApproverType();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessNodeVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        String $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : $nodeId.hashCode());
        String $ntype = this.getNtype();
        result = result * 59 + ($ntype == null ? 43 : $ntype.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List<ProcessUserVO> $assignUsers = this.getAssignUsers();
        result = result * 59 + ($assignUsers == null ? 43 : ((Object)$assignUsers).hashCode());
        long $assignPosition = this.getAssignPosition();
        result = result * 59 + (int)($assignPosition >>> 32 ^ $assignPosition);
        String $assignFormItemWidget = this.getAssignFormItemWidget();
        result = result * 59 + ($assignFormItemWidget == null ? 43 : $assignFormItemWidget.hashCode());
        List<ProcessNodeConditionVO> $conditionsItems = this.getConditionsItems();
        result = result * 59 + ($conditionsItems == null ? 43 : ((Object)$conditionsItems).hashCode());
        Map<String, Integer> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        result = result * 59 + this.getApproverType();
        return result;
    }

    public String toString() {
        return "ProcessNodeVO(desc=" + this.getDesc() + ", nodeId=" + this.getNodeId() + ", ntype=" + this.getNtype() + ", title=" + this.getTitle() + ", assignUsers=" + this.getAssignUsers() + ", assignPosition=" + this.getAssignPosition() + ", assignFormItemWidget=" + this.getAssignFormItemWidget() + ", conditionsItems=" + this.getConditionsItems() + ", permissions=" + this.getPermissions() + ", approverType=" + this.getApproverType() + ")";
    }
}

