/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.process.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.process.dao.BillTitleMapper;
import com.jtech.toa.process.domain.BillTitle;
import com.jtech.toa.process.model.dto.BillTitleDTO;
import com.jtech.toa.process.model.vo.BillTItleFormulaVo;
import com.jtech.toa.process.service.IBillTitleService;
import com.jtech.toa.user.domain.Employee;
import java.util.Date;
import org.joda.time.DateTime;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Service;

@Service
public class BillTitleServiceImpl
extends ServiceImpl<BillTitleMapper, BillTitle>
implements IBillTitleService {
    @Override
    public String getTitle(long processId, Employee employee) {
        String day;
        BillTitleDTO billTitle = this.findByProcessId(processId);
        Date todayDate = DateTime.now().toDate();
        if (billTitle == null) {
            return DateUtil.yyyyMMdd((Date)todayDate);
        }
        BillTItleFormulaVo formulaParams = new BillTItleFormulaVo();
        formulaParams.setProcessCreater(employee.getUsername());
        String formula = billTitle.getFormula();
        boolean timeFlag = billTitle.isTimeFlag();
        if (timeFlag) {
            String timePattern = (String)MoreObjects.firstNonNull((Object)billTitle.getTimePattern(), (Object)"yyyy-MM-dd");
            day = com.xiaoleilu.hutool.date.DateUtil.format((Date)todayDate, (String)timePattern);
        } else {
            day = DateUtil.yyyyMMddDash((Date)todayDate);
        }
        formulaParams.setToday(day);
        formulaParams.setProcessTypeName(billTitle.getProcessTypeName());
        formulaParams.setProcessName(billTitle.getProcessName());
        if (!Strings.isNullOrEmpty((String)formula)) {
            SpelExpressionParser parser = new SpelExpressionParser();
            Expression formulaExp = parser.parseExpression(formula, ParserContext.TEMPLATE_EXPRESSION);
            StandardEvaluationContext context = new StandardEvaluationContext((Object)formulaParams);
            return (String)formulaExp.getValue((EvaluationContext)context, String.class);
        }
        return null;
    }

    @Override
    public BillTitleDTO findByProcessId(long processId) {
        return ((BillTitleMapper)this.baseMapper).selectByProcessId(processId);
    }
}

