/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.process.service.impl;

import com.jtech.toa.process.service.IDesingerResourceService;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;

@Service
public class DesingerResourceServiceImpl
implements IDesingerResourceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DesingerResourceServiceImpl.class);
    private final String formJSON;
    private final String workflowJSON;

    public DesingerResourceServiceImpl() {
        String _workflowJSON;
        String _formJSON;
        try {
            ClassPathResource formRes = new ClassPathResource("/desinger/form.json");
            ClassPathResource workflowRes = new ClassPathResource("/desinger/workflow.json");
            _formJSON = FileCopyUtils.copyToString((Reader)new FileReader(formRes.getFile()));
            _workflowJSON = FileCopyUtils.copyToString((Reader)new FileReader(workflowRes.getFile()));
        }
        catch (IOException e) {
            LOGGER.error("get flow desinger resource has error!", (Throwable)e);
            _formJSON = "";
            _workflowJSON = "";
        }
        this.formJSON = _formJSON;
        this.workflowJSON = _workflowJSON;
    }

    @Override
    public String getFormJSON() {
        return this.formJSON;
    }

    @Override
    public String getWorkflowJSON() {
        return this.workflowJSON;
    }
}

