/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.process.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.jtech.marble.exception.DaoException;
import com.jtech.marble.shiro.ShiroUser;
import com.jtech.marble.shiro.ShiroUtil;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.process.dao.NodeOperMapper;
import com.jtech.toa.process.domain.NodeOper;
import com.jtech.toa.process.service.INodeOperService;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NodeOperServiceImpl
extends ServiceImpl<NodeOperMapper, NodeOper>
implements INodeOperService {
    @Override
    @Transactional
    public boolean saveOrUpdateNodeOpers(List<NodeOper> nodeOpers, long processId) {
        if (processId < 0L || CollectionUtil.isEmpty(nodeOpers)) {
            return false;
        }
        ShiroUser shiroUser = ShiroUtil.getUser();
        long loginUserId = shiroUser.getId();
        int unixTime = DateUtil.unixTime();
        ((NodeOperMapper)this.baseMapper).deleteByProcessId(processId, loginUserId, unixTime);
        boolean operState = this.insertBatch(nodeOpers);
        if (!operState) {
            throw new DaoException("save process node oper has error!");
        }
        return true;
    }
}

