/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.user.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.jtech.marble.exception.DaoException;
import com.jtech.marble.shiro.ShiroUser;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.marble.util.DateUtil;
import com.jtech.marble.util.PasswordUtil;
import com.jtech.marble.util.text.PinYinUtil;
import com.jtech.marble.vo.ZTreeVO;
import com.jtech.toa.sys.service.IUserService;
import com.jtech.toa.user.dao.EmployeeMapper;
import com.jtech.toa.user.domain.Employee;
import com.jtech.toa.user.model.EmployeeOrgDto;
import com.jtech.toa.user.model.EmployeeOrgPositionDto;
import com.jtech.toa.user.model.EmployeePositionDto;
import com.jtech.toa.user.model.PortalLoginUserDto;
import com.jtech.toa.user.model.dto.EmployeeFormDTO;
import com.jtech.toa.user.model.query.EmployeeQuery;
import com.jtech.toa.user.model.vo.DesingerEmployeeVO;
import com.jtech.toa.user.service.IEmployeeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.User;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CachePut;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmployeeServiceImpl
extends ServiceImpl<EmployeeMapper, Employee>
implements IEmployeeService {
    private static final Function<Employee, DesingerEmployeeVO> FUNC_DESINGER_MEPLOYEE = new Function<Employee, DesingerEmployeeVO>(){

        public DesingerEmployeeVO apply(Employee employee) {
            DesingerEmployeeVO employeeVO = new DesingerEmployeeVO();
            employeeVO.setId(employee.getId());
            employeeVO.setName(employee.getUsername());
            employeeVO.setUsername(employee.getSimpleName());
            employeeVO.setCode(employee.getCode());
            return employeeVO;
        }
    };
    private final IUserService userService;
    private final IdentityService identityService;

    @Autowired
    public EmployeeServiceImpl(IUserService userService, IdentityService identityService) {
        this.userService = userService;
        this.identityService = identityService;
    }

    private static List<ZTreeVO<EmployeeOrgDto>> listToZtree(List<EmployeeOrgDto> employees) {
        int positionSize = employees.size();
        ArrayList zTreeVOList = Lists.newArrayListWithCapacity((int)positionSize);
        for (EmployeeOrgDto employee : employees) {
            ZTreeVO zTreeVO = ZTreeVO.builder().data((Serializable)employee).id(Long.valueOf(employee.getId())).pid(Long.valueOf(employee.getOrgId())).name(employee.getName()).checked(false).chkDisabled(false).build();
            zTreeVOList.add(zTreeVO);
        }
        return zTreeVOList;
    }

    private static List<ZTreeVO<EmployeePositionDto>> positionListToZtree(List<EmployeePositionDto> employees) {
        int positionSize = employees.size();
        ArrayList zTreeVOList = Lists.newArrayListWithCapacity((int)positionSize);
        for (EmployeePositionDto employee : employees) {
            ZTreeVO zTreeVO = ZTreeVO.builder().data((Serializable)employee).id(Long.valueOf(employee.getId())).pid(Long.valueOf(employee.getPositionId())).name(employee.getName()).checked(false).chkDisabled(false).build();
            zTreeVOList.add(zTreeVO);
        }
        return zTreeVOList;
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Employee> findByUsername(String username) {
        if (StringUtils.isEmpty((CharSequence)username)) {
            return Optional.absent();
        }
        Employee employee = ((EmployeeMapper)this.baseMapper).selectByName(username);
        if (employee == null) {
            return Optional.absent();
        }
        return Optional.of((Object)((Object)employee));
    }

    @Override
    @CachePut(value={"form-employee-cache"})
    public int removeEmployee(long id) {
        int res = ((EmployeeMapper)this.baseMapper).getEmpOrgs(id);
        if (res == 0) {
            User activitiUser = (User)this.identityService.createUserQuery().userId(String.valueOf(id)).singleResult();
            if (activitiUser != null) {
                this.identityService.deleteUser(String.valueOf(id));
            }
            return ((EmployeeMapper)this.baseMapper).deleteById(Long.valueOf(id));
        }
        return -1;
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Employee> findByPagination(Page<Employee> pageResult, List<Sort.Order> orders) {
        List<Employee> employees = ((EmployeeMapper)this.baseMapper).selectByPagination(pageResult, orders);
        pageResult.setRecords(employees);
        return pageResult;
    }

    @Override
    @Transactional(readOnly=true)
    public void searchByPagination(Page<Employee> requestPage, EmployeeQuery employeeQuery) {
        List<Employee> employees = ((EmployeeMapper)this.baseMapper).selectByQuery(requestPage, employeeQuery);
        requestPage.setRecords(employees);
    }

    @Override
    public List<ZTreeVO<EmployeeOrgDto>> findAllToTree() {
        List<EmployeeOrgDto> employeeOrgDtos = ((EmployeeMapper)this.baseMapper).findAllEmployeeAndOrg();
        if (CollectionUtil.isEmpty(employeeOrgDtos)) {
            return Collections.emptyList();
        }
        return EmployeeServiceImpl.listToZtree(employeeOrgDtos);
    }

    @Override
    public List<ZTreeVO<EmployeePositionDto>> findPositionAllToTree() {
        List<EmployeePositionDto> employeeOrgDtos = ((EmployeeMapper)this.baseMapper).findAllEmployeeAndPosition();
        if (CollectionUtil.isEmpty(employeeOrgDtos)) {
            return Collections.emptyList();
        }
        return EmployeeServiceImpl.positionListToZtree(employeeOrgDtos);
    }

    @Override
    public List<EmployeeOrgPositionDto> findOrgAndPositionAll() {
        return ((EmployeeMapper)this.baseMapper).findOrgAndPosition();
    }

    @Override
    @Transactional
    @CachePut(value={"form-employee-cache"})
    public boolean addEmployee(EmployeeFormDTO employeeForm, ShiroUser shiroUser) {
        long shiroUserId = shiroUser.getId();
        int unixTime = DateUtil.unixTime();
        byte[] randomSaltBytes = PasswordUtil.generateSalt();
        com.jtech.toa.sys.domain.User user = employeeForm.toUser();
        String password = PasswordUtil.password((byte[])randomSaltBytes, (String)user.getPassword());
        String randomSalt = PasswordUtil.salt((byte[])randomSaltBytes);
        user.setPassword(password);
        user.setSalt(randomSalt);
        user.setCreater(Long.valueOf(shiroUserId));
        user.setCreateTime(Integer.valueOf(unixTime));
        boolean userState = this.userService.insert((Object)user);
        if (userState) {
            Employee employee = employeeForm.toEmployee();
            employee.setUserId(user.getId());
            employee.setChangePasswordFlag(0);
            String username = employee.getUsername();
            String domain = PinYinUtil.domain((String)username);
            employee.setDomain(domain);
            boolean employeeState = this.insert((Object)employee);
            if (!employeeState) {
                throw new DaoException("\u5458\u5de5\u5199\u5165\u5931\u8d25");
            }
            User newUser = this.identityService.newUser(String.valueOf(employee.getId()));
            newUser.setFirstName(String.valueOf(employee.getId()));
            newUser.setLastName(employee.getUsername());
            this.identityService.saveUser(newUser);
        }
        return true;
    }

    @Override
    @Transactional
    @CachePut(value={"form-employee-cache"})
    public boolean updateEmployee(EmployeeFormDTO employeeForm, ShiroUser shiroUser) {
        long shiroUserId = shiroUser.getId();
        int unixTime = DateUtil.unixTime();
        Employee employee = employeeForm.toEmployee();
        String domain = PinYinUtil.domain((String)employeeForm.getUsername());
        employee.setDomain(domain);
        employee.setUpdateTime(unixTime);
        employee.setUpdater(shiroUserId);
        User activitiUser = (User)this.identityService.createUserQuery().userId(String.valueOf(employee.getId())).singleResult();
        if (activitiUser != null) {
            activitiUser.setLastName(employee.getUsername());
            this.identityService.saveUser(activitiUser);
        } else {
            activitiUser = this.identityService.newUser(String.valueOf(employee.getId()));
            activitiUser.setFirstName(String.valueOf(employee.getId()));
            activitiUser.setLastName(employee.getUsername());
            this.identityService.saveUser(activitiUser);
        }
        return ((EmployeeMapper)this.baseMapper).updateById((Object)employee) == 1;
    }

    @Override
    @Transactional(readOnly=true)
    public List<DesingerEmployeeVO> findByOrganization(long organizationId) {
        List<Employee> employees = ((EmployeeMapper)this.baseMapper).selectByOrgainzation(organizationId);
        if (CollectionUtil.isEmpty(employees)) {
            return Collections.emptyList();
        }
        return Lists.transform(employees, FUNC_DESINGER_MEPLOYEE);
    }

    @Override
    public List<DesingerEmployeeVO> findByPositionId(long positionId) {
        List<Employee> employees = ((EmployeeMapper)this.baseMapper).selectByPositionId(positionId);
        if (CollectionUtil.isEmpty(employees)) {
            return Collections.emptyList();
        }
        return Lists.transform(employees, FUNC_DESINGER_MEPLOYEE);
    }

    @Override
    public List<EmployeeOrgPositionDto> findOrgAndPositionAllByOrgId(long organizationId) {
        return ((EmployeeMapper)this.baseMapper).findOrgAndPositionByOrgId(organizationId);
    }

    @Override
    public List<EmployeeOrgPositionDto> findOrgAndPositionNoOrg() {
        return ((EmployeeMapper)this.baseMapper).selectOrgAndPositionNoOrg();
    }

    @Override
    public Employee selectByUserId(long userId) {
        if (userId <= 0L) {
            return null;
        }
        return ((EmployeeMapper)this.baseMapper).selectByUserId(userId);
    }

    @Override
    public Optional<PortalLoginUserDto> findPortalByUserId(long userId) {
        PortalLoginUserDto portalLoginUserDto = ((EmployeeMapper)this.baseMapper).selectLoginUserByUserId(userId);
        if (null == portalLoginUserDto) {
            return Optional.absent();
        }
        return Optional.of((Object)portalLoginUserDto);
    }
}

