/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.user.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.jtech.toa.user.dao.OrganizationEmployeeMapper;
import com.jtech.toa.user.domain.OrganizationChildren;
import com.jtech.toa.user.domain.OrganizationEmployee;
import com.jtech.toa.user.service.IOrganizationChildrenService;
import com.jtech.toa.user.service.IOrganizationEmployeeService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class OrganizationEmployeeService
extends ServiceImpl<OrganizationEmployeeMapper, OrganizationEmployee>
implements IOrganizationEmployeeService {
    private final IOrganizationChildrenService organizationChildrenService;

    public OrganizationEmployeeService(IOrganizationChildrenService organizationChildrenService) {
        this.organizationChildrenService = organizationChildrenService;
    }

    @Override
    public int deleteByChildrenOrgIdAndEmployeeIds(List<Long> employeeIds, long orgId) {
        return ((OrganizationEmployeeMapper)this.baseMapper).deleteByChildrenOrgIdAndEmployeeIds(employeeIds, orgId);
    }

    @Override
    public int deleteByOrganizationId(long orgId) {
        return ((OrganizationEmployeeMapper)this.baseMapper).deleteByOrganizationId(orgId);
    }

    @Override
    public int deleteByChildrenOrgId(long orgId) {
        return ((OrganizationEmployeeMapper)this.baseMapper).deleteByChildrenOrgId(orgId);
    }

    @Override
    public int deleteByOrgIdAndEmployeeIds(List<Long> employeeIds, long orgId) {
        return ((OrganizationEmployeeMapper)this.baseMapper).deleteByOrganizationIdAndEmployeeId(employeeIds, orgId);
    }

    @Override
    public boolean insertList(List<Long> employeeIds, long orgId) {
        OrganizationEmployee organizationEmployee;
        ArrayList organizationEmployees = Lists.newArrayList();
        for (Long employeeId : employeeIds) {
            organizationEmployee = new OrganizationEmployee();
            organizationEmployee.setOrganizationId(orgId);
            organizationEmployee.setChildrenOrgId(0L);
            organizationEmployee.setChildrenFlag(0);
            organizationEmployee.setSelfFlag(1);
            organizationEmployee.setEmployeeId(employeeId);
            organizationEmployees.add(organizationEmployee);
        }
        List<OrganizationChildren> organizationChildrens = this.organizationChildrenService.selectByChildren(orgId);
        for (OrganizationChildren organizationChildren : organizationChildrens) {
            long parentOrgId = organizationChildren.getOrganizationId();
            for (long employeeId : employeeIds) {
                organizationEmployee = new OrganizationEmployee();
                organizationEmployee.setOrganizationId(parentOrgId);
                organizationEmployee.setChildrenOrgId(orgId);
                organizationEmployee.setChildrenFlag(1);
                organizationEmployee.setSelfFlag(0);
                organizationEmployee.setEmployeeId(employeeId);
                organizationEmployees.add(organizationEmployee);
            }
        }
        return this.insertBatch(organizationEmployees);
    }
}

