/*
 * Decompiled with CFR 0.152.
 */
package com.kintiger.platform.framework.converter;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ognl.OgnlOps;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.util.StrutsTypeConverter;
import org.json.JSONArray;
import org.json.JSONObject;

public class Json2ListConverter
extends StrutsTypeConverter {
    private static final Log log = LogFactory.getLog(Json2ListConverter.class);
    private static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    private Class genericType = null;

    public Object convertValue(Map context, Object target, Member member, String propertyName, Object value, Class toType) {
        if (member instanceof Method) {
            ParameterizedType type = (ParameterizedType)((Method)member).getGenericParameterTypes()[0];
            Type actualType = type.getActualTypeArguments()[0];
            this.genericType = (Class)actualType;
        }
        return super.convertValue(context, target, member, propertyName, value, toType);
    }

    public Object convertFromString(Map context, String[] values, Class toClass) {
        if (this.genericType == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        try {
            JSONArray array = new JSONArray(values[0]);
            int i = 0;
            while (i < array.length()) {
                PropertyDescriptor[] props;
                Object obj = this.genericType.newInstance();
                Map map = this.toMap(array.getJSONObject(i));
                PropertyDescriptor[] propertyDescriptorArray = props = PropertyUtils.getPropertyDescriptors(obj);
                int n = props.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor desc = propertyDescriptorArray[n2];
                    if (map.containsKey(desc.getName())) {
                        Object value = null;
                        if (java.util.Date.class.isAssignableFrom(desc.getPropertyType())) {
                            try {
                                value = new SimpleDateFormat(DATE_PATTERN).parse((String)map.get(desc.getName()));
                            }
                            catch (ParseException e) {
                                log.error((Object)e);
                            }
                        } else if (Date.class.isAssignableFrom(desc.getPropertyType())) {
                            try {
                                value = new Date(new SimpleDateFormat(DATE_PATTERN).parse((String)map.get(desc.getName())).getTime());
                            }
                            catch (ParseException e) {
                                log.error((Object)e);
                            }
                        } else {
                            value = OgnlOps.convertValue(map.get(desc.getName()), desc.getPropertyType());
                        }
                        desc.getWriteMethod().invoke(obj, value);
                    }
                    ++n2;
                }
                list.add(obj);
                ++i;
            }
        }
        catch (Exception e) {
            log.error((Object)"JSON \u6570\u636e\u8f6c\u6362\u9519\u8bef.", (Throwable)e);
        }
        return list;
    }

    public String convertToString(Map context, Object o) {
        String json = null;
        if (o != null && o instanceof List) {
            json = new JSONArray((Collection)((List)o)).toString();
        }
        return json;
    }

    private Map toMap(JSONObject object) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iter = object.keys();
        while (iter.hasNext()) {
            String key;
            Object val = object.get(key = (String)iter.next());
            map.put(key, val == null || val.toString().equals("") ? null : val);
        }
        return map;
    }
}

