/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.common.internal;

import com.businessobjects.foundation.exception.IException;
import com.businessobjects.sdk.plugin.desktop.common.IActualConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.IValidRanges;
import com.businessobjects.sdk.plugin.desktop.common.IValidValues;
import com.businessobjects.sdk.plugin.desktop.common.internal.ActualConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfigProperty;
import com.businessobjects.sdk.plugin.desktop.common.internal.IInternalActualConfigProperty;
import com.businessobjects.sdk.plugin.desktop.common.internal.ValidRange;
import com.businessobjects.sdk.plugin.desktop.common.internal.ValidRanges;
import com.businessobjects.sdk.plugin.desktop.common.internal.ValidValues;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.internal.ServerMsgResourcesBundle;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class ActualConfigProperty
implements IInternalActualConfigProperty {
    PropertyBag m_bag;

    public ActualConfigProperty() {
        this.m_bag = new PropertyBag();
    }

    PropertyBag getPropBag() {
        return this.m_bag;
    }

    public ActualConfigProperty(String name, PropertyBag bag) {
        this.m_bag = bag;
        this.setName(name);
    }

    public ActualConfigProperty(PropertyBag bag) {
        this.m_bag = bag;
    }

    public void assumeProperties(IProperties bag) {
        bag.putAll(this.m_bag);
        this.m_bag = (PropertyBag)bag;
    }

    public void copy(IProperties properties) {
        properties.putAll(this.m_bag);
    }

    public void copyto(ConfigProperty other) {
        other.getPropBag().putAll((Map)this.m_bag);
    }

    private void copyProperty(Integer propID, PropertyBag bag) {
        Property item = (Property)this.m_bag.get((Object)propID);
        if (item != null) {
            bag.addItem((Object)propID, item.getValue(), 0);
        }
    }

    public Object getValue() {
        return this.getValue(PropertyIDs.SI_VALUE);
    }

    public Object getDefaultValue() {
        return this.getValue(PropertyIDs.SI_DEFAULT_VALUE);
    }

    Object getValue(Integer propertyID) {
        Property prop = this.m_bag.getItem((Object)propertyID);
        if (prop == null) {
            return null;
        }
        Object value = prop.getValue();
        if (value instanceof PropertyBag) {
            return new ActualConfigProperties((PropertyBag)value);
        }
        return value;
    }

    public void setValue(Object val) throws SDKException {
        this.setValue(val, PropertyIDs.SI_VALUE);
    }

    public void setDefaultValue(Object val) throws SDKException {
        this.setValue(val, PropertyIDs.SI_DEFAULT_VALUE);
    }

    void setValue(Object val, Integer propertyID) throws SDKException {
        Iterator iter;
        Class<?> newClass;
        Class<?> origClass;
        int valIsFinal;
        Object value;
        Property isFinal = this.m_bag.getItem((Object)PropertyIDs.SI_FINAL);
        if (isFinal != null && ((value = isFinal.getValue()) instanceof Boolean ? (valIsFinal = ((Boolean)value).booleanValue()) != 0 : value instanceof Integer && (valIsFinal = ((Integer)value).intValue()) != 0)) {
            throw new SDKException.PropertyReadOnly(PropertyIDs.SI_CONFIG);
        }
        Property prop = this.m_bag.getItem((Object)propertyID);
        if (prop != null && (origClass = prop.getValue().getClass()) != (newClass = val.getClass())) {
            throw new SDKException.InvalidArg("setValue(): Cannot change the value type.");
        }
        boolean validValue = false;
        if (this.hasValidValues()) {
            IValidValues valVals = this.getValidValues();
            iter = valVals.iterator();
            while (iter.hasNext()) {
                if (!iter.next().equals(val)) continue;
                validValue = true;
                break;
            }
        }
        if (!validValue && this.hasValidRanges()) {
            IValidRanges valRanges = this.getValidRanges();
            if (val instanceof Double) {
                iter = valRanges.iterator();
                while (iter.hasNext()) {
                    ValidRange valRange = (ValidRange)iter.next();
                    if (!((Double)val < valRange.getMaxDouble()) || !((Double)val > valRange.getMinDouble())) continue;
                    validValue = true;
                    break;
                }
            } else if (val instanceof Integer) {
                iter = valRanges.iterator();
                while (iter.hasNext()) {
                    ValidRange valRange = (ValidRange)iter.next();
                    if ((Integer)val > valRange.getMaxInteger() || (Integer)val < valRange.getMinInteger()) continue;
                    validValue = true;
                    break;
                }
            }
        }
        if (!validValue && (this.hasValidValues() || this.hasValidRanges())) {
            throw new SDKException.InvalidArg("setValue(): Invalid value or value out of valid range.");
        }
        if (prop == null) {
            prop = this.m_bag.addItem((Object)propertyID, val, 0);
        } else {
            prop.setValue(val);
        }
        prop = this.m_bag.getItem((Object)PropertyIDs.SI_OVERRIDDEN);
        if (prop == null) {
            prop = this.m_bag.addItem((Object)PropertyIDs.SI_OVERRIDDEN, (Object)new Boolean(true), 0);
        } else {
            prop.setValue((Object)new Boolean(true));
        }
    }

    public boolean isOverridden() {
        Property prop = this.m_bag.getItem((Object)PropertyIDs.SI_OVERRIDDEN);
        if (prop != null) {
            return prop.getBoolean();
        }
        return false;
    }

    public boolean isFinal() {
        Property prop = this.m_bag.getItem((Object)PropertyIDs.SI_FINAL);
        if (prop != null) {
            return prop.getBoolean();
        }
        return false;
    }

    public void setFinal(boolean isFinal) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_FINAL, isFinal);
    }

    public String getName() {
        Property prop = this.m_bag.getItem((Object)PropertyIDs.SI_NAME);
        if (prop != null) {
            return prop.getString();
        }
        return null;
    }

    public void setName(String name) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_NAME, (Object)name);
    }

    public void setErrorInfo(Object badValue, int errorResId) {
        PropertyBag bag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_ERROR_DESCRIPTION);
        if (bag == null && errorResId != 0) {
            bag = this.m_bag.addItem((Object)PropertyIDs.SI_ERROR_DESCRIPTION, null, 0x8000000).getPropertyBag();
        }
        bag.setProperty((Object)PropertyIDs.SI_BAD_VALUE, badValue);
        bag.setProperty((Object)PropertyIDs.SI_ERROR_ID, errorResId);
    }

    public void clearErrorInfo() {
        this.m_bag.remove((Object)PropertyIDs.SI_ERROR_DESCRIPTION);
    }

    public Integer getErrorId() {
        PropertyBag bag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_ERROR_DESCRIPTION);
        if (null == bag) {
            return null;
        }
        Property obj = bag.getItem((Object)PropertyIDs.SI_ERROR_ID);
        if (null == obj) {
            return null;
        }
        Object val = obj.getValue();
        if (val instanceof Integer) {
            return (Integer)val;
        }
        return null;
    }

    protected String getRawErrorString() {
        PropertyBag bag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_ERROR_DESCRIPTION);
        if (bag == null) {
            return null;
        }
        return bag.getString((Object)PropertyIDs.SI_ERROR_STRING);
    }

    public Object getBadValue() {
        PropertyBag bag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_ERROR_DESCRIPTION);
        if (null == bag) {
            return null;
        }
        Property obj = bag.getItem((Object)PropertyIDs.SI_BAD_VALUE);
        return obj.getValue();
    }

    public boolean hasValidRanges() {
        PropertyBag props = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_VALID_RANGES);
        if (props == null) {
            return false;
        }
        return props.getInt((Object)PropertyIDs.SI_TOTAL) > 0;
    }

    public IValidRanges getValidRanges() {
        PropertyBag bag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_VALID_RANGES);
        if (bag == null) {
            this.m_bag.addItem((Object)PropertyIDs.SI_VALID_RANGES, null, 0x8000000);
        }
        return new ValidRanges(this.m_bag.getPropertyBag((Object)PropertyIDs.SI_VALID_RANGES));
    }

    public boolean hasValidValues() {
        PropertyBag props = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_VALID_VALUES);
        if (props == null) {
            return false;
        }
        return props.getInt((Object)PropertyIDs.SI_TOTAL) > 0;
    }

    public IValidValues getValidValues() {
        PropertyBag bag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_VALID_VALUES);
        if (bag == null) {
            this.m_bag.addItem((Object)PropertyIDs.SI_VALID_VALUES, null, 0x8000000);
        }
        return new ValidValues(this.m_bag.getPropertyBag((Object)PropertyIDs.SI_VALID_VALUES));
    }

    public boolean getRequiresRestart() {
        Property obj = this.m_bag.getItem((Object)PropertyIDs.SI_REQUIRES_RESTART);
        if (null == obj) {
            return false;
        }
        Object val = obj.getValue();
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return false;
    }

    public void setRequiresRestart(boolean requiresRestart) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_REQUIRES_RESTART, requiresRestart);
    }

    public Integer getOrder() {
        Property obj = this.m_bag.getItem((Object)PropertyIDs.SI_ORDER);
        if (null == obj) {
            return new Integer(0);
        }
        Object val = obj.getValue();
        if (val instanceof Integer) {
            return (Integer)val;
        }
        return new Integer(0);
    }

    public Integer getGroup() {
        Property obj = this.m_bag.getItem((Object)PropertyIDs.SI_GROUP);
        if (null == obj) {
            return new Integer(0);
        }
        Object val = obj.getValue();
        if (val instanceof Integer) {
            return (Integer)val;
        }
        return new Integer(0);
    }

    public IActualConfigProperties setPropertiesValue() {
        PropertyBag bag = this.m_bag.addItem((Object)PropertyIDs.SI_VALUE, null, 0x8000000).getPropertyBag();
        Property prop = this.m_bag.getItem((Object)PropertyIDs.SI_OVERRIDDEN);
        if (prop == null) {
            prop = this.m_bag.addItem((Object)PropertyIDs.SI_OVERRIDDEN, (Object)new Boolean(true), 0);
        } else {
            prop.setValue((Object)new Boolean(true));
        }
        return new ActualConfigProperties(bag);
    }

    public Integer getConstructorArgIndex() {
        Property argIndex = this.m_bag.getItem((Object)PropertyIDs.SI_CONSTRUCTOR_ARG_INDEX);
        if (argIndex == null) {
            return null;
        }
        Object val = argIndex.getValue();
        if (val instanceof Integer) {
            return (Integer)val;
        }
        return null;
    }

    public void setConstructorArgIndex(Integer index) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_CONSTRUCTOR_ARG_INDEX, (Object)index);
    }

    public String getDisplayName(Locale locale) throws SDKException {
        PropertyBag bag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_ML_DISPLAY_NAME);
        if (bag != null) {
            try {
                return bag.getString(locale);
            }
            catch (Exception e) {
                throw new SDKException.PropertyNotFound(PropertyIDs.SI_ML_DISPLAY_NAME);
            }
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_ML_DISPLAY_NAME);
    }

    public String getDescription(Locale locale) throws SDKException {
        PropertyBag bag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_ML_DESCRIPTION);
        if (bag != null) {
            try {
                return bag.getString(locale);
            }
            catch (Exception e) {
                throw new SDKException.PropertyNotFound(PropertyIDs.SI_ML_DESCRIPTION);
            }
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_ML_DESCRIPTION);
    }

    public void setDisplayName(String name, Locale locale) {
        PropertyBag bag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_ML_DISPLAY_NAME);
        if (bag == null) {
            bag = this.m_bag.addItem((Object)PropertyIDs.SI_ML_DISPLAY_NAME, (Object)new Integer(0), 0x8000000).getPropertyBag();
        }
        bag.setProperty((Object)locale, (Object)name);
    }

    public void setDescription(String description, Locale locale) {
        PropertyBag bag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_ML_DESCRIPTION);
        if (bag == null) {
            bag = this.m_bag.addItem((Object)PropertyIDs.SI_ML_DESCRIPTION, (Object)new Integer(0), 0x8000000).getPropertyBag();
        }
        bag.setProperty((Object)locale, (Object)description);
    }

    public String getErrorString(Locale locale) {
        String errorString = this.getRawErrorString();
        try {
            if (errorString != null) {
                Throwable exception = IException.Factory.deserialize((String)errorString);
                if (exception instanceof IException) {
                    return ((IException)exception).getMessage(locale);
                }
                return exception.getLocalizedMessage();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        Integer errorID = this.getErrorId();
        if (errorID != null) {
            return ServerMsgResourcesBundle.getString(errorID.toString(), locale);
        }
        return null;
    }

    public boolean isValueAccepted() {
        return this.m_bag.getBoolean((Object)PropertyIDs.SI_ACCEPT_VALUE);
    }
}

