/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.common.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.common.IActualConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.IConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.IConfiguredService;
import com.businessobjects.sdk.plugin.desktop.common.IExecProps;
import com.businessobjects.sdk.plugin.desktop.common.IIntegerProps;
import com.businessobjects.sdk.plugin.desktop.common.IStringProps;
import com.businessobjects.sdk.plugin.desktop.common.internal.ActualConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfigProperty;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfiguredServices;
import com.businessobjects.sdk.plugin.desktop.common.internal.ExecProps;
import com.businessobjects.sdk.plugin.desktop.common.internal.IntegerProps;
import com.businessobjects.sdk.plugin.desktop.common.internal.StringProps;
import com.businessobjects.sdk.plugin.desktop.service.IService;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.plugin.desktop.server.IServiceDeploymentConfig;
import com.crystaldecisions.sdk.plugin.desktop.server.internal.ServiceDeploymentConfig;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.ArrayList;
import java.util.Iterator;

public class ConfiguredService
implements IConfiguredService {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.businessobjects.sdk.plugin.desktop.common.internal.ConfiguredService");
    private PropertyBag m_bag;
    private ConfigProperties m_configProps = null;
    private IInternalInfoStore m_infoStore = null;

    ConfiguredService(PropertyBag bag, IInternalInfoStore infoStore) {
        this.m_bag = bag;
        this.m_infoStore = infoStore;
    }

    public ConfiguredService(PropertyBag bag, PropertyBag configProps) {
        this.m_bag = bag;
        this.m_configProps = new ConfigProperties(configProps);
    }

    public IConfigProperties getConfigProps() {
        PropertyBag confBag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_CONFIG);
        if (confBag == null) {
            confBag = this.m_bag.addPropertyBag((Object)PropertyIDs.SI_CONFIG, null).getPropertyBag();
        }
        return new ConfigProperties(confBag);
    }

    public IActualConfigProperties getActualConfigProps() {
        PropertyBag confBag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_CONFIG_ACTUAL);
        if (confBag == null) {
            return null;
        }
        return new ActualConfigProperties(confBag);
    }

    public IExecProps getExecProps() {
        PropertyBag execBag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_EXEC);
        if (execBag == null) {
            execBag = this.m_bag.addPropertyBag((Object)PropertyIDs.SI_EXEC, null).getPropertyBag();
        }
        return new ExecProps(execBag);
    }

    public IStringProps getLocalFiles() {
        PropertyBag localFiles = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_LOCALFILES);
        if (localFiles == null) {
            localFiles = this.m_bag.addArray((Object)PropertyIDs.SI_LOCALFILES).getPropertyBag();
        }
        return new StringProps(localFiles);
    }

    public IServiceDeploymentConfig getDeploymentConfig() {
        return new ServiceDeploymentConfig(this.m_bag);
    }

    public Integer getServiceStatus() {
        return new Integer(this.m_bag.getInt((Object)PropertyIDs.SI_STATUS));
    }

    public void setServiceStatus(int status) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_STATUS, status);
    }

    public Integer getConfigError() {
        return new Integer(this.m_bag.getInt((Object)PropertyIDs.SI_CONFIG_ERROR));
    }

    public void setConfigError(int errorState) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_CONFIG_ERROR, errorState);
    }

    public int getServiceVersion() {
        return this.m_bag.getInt((Object)PropertyIDs.SI_SERVICE_VERSION);
    }

    public void setServiceVersion(int version) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_SERVICE_VERSION, version);
    }

    public String getType() {
        return this.m_bag.getString((Object)PropertyIDs.SI_SERVICE_TYPE);
    }

    public void setType(String type) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_SERVICE_TYPE, (Object)type);
    }

    public String getCUID() {
        return this.m_bag.getString((Object)PropertyIDs.SI_CUID);
    }

    public void setCUID(String cuid) {
        this.m_bag.setProperty((Object)PropertyIDs.SI_CUID, (Object)cuid);
    }

    public IIntegerProps getEnabledAuditEvents() {
        PropertyBag bag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_ENABLED_AUDIT_EVENTS);
        if (bag == null) {
            bag = this.m_bag.addArray((Object)PropertyIDs.SI_ENABLED_AUDIT_EVENTS).getPropertyBag();
        }
        return new IntegerProps(bag, false);
    }

    public boolean isUsingServiceConfigProps() {
        return this.m_bag.getBoolean((Object)PropertyIDs.SI_USE_DEFAULT_VALUES);
    }

    public void useServiceConfigProps() throws SDKException {
        this.applyServiceConfigProps();
        this.m_bag.setProperty((Object)PropertyIDs.SI_USE_DEFAULT_VALUES, (Object)Boolean.TRUE);
    }

    public void useCustomConfigProps() {
        this.m_bag.setProperty((Object)PropertyIDs.SI_USE_DEFAULT_VALUES, (Object)Boolean.FALSE);
    }

    public void resetToServiceConfigProps() throws SDKException {
        this.applyServiceConfigProps();
    }

    public void resetToFactoryConfigProps() throws SDKException {
        ((ConfigProperties)this.getConfigProps()).reset();
    }

    public void setConfigPropsAsDefaults() throws SDKException {
        IService svc;
        if (this.m_configProps == null) {
            IInfoObjects objs = this.m_infoStore.query("select SI_CONFIG, SI_SERVICE_HOSTS from CI_SYSTEMOBJS where SI_PARENTID = 52 and SI_ID = " + this.getID());
            if (objs.size() != 1) {
                throw new SDKException.InvalidObjectID(this.getID());
            }
            svc = (IService)objs.get(0);
            this.copyConfigPropsToService((ConfigProperties)svc.getConfigProps());
            ConfiguredServices css = (ConfiguredServices)svc.getServiceHosts();
            Iterator edgeIter = css.iterator();
            while (edgeIter.hasNext()) {
                ConfiguredService cs = (ConfiguredService)edgeIter.next();
                if (!cs.isUsingServiceConfigProps()) continue;
                ArrayList<Object> edgeCP = new ArrayList<Object>();
                ArrayList<Object> svcCP = new ArrayList<Object>();
                edgeCP.add(cs.getConfigProps());
                svcCP.add(svc.getConfigProps());
                while (edgeCP.size() > 0) {
                    ConfigProperties edgeProps = (ConfigProperties)edgeCP.remove(0);
                    ConfigProperties svcProps = (ConfigProperties)svcCP.remove(0);
                    Iterator edgeConfigPropsIter = edgeProps.iterator();
                    while (edgeConfigPropsIter.hasNext()) {
                        ConfigProperty edgeConfigProp = (ConfigProperty)edgeConfigPropsIter.next();
                        if (edgeConfigProp.getValue() instanceof ConfigProperties) {
                            edgeCP.add(edgeConfigProp.getValue());
                            svcCP.add(svcProps.getProp(edgeConfigProp.getName()).getValue());
                            continue;
                        }
                        if (!edgeConfigProp.getDefaultable() || edgeConfigProp.isFinal()) continue;
                        edgeConfigProp.setValue(svcProps.getProp(edgeConfigProp.getName()).getValue());
                    }
                }
            }
        } else {
            LOG.error((Object)"setConfigPropsAsDefaults(): must obtain the configured container from the Server");
            throw new SDKException.InvalidOperation();
        }
        svc.save();
    }

    public PropertyBag getPropertyBag() {
        return this.m_bag;
    }

    private void ensureConfigProps() throws SDKException {
        int id = this.m_bag.getInt((Object)PropertyIDs.SI_ID);
        String queryStr = "select SI_CONFIG from CI_SYSTEMOBJS where SI_PARENTID = 52 and SI_ID = " + id;
        IInfoObjects objs = this.m_infoStore.query(queryStr);
        if (objs.size() != 1) {
            throw new SDKException.InvalidObjectID(id);
        }
        IProperty prop = ((IInfoObject)objs.get(0)).properties().getProperty(PropertyIDs.SI_CONFIG);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_CONFIG);
        }
        this.m_configProps = new ConfigProperties(((Property)prop).getPropertyBag());
    }

    private void copyConfigPropsToService(ConfigProperties serviceProps) throws SDKException {
        ArrayList<Object> currNested = new ArrayList<Object>();
        ArrayList<Object> origNested = new ArrayList<Object>();
        currNested.add(this.getConfigProps());
        origNested.add(serviceProps);
        while (currNested.size() > 0) {
            ConfigProperties currConfigProps = (ConfigProperties)currNested.remove(0);
            ConfigProperties origConfigProps = (ConfigProperties)origNested.remove(0);
            Iterator currIter = currConfigProps.iterator();
            while (currIter.hasNext()) {
                ConfigProperty currProp = (ConfigProperty)currIter.next();
                String propName = currProp.getName();
                if (currProp.getValue() instanceof ConfigProperties) {
                    currNested.add(currProp.getValue());
                    origNested.add(origConfigProps.getProp(propName).getValue());
                    continue;
                }
                ConfigProperty origCP = (ConfigProperty)origConfigProps.getProp(propName);
                if (origCP.isFinal()) continue;
                Object val = currProp.getValue();
                if (val == null) {
                    throw new SDKException.PropertyNotFound(PropertyIDs.SI_VALUE);
                }
                origCP.setValue(val);
            }
        }
    }

    public int getID() {
        return this.m_bag.getInt((Object)PropertyIDs.SI_ID);
    }

    public void applyServiceConfigProps() throws SDKException {
        if (this.m_configProps == null) {
            this.ensureConfigProps();
        }
        ArrayList<Object> currNested = new ArrayList<Object>();
        ArrayList<Object> origNested = new ArrayList<Object>();
        currNested.add(this.getConfigProps());
        origNested.add(this.m_configProps);
        while (currNested.size() > 0) {
            ConfigProperties currConfigProps = (ConfigProperties)currNested.remove(0);
            ConfigProperties origConfigProps = (ConfigProperties)origNested.remove(0);
            Iterator currIter = currConfigProps.iterator();
            while (currIter.hasNext()) {
                ConfigProperty currProp = (ConfigProperty)currIter.next();
                String propName = currProp.getName();
                if (currProp.getValue() instanceof ConfigProperties) {
                    currNested.add(currProp.getValue());
                    origNested.add(origConfigProps.getProp(propName).getValue());
                    continue;
                }
                if (!currProp.getDefaultable() || currProp.isFinal()) continue;
                ConfigProperty origCP = (ConfigProperty)origConfigProps.getProp(propName);
                Object defaultVal = origCP.getValue();
                if (defaultVal == null) {
                    throw new SDKException.PropertyNotFound(PropertyIDs.SI_VALUE);
                }
                currProp.setValue(defaultVal);
            }
        }
    }
}

