/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.customrole.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.customrole.IRoleRight;
import com.crystaldecisions.celib.misc.ObjectUtils;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IRightBase;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.RightDescriptor;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRightID;
import com.crystaldecisions.sdk.occa.infostore.internal.RightID;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.security.internal.SecurityIDs;
import com.crystaldecisions.sdk.occa.security.internal.SecurityValidator;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import java.util.Locale;
import java.util.Map;

public class RoleRight
implements IRoleRight,
IRightBase,
IPersistRightID,
IRightID {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.businessobjects.sdk.plugin.desktop.customrole.internal.RoleRight");
    private IProperties m_roleProperties;
    private IPluginMgr m_pluginMgr;
    private IPersistRightID m_persistRight;
    private int m_baseID;
    private String m_kind;
    private boolean m_isOwner;
    private String m_applicableKind;
    private String m_scope;
    private boolean m_granted;
    private boolean m_specified;
    private short m_typeID;
    private int m_applicableType;
    private int m_authenticID;
    private Object m_catType;
    static final String ANY = "Any";

    public RoleRight(IPluginMgr pluginMgr, int id, Object kind, boolean owner, Object applicableKind, String scope, boolean granted, boolean specified) throws SDKException {
        this.m_pluginMgr = pluginMgr;
        this.m_baseID = id;
        this.m_kind = SecurityValidator.getRealKind(this.m_pluginMgr, kind);
        this.m_isOwner = owner;
        this.m_applicableKind = RoleRight.getRealApplicableKind(this.m_pluginMgr, applicableKind);
        this.m_scope = SecurityValidator.validateScope(scope);
        this.m_granted = granted;
        if (specified) {
            this.m_roleProperties = new SDKPropertyBag();
            this.m_roleProperties.setProperty((Object)PropertyIDs.SI_RIGHT_ID, this.m_baseID);
            this.m_roleProperties.setProperty((Object)PropertyIDs.SI_RIGHT_KIND, this.m_kind);
            this.m_roleProperties.setProperty((Object)PropertyIDs.SI_OWNER_RIGHT, this.m_isOwner);
            this.m_roleProperties.setProperty((Object)PropertyIDs.SI_RIGHT_APPLIES_TO_KIND, this.m_applicableKind);
            this.m_roleProperties.setProperty((Object)PropertyIDs.SI_RIGHT_SCOPE, this.m_scope);
            this.m_roleProperties.setProperty((Object)PropertyIDs.SI_RIGHT_GRANTED, this.m_granted);
        }
        this.m_specified = specified;
        this.makeAuthenticID();
    }

    public RoleRight(IPluginMgr pluginMgr, IProperties roleProperties) throws SDKException {
        this.m_roleProperties = roleProperties;
        this.m_pluginMgr = pluginMgr;
        this.m_baseID = this.m_roleProperties.getInt(PropertyIDs.SI_RIGHT_ID);
        this.m_kind = this.m_roleProperties.getString(PropertyIDs.SI_RIGHT_KIND);
        if (this.m_kind == null) {
            this.m_kind = "";
        }
        this.m_isOwner = this.m_roleProperties.getBoolean(PropertyIDs.SI_OWNER_RIGHT);
        this.m_applicableKind = this.m_roleProperties.getString(PropertyIDs.SI_RIGHT_APPLIES_TO_KIND);
        if (this.m_applicableKind == null || "".equals(this.m_applicableKind)) {
            this.m_applicableKind = ANY;
        }
        this.m_scope = this.m_roleProperties.getString(PropertyIDs.SI_RIGHT_SCOPE);
        this.m_granted = this.m_roleProperties.getBoolean(PropertyIDs.SI_RIGHT_GRANTED);
        this.m_specified = true;
        this.makeAuthenticID();
    }

    private void makeAuthenticID() throws SDKException {
        this.m_authenticID = SecurityIDs.getAuthenticRightID(this.m_baseID, this.m_kind, this.m_isOwner, this.m_pluginMgr);
        this.m_typeID = "".equals(this.m_kind) ? (short)0 : SecurityValidator.getRightTypeID(this.m_pluginMgr, this.m_kind);
        this.m_applicableType = "".equals(this.m_applicableKind) || ANY.equalsIgnoreCase(this.m_applicableKind) ? 0 : (int)SecurityValidator.getRightTypeID(this.m_pluginMgr, this.m_applicableKind);
    }

    void makePersistRightID(Map persistRightMap) throws SDKException {
        boolean owner = this.getOwnerRight();
        IPersistRightID nonOwnerRight = null;
        if (persistRightMap != null) {
            this.m_persistRight = (IPersistRightID)persistRightMap.get(new Integer(this.m_authenticID));
            if (this.m_persistRight == null && owner) {
                int nonOwnerID = this.m_authenticID & 0xDFFFFFFF;
                nonOwnerRight = (IPersistRightID)persistRightMap.get(new Integer(nonOwnerID));
            }
        }
        if (this.m_persistRight == null) {
            this.m_persistRight = new RightID(this.m_authenticID);
            ((RightID)this.m_persistRight).setPluginMgr(this.m_pluginMgr);
            if (nonOwnerRight != null) {
                ((RightID)this.m_persistRight).setCollectionID(nonOwnerRight.getCollectionID());
                ((RightID)this.m_persistRight).setCategoryID(nonOwnerRight.getCategoryID());
                ((RightID)this.m_persistRight).setDescriptionID(nonOwnerRight.getDescriptionID());
            }
        }
    }

    public void setPersistRight(IPersistRightID persistRight) {
        if (this.m_persistRight == null) {
            this.m_persistRight = persistRight;
        }
    }

    public void assumeProperties(IProperties bag) {
        this.copyProperty(PropertyIDs.SI_RIGHT_ID, bag);
        this.copyProperty(PropertyIDs.SI_RIGHT_KIND, bag);
        this.copyProperty(PropertyIDs.SI_OWNER_RIGHT, bag);
        this.copyProperty(PropertyIDs.SI_RIGHT_APPLIES_TO_KIND, bag);
        this.copyProperty(PropertyIDs.SI_RIGHT_SCOPE, bag);
        this.copyProperty(PropertyIDs.SI_RIGHT_GRANTED, bag);
        this.m_roleProperties = bag;
    }

    private void copyProperty(Integer id, IProperties bag) {
        IProperty property = (IProperty)this.m_roleProperties.get(id);
        if (property != null) {
            bag.setProperty((Object)id, property.getValue());
        }
    }

    public void copy(IProperties properties) {
        properties.putAll(this.m_roleProperties);
    }

    public int getID() {
        return this.m_baseID;
    }

    public String getKind() {
        return this.m_kind;
    }

    public boolean getOwnerRight() {
        return this.m_isOwner;
    }

    public void setOwnerRight(boolean isOwner) {
        this.m_roleProperties.setProperty((Object)PropertyIDs.SI_OWNER_RIGHT, isOwner);
        this.m_isOwner = isOwner;
    }

    public String getApplicableKind() {
        return this.m_applicableKind;
    }

    public void setApplicableKind(String kind) throws SDKException {
        this.m_roleProperties.setProperty((Object)PropertyIDs.SI_RIGHT_APPLIES_TO_KIND, RoleRight.getRealApplicableKind(this.m_pluginMgr, kind));
        this.m_applicableKind = kind;
    }

    public String getScope() {
        return this.m_scope;
    }

    public void setScope(String scope) throws SDKException {
        String realScope = SecurityValidator.validateScope(scope);
        this.m_roleProperties.setProperty((Object)PropertyIDs.SI_RIGHT_SCOPE, realScope);
        this.m_scope = scope;
    }

    public boolean getGranted() {
        return this.m_granted;
    }

    public void setGranted(boolean granted) {
        this.m_roleProperties.setProperty((Object)PropertyIDs.SI_RIGHT_GRANTED, granted);
        this.m_granted = granted;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RoleRight) {
            RoleRight rr = (RoleRight)obj;
            return rr.getID() == this.getID() && ObjectUtils.equalsIgnoreCase((String)rr.getKind(), (String)this.getKind()) && rr.getOwnerRight() == this.getOwnerRight() && ObjectUtils.equalsIgnoreCase((String)rr.getScope(), (String)this.getScope()) && ObjectUtils.equalsIgnoreCase((String)rr.getApplicableKind(), (String)this.getApplicableKind());
        }
        return false;
    }

    public int hashCode() {
        String kind = this.getKind();
        String applicableKind = this.getApplicableKind();
        return this.getID() + (kind != null ? kind.hashCode() : 0) + Boolean.valueOf(this.getOwnerRight()).hashCode() + this.getScope().hashCode() + (applicableKind != null ? applicableKind.hashCode() : 0);
    }

    static String getRealApplicableKind(IPluginMgr pluginmgr, Object applicableKind) throws SDKException {
        if (SecurityValidator.isEmptyType(applicableKind) || applicableKind instanceof String && ANY.equalsIgnoreCase((String)applicableKind)) {
            return ANY;
        }
        return SecurityValidator.getRealKind(pluginmgr, applicableKind);
    }

    static String getRealProgID(IPluginMgr pluginmgr, Object applicableKind) throws SDKException {
        if (SecurityValidator.isEmptyType(applicableKind) || applicableKind instanceof String && ANY.equalsIgnoreCase((String)applicableKind)) {
            return ANY;
        }
        return SecurityValidator.getRealProgID(pluginmgr, applicableKind);
    }

    public String toString() {
        return "right=" + this.getID() + ";kind=" + this.getKind() + ";owner=" + this.getOwnerRight() + ";scope=" + this.getScope() + ";applicableKind=" + this.getApplicableKind() + ";granted=" + this.getGranted();
    }

    public String getDescription(Locale locale) {
        if (this.m_persistRight != null) {
            return this.m_persistRight.getDescription(locale);
        }
        return "";
    }

    public String getCategory(Locale locale) {
        if (this.m_persistRight != null) {
            return ((RightID)this.m_persistRight).getCategory(locale, this.getCategoryType());
        }
        return "";
    }

    Object getCategoryType() {
        if (this.m_catType == null) {
            this.m_catType = this.getApplicableKind();
            if (this.getRightPluginType() > 0) {
                this.m_catType = new Integer(this.getRightPluginType());
            }
        }
        return this.m_catType;
    }

    public String getCollection(Locale locale) {
        if (this.m_persistRight != null) {
            return ((RightID)this.m_persistRight).getCollection(locale, this.getCategoryType());
        }
        return "";
    }

    public String getObjectType() {
        return this.getApplicableKind();
    }

    public int getApplicableType() {
        return this.m_applicableType;
    }

    public boolean isGranted() {
        return this.getGranted();
    }

    public boolean isSpecified() {
        return this.m_specified;
    }

    public RightDescriptor getRightDescriptor() {
        return new RightDescriptor(this.getID(), this.getKind(), this.getOwnerRight(), this.getScope(), this.getApplicableKind());
    }

    public boolean isOwner() {
        return this.getOwnerRight();
    }

    public int getBaseID() {
        return this.getID();
    }

    public String getRightPluginKind() {
        return this.getKind();
    }

    public int getRightPluginType() {
        return this.m_typeID;
    }

    int getAuthenticID() {
        return this.m_authenticID;
    }

    public String getDescriptionID() {
        return this.m_persistRight.getDescriptionID();
    }

    public String getCategoryID() {
        return this.m_persistRight.getCategoryID();
    }

    public int getCollectionID() {
        return ((RightID)this.m_persistRight).getCollectionID(this.getCategoryType());
    }
}

