/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.deltastore.internal;

import com.businessobjects.sdk.plugin.desktop.deltastore.IDeltaStore;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.info_wire_ob3;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IFiles;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo2;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.properties.internal.PropContainerHelper;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.Iterator;

public class DeltaStore
extends AbstractInfoObject
implements IDeltaStore {
    private String m_modelDelta;
    private PropertyBag m_modelBag;
    private PropertyBag m_customBag;
    private PropContainerHelper.Set m_modelCuidSet;
    private PropContainerHelper.Map m_cuid2deltaMap;

    protected DeltaStore() {
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setupProperties();
        this.setParentID(49);
    }

    public void unpack(ISecuritySession session, IInfoObjects collection, info_wire_ob3 obj) {
        super.unpack(session, collection, obj);
        this.setupProperties();
    }

    public void setDelta(String cuid, String delta) throws SDKException {
        if (cuid == null || delta == null) {
            throw new SDKException.InvalidArg("null");
        }
        this.m_modelCuidSet.remove(cuid);
        this.m_cuid2deltaMap.put(cuid, delta);
    }

    public void setDelta(IInfoObject infoObject) throws SDKException {
        this.setDelta(infoObject.getCUID(), infoObject.getDelta());
    }

    public void setDelta(IInfoObjects infoObjects) throws SDKException {
        Iterator itr = infoObjects.iterator();
        while (itr.hasNext()) {
            this.setDelta((IInfoObject)itr.next());
        }
    }

    public void setModel(String delta) throws SDKException {
        if (delta == null) {
            throw new SDKException.InvalidArg("null");
        }
        this.m_modelBag.setProperty((Object)PropertyIDs.SI_DELTA, (Object)delta);
        this.m_modelDelta = delta;
    }

    public void setModel(IInfoObject infoObject) throws SDKException {
        this.setModel(infoObject.getDelta());
    }

    public String getModel() {
        return this.m_modelDelta;
    }

    public void useModel(String cuid) throws SDKException {
        if (cuid == null) {
            throw new SDKException.InvalidArg("null");
        }
        if (this.m_modelDelta == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_DELTA);
        }
        this.m_cuid2deltaMap.remove(cuid);
        this.m_modelCuidSet.add(cuid);
    }

    public void useModel(IInfoObject infoObject) throws SDKException {
        if (infoObject == null) {
            throw new SDKException.InvalidArg("null");
        }
        this.useModel(infoObject.getCUID());
    }

    public void useModel(IInfoObjects infoObjects) throws SDKException {
        Iterator itr = infoObjects.iterator();
        while (itr.hasNext()) {
            this.useModel((IInfoObject)itr.next());
        }
    }

    public String getStoredDelta(String cuid) throws SDKException {
        if (cuid == null) {
            throw new SDKException.InvalidArg("null");
        }
        String result = null;
        if (this.m_cuid2deltaMap.containsKey(cuid)) {
            result = (String)this.m_cuid2deltaMap.get(cuid);
        } else if (this.m_modelCuidSet.contains(cuid)) {
            result = this.m_modelDelta;
        }
        return result;
    }

    public boolean update(IInfoObject infoObject) throws SDKException {
        if (infoObject == null) {
            throw new SDKException.InvalidArg("null");
        }
        String storDelta = this.getStoredDelta(infoObject.getCUID());
        if (storDelta != null) {
            return infoObject.applyDelta(storDelta);
        }
        return false;
    }

    public boolean update(IInfoObjects infoObjects) throws SDKException {
        boolean result = !infoObjects.isEmpty();
        Iterator itr = infoObjects.iterator();
        while (itr.hasNext()) {
            if (this.update((IInfoObject)itr.next())) continue;
            result = false;
        }
        return result;
    }

    public boolean remove(String cuid) throws SDKException {
        if (cuid == null) {
            throw new SDKException.InvalidArg("null");
        }
        return this.m_modelCuidSet.remove(cuid) || this.m_cuid2deltaMap.remove(cuid) != null;
    }

    public String[] getCustomCuids() {
        return (String[])this.m_cuid2deltaMap.keyArray(new String[this.m_cuid2deltaMap.size()]);
    }

    public String[] getModelCuids() {
        return (String[])this.m_modelCuidSet.toArray(new String[this.m_modelCuidSet.size()]);
    }

    public String[] getAllCuids() {
        String[] a1 = this.getModelCuids();
        String[] a2 = this.getCustomCuids();
        String[] result = new String[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    public void clear() {
        PropertyBag props = (PropertyBag)this.properties();
        props.removeLocal((Object)PropertyIDs.SI_MODELCUID_SET);
        props.removeLocal((Object)PropertyIDs.SI_CUID2DELTA_MAP);
        this.m_modelDelta = null;
        this.m_modelBag = null;
        this.m_customBag = null;
        this.m_modelCuidSet = null;
        this.m_cuid2deltaMap = null;
        this.setupProperties();
    }

    public void initFromSerialization(ISecuritySession session, String packedRootProps, String packedSerProps, IFiles files, ISecurityInfo securityInfo, ISecurityInfo2 securityInfo2) throws SDKException {
        super.initFromSerialization(session, packedRootProps, packedSerProps, files, securityInfo, securityInfo2);
        this.setupProperties();
    }

    private void setupProperties() {
        Property modelBagProp = (Property)this.getProperty(PropertyIDs.SI_MODELCUID_SET);
        if (modelBagProp == null) {
            modelBagProp = (Property)this.addProperty(PropertyIDs.SI_MODELCUID_SET, null, 0x8000000);
        }
        this.m_modelBag = modelBagProp.getPropertyBag();
        Property modelDeltaProp = this.m_modelBag.getItem((Object)PropertyIDs.SI_DELTA);
        if (modelDeltaProp != null) {
            this.m_modelDelta = this.m_modelBag.getItem((Object)PropertyIDs.SI_DELTA).getString();
        }
        this.m_modelCuidSet = new PropContainerHelper.Set(this.m_modelBag, PropertyIDs.SI_CUID);
        Property customBagProp = (Property)this.getProperty(PropertyIDs.SI_CUID2DELTA_MAP);
        if (customBagProp == null) {
            customBagProp = (Property)this.addProperty(PropertyIDs.SI_CUID2DELTA_MAP, null, 0x8000000);
        }
        this.m_customBag = customBagProp.getPropertyBag();
        this.m_cuid2deltaMap = new PropContainerHelper.Map(this.m_customBag, PropertyIDs.SI_CUID, PropertyIDs.SI_DELTA);
    }
}

