/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.manifest.internal;

import com.businessobjects.sdk.plugin.desktop.manifest.IIncludedDependency;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.ISDKElement;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;

public class IncludedDependency
implements IIncludedDependency,
ISDKElement {
    private IProperties m_props;

    public IncludedDependency(IProperties props) {
        this.m_props = props;
    }

    public IncludedDependency(String dependency, int type) {
        this.m_props = new SDKPropertyBag();
        this.m_props.setProperty((Object)PropertyIDs.SI_RELATIONSHIP_NAME, dependency);
        this.m_props.setProperty((Object)PropertyIDs.SI_RELATIONSHIP_DIRECTION, type);
    }

    public String getRelationshipName() {
        Property prop = (Property)this.m_props.getProperty(PropertyIDs.SI_RELATIONSHIP_NAME);
        if (prop == null) {
            return null;
        }
        return prop.getString();
    }

    public int getRelationshipDirection() {
        Property prop = (Property)this.m_props.getProperty(PropertyIDs.SI_RELATIONSHIP_DIRECTION);
        if (prop == null) {
            return 0;
        }
        return prop.getInt();
    }

    public void setRelationshipDirection(int direction) throws SDKException {
        if (direction < 1 || direction > 2) {
            throw new SDKException.InvalidArg(direction);
        }
        this.m_props.setProperty((Object)PropertyIDs.SI_RELATIONSHIP_DIRECTION, direction);
    }

    public void assumeProperties(IProperties bag) {
        this.copyProperty(PropertyIDs.SI_RELATIONSHIP_NAME, bag);
        this.copyProperty(PropertyIDs.SI_RELATIONSHIP_DIRECTION, bag);
        this.m_props = bag;
    }

    private void copyProperty(Integer id, IProperties bag) {
        IProperty property = this.m_props.getProperty(id);
        if (property != null) {
            bag.setProperty((Object)id, property.getValue());
        }
    }

    public void copy(IProperties properties) {
        properties.putAll(this.m_props);
    }

    public boolean equals(Object o) {
        if (o instanceof IncludedDependency) {
            IncludedDependency other = (IncludedDependency)o;
            return other.getRelationshipName().equals(this.getRelationshipName());
        }
        return false;
    }

    public int hashCode() {
        return this.getRelationshipName().hashCode();
    }
}

