/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.metricdescriptions;

public class ValueFormat {
    private String m_formatName;
    private int m_format;
    public static final ValueFormat HIDDEN = new ValueFormat(-2);
    public static final ValueFormat UNKNOWN = new ValueFormat(-1);
    public static final ValueFormat STRING = new ValueFormat(0);
    public static final ValueFormat INTEGER = new ValueFormat(1);
    public static final ValueFormat FLOAT = new ValueFormat(2);
    public static final ValueFormat PERCENT = new ValueFormat(3);
    public static final ValueFormat DATETIME = new ValueFormat(4);
    public static final ValueFormat PROPBAG = new ValueFormat(6);
    public static final ValueFormat BOOLEAN = new ValueFormat(7);
    public static final ValueFormat STRING_MAP = new ValueFormat(8);
    public static final ValueFormat SHIFTSIZE_KB = new ValueFormat(9);
    public static final ValueFormat SHIFTSIZE_MB = new ValueFormat(10);
    public static final ValueFormat SHIFTSIZE_GB = new ValueFormat(11);

    private ValueFormat(int format) {
        this.m_format = format;
        switch (format) {
            case -2: {
                this.m_formatName = "Hidden";
                break;
            }
            case 0: {
                this.m_formatName = "String";
                break;
            }
            case 1: {
                this.m_formatName = "Integer";
                break;
            }
            case 2: {
                this.m_formatName = "Float";
                break;
            }
            case 3: {
                this.m_formatName = "Percent";
                break;
            }
            case 4: {
                this.m_formatName = "DateTime";
                break;
            }
            case 6: {
                this.m_formatName = "PropBag";
                break;
            }
            case 7: {
                this.m_formatName = "Boolean";
                break;
            }
            case 8: {
                this.m_formatName = "StringMap";
                break;
            }
            case 9: {
                this.m_formatName = "ShiftSizeKB";
                break;
            }
            case 10: {
                this.m_formatName = "ShiftSizeMB";
                break;
            }
            case 11: {
                this.m_formatName = "ShiftSizeGB";
                break;
            }
            default: {
                this.m_formatName = "Unknown";
            }
        }
    }

    public String toString() {
        return this.m_formatName;
    }

    public static ValueFormat fromString(String s) {
        if ((s = s.trim()).compareToIgnoreCase("Hidden") == 0) {
            return HIDDEN;
        }
        if (s.compareToIgnoreCase("String") == 0) {
            return STRING;
        }
        if (s.compareToIgnoreCase("Integer") == 0) {
            return INTEGER;
        }
        if (s.compareToIgnoreCase("Float") == 0) {
            return FLOAT;
        }
        if (s.compareToIgnoreCase("Percent") == 0) {
            return PERCENT;
        }
        if (s.compareToIgnoreCase("DateTime") == 0) {
            return DATETIME;
        }
        if (s.compareToIgnoreCase("PropBag") == 0) {
            return PROPBAG;
        }
        if (s.compareToIgnoreCase("Boolean") == 0) {
            return BOOLEAN;
        }
        if (s.compareToIgnoreCase("StringMap") == 0) {
            return STRING_MAP;
        }
        if (s.compareToIgnoreCase("ShiftSizeKB") == 0) {
            return SHIFTSIZE_KB;
        }
        if (s.compareToIgnoreCase("ShiftSizeMB") == 0) {
            return SHIFTSIZE_MB;
        }
        if (s.compareToIgnoreCase("ShiftSizeGB") == 0) {
            return SHIFTSIZE_GB;
        }
        return UNKNOWN;
    }

    public static ValueFormat fromInteger(int i) {
        switch (i) {
            case -2: {
                return HIDDEN;
            }
            case 1: {
                return INTEGER;
            }
            case 2: {
                return FLOAT;
            }
            case 3: {
                return PERCENT;
            }
            case 4: {
                return DATETIME;
            }
            case 6: {
                return PROPBAG;
            }
            case 7: {
                return BOOLEAN;
            }
            case 8: {
                return STRING_MAP;
            }
            case 9: {
                return SHIFTSIZE_KB;
            }
            case 10: {
                return SHIFTSIZE_MB;
            }
            case 11: {
                return SHIFTSIZE_GB;
            }
        }
        return UNKNOWN;
    }

    public int toInteger() {
        return this.m_format;
    }
}

