/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.metricdescriptions.internal;

import com.businessobjects.sdk.plugin.desktop.metricdescriptions.IMLDescriptions;
import com.businessobjects.sdk.plugin.desktop.metricdescriptions.IMetricDescriptions;
import com.businessobjects.sdk.plugin.desktop.metricdescriptions.IPropertyBagRenderTemplate;
import com.businessobjects.sdk.plugin.desktop.metricdescriptions.internal.MLDescriptions;
import com.businessobjects.sdk.plugin.desktop.metricdescriptions.internal.PropertyBagRenderTemplate;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MetricDescriptions
extends AbstractInfoObject
implements IMetricDescriptions {
    private HashMap m_interfaces = null;
    private HashMap m_propBagTemplates = null;
    private MLDescriptions m_serverKinds = null;
    private Map m_stringMaps = null;

    private void initMetricDescriptions() throws SDKException {
        Property metricDescriptions = (Property)this.properties().getProperty(PropertyIDs.SI_METRIC_DESCRIPTIONS);
        if (metricDescriptions == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_METRIC_DESCRIPTIONS);
        }
        if (metricDescriptions.isContainer()) {
            this.m_interfaces = new HashMap();
            PropertyBag metricDescriptionsBag = metricDescriptions.getPropertyBag();
            Iterator iter = metricDescriptionsBag.allIterator();
            while (iter.hasNext()) {
                Property svcInterface = (Property)iter.next();
                if (!svcInterface.isContainer()) continue;
                PropertyBag svcInterfaceBag = svcInterface.getPropertyBag();
                String serviceInterfaceName = svcInterfaceBag.getString((Object)PropertyIDs.SI_SERVICE_INTERFACE);
                PropertyBag svcInterfaceMetrics = svcInterfaceBag.getPropertyBag((Object)PropertyIDs.SI_METRICS);
                this.m_interfaces.put(serviceInterfaceName, svcInterfaceMetrics);
            }
        }
    }

    private MLDescriptions initialize(Integer mainID, Integer keyID) throws SDKException {
        Property mainBag = (Property)this.properties().getProperty(mainID);
        if (mainBag == null) {
            throw new SDKException.PropertyNotFound(mainID);
        }
        return new MLDescriptions(mainBag.getPropertyBag(), keyID);
    }

    public Set getServiceInterfaceNames() throws SDKException {
        if (this.m_interfaces == null) {
            this.initMetricDescriptions();
        }
        return this.m_interfaces.keySet();
    }

    public IMLDescriptions getMetricDescriptions(String serviceInterfaceName) throws SDKException {
        PropertyBag propBag;
        if (this.m_interfaces == null) {
            this.initMetricDescriptions();
        }
        if ((propBag = (PropertyBag)this.m_interfaces.get(serviceInterfaceName)) == null) {
            return null;
        }
        return new MLDescriptions(propBag, PropertyIDs.SI_NAME);
    }

    public Set getServerKinds() throws SDKException {
        if (this.m_serverKinds == null) {
            this.m_serverKinds = this.initialize(PropertyIDs.SI_SERVER_KIND_DESCRIPTIONS, PropertyIDs.SI_SERVER_KIND);
        }
        return this.m_serverKinds.keySet();
    }

    public String getServerKindDescription(String serverKind, Locale locale) throws SDKException {
        if (this.m_serverKinds == null) {
            this.m_serverKinds = this.initialize(PropertyIDs.SI_SERVER_KIND_DESCRIPTIONS, PropertyIDs.SI_SERVER_KIND);
        }
        return this.m_serverKinds.getDescription(serverKind, locale);
    }

    public String getMLDescription(String propertyName, String value, Locale locale) {
        MLDescriptions mlDescs;
        if (this.m_stringMaps == null) {
            this.initializeStringMaps();
        }
        if ((mlDescs = (MLDescriptions)this.m_stringMaps.get(propertyName)) == null) {
            return null;
        }
        return mlDescs.getDescription(value, locale);
    }

    private void initializeStringMaps() {
        this.m_stringMaps = new HashMap();
        PropertyBag stringMaps = ((PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_STRING_MAPS);
        PropertyArrayHelper pahOuter = new PropertyArrayHelper(stringMaps, PropertyIDs.SI_TOTAL);
        Iterator outerIter = pahOuter.iterator();
        while (outerIter.hasNext()) {
            PropertyBag outerBag = (PropertyBag)outerIter.next();
            PropertyBag innerBag = outerBag.getPropertyBag((Object)PropertyIDs.SI_VALUE);
            MLDescriptions mlDescs = new MLDescriptions(innerBag, PropertyIDs.SI_NAME);
            this.m_stringMaps.put(outerBag.getString((Object)PropertyIDs.SI_NAME), mlDescs);
        }
    }

    public Set getPropertyBagRenderTemplateNames() {
        if (this.m_propBagTemplates == null) {
            this.initPropBagTemplates();
        }
        return this.m_propBagTemplates.keySet();
    }

    public IPropertyBagRenderTemplate getPropertyBagRenderTemplate(String name) {
        if (this.m_propBagTemplates == null) {
            this.initPropBagTemplates();
        }
        return (IPropertyBagRenderTemplate)this.m_propBagTemplates.get(name);
    }

    private void initPropBagTemplates() {
        this.m_propBagTemplates = new HashMap();
        PropertyArrayHelper pap = new PropertyArrayHelper(((PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_PROPBAG_TEMPLATES), PropertyIDs.SI_TOTAL);
        Iterator iter = pap.iterator();
        while (iter.hasNext()) {
            PropertyBag bag = (PropertyBag)iter.next();
            PropertyBagRenderTemplate template = new PropertyBagRenderTemplate(bag);
            this.m_propBagTemplates.put(template.getName(), template);
        }
    }
}

