/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.metricdescriptions.internal;

import com.businessobjects.sdk.plugin.desktop.metricdescriptions.IPropertyBagRenderTemplate;
import com.businessobjects.sdk.plugin.desktop.metricdescriptions.IPropertyRenderTemplates;
import com.businessobjects.sdk.plugin.desktop.metricdescriptions.ValueFormat;
import com.businessobjects.sdk.plugin.desktop.metricdescriptions.internal.MLDescriptions;
import com.businessobjects.sdk.plugin.desktop.metricdescriptions.internal.PropertyRenderTemplates;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.Locale;
import java.util.Set;

public class PropertyBagRenderTemplate
implements IPropertyBagRenderTemplate {
    private PropertyBag m_bag;
    private MLDescriptions m_labels;
    private PropertyRenderTemplates m_propTemplates;
    private boolean m_hasLabels;

    PropertyBagRenderTemplate(PropertyBag bag) {
        this.m_bag = bag;
        this.m_hasLabels = true;
    }

    public String getName() {
        return this.m_bag.getString((Object)PropertyIDs.SI_NAME);
    }

    public String getPropNamePrefix() {
        String prefix = this.m_bag.getString((Object)PropertyIDs.SI_PROPNAME_PREFIX);
        if (prefix == null) {
            return "";
        }
        return prefix;
    }

    public String getTotalID() {
        return this.m_bag.getString((Object)PropertyIDs.SI_TOTAL_ID);
    }

    public String getSubRenderTemplateName() {
        return this.m_bag.getString((Object)PropertyIDs.SI_TEMPLATE_NAME);
    }

    public Set getLabelNames() {
        if (this.m_labels == null && this.m_hasLabels) {
            this.initializeLabels();
        }
        return this.m_labels.keySet();
    }

    public String getLabel(String name, Locale locale) {
        if (this.m_labels == null) {
            this.initializeLabels();
        }
        return this.m_labels.getDescription(name, locale);
    }

    private void initializeLabels() {
        if (this.m_bag.getPropertyBag((Object)PropertyIDs.SI_LABELS) == null) {
            this.m_hasLabels = false;
        } else {
            this.m_labels = new MLDescriptions(this.m_bag.getPropertyBag((Object)PropertyIDs.SI_LABELS), PropertyIDs.SI_NAME);
        }
    }

    public IPropertyRenderTemplates getPropertyRenderTemplates() {
        if (this.m_propTemplates == null) {
            this.m_propTemplates = new PropertyRenderTemplates(this.m_bag.getPropertyBag((Object)PropertyIDs.SI_PROP_TEMPLATES));
        }
        return this.m_propTemplates;
    }

    public ValueFormat getValueFormat() {
        Property prop = this.m_bag.getItem((Object)PropertyIDs.SI_FORMAT);
        if (prop != null) {
            return ValueFormat.fromInteger(prop.getInt());
        }
        return null;
    }
}

