/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.profile.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.profile.IProfileValue;
import com.businessobjects.sdk.plugin.desktop.profile.IProfileValueItems;
import com.businessobjects.sdk.plugin.desktop.profile.internal.ProfileValueItems;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import java.util.Set;

public class ProfileValue
implements IProfileValue {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.businessobjects.sdk.plugin.desktop.profile.internal.ProfileValue");
    private PropertyBag m_bag;
    private Set m_profileRelations;

    public ProfileValue() {
    }

    public ProfileValue(PropertyBag bag, Set profileRelations) {
        this.m_bag = bag;
        this.m_profileRelations = profileRelations;
        LOG.assertNotNull((Object)this.m_profileRelations, "Profile relation bag is null.");
    }

    public void initialize(int profileID) throws SDKException {
        if (this.m_bag == null) {
            this.m_bag = new SDKPropertyBag();
        }
        this.setProfileID(profileID);
        this.setFormula("");
    }

    public int getProfileID() {
        return this.m_bag.getInt((Object)PropertyIDs.SI_ID);
    }

    public void setProfileID(int id) throws SDKException {
        int oldID = this.getProfileID();
        if (oldID == id) {
            return;
        }
        if (this.m_profileRelations == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_PRINCIPAL_PROFILES);
        }
        Integer profileID = new Integer(id);
        if (this.m_profileRelations.contains(profileID)) {
            throw new SDKException.InvalidArg(id);
        }
        if (oldID != 0) {
            this.m_profileRelations.remove(new Integer(oldID));
        }
        this.m_bag.setProperty((Object)PropertyIDs.SI_ID, (Object)profileID);
        this.m_profileRelations.add(profileID);
    }

    public String getFormula() {
        return this.getFormula("FullClient");
    }

    public void setFormula(String formula) throws SDKException {
        this.setFormula("FullClient", formula);
    }

    public void setTargetType(int targetType) throws SDKException {
        if (targetType < 1 || targetType > 2) {
            throw new SDKException.InvalidArg(targetType);
        }
        this.m_bag.setProperty((Object)PropertyIDs.SI_TYPE, targetType);
        if (targetType == 1) {
            this.m_bag.remove((Object)PropertyIDs.SI_VALUES);
        } else {
            this.m_bag.remove((Object)PropertyIDs.SI_PROFILE_CREXPRESSION);
            this.m_bag.remove((Object)PropertyIDs.SI_PROFILE_FCEXPRESSION);
            this.m_bag.remove((Object)PropertyIDs.SI_PROFILE_WEBIEXPRESSION);
        }
    }

    public String getFormula(String kind) {
        if (this.getTargetType() == 1) {
            if (kind == null) {
                return null;
            }
            if (kind.equals("CrystalReport")) {
                return this.m_bag.getString((Object)PropertyIDs.SI_PROFILE_CREXPRESSION);
            }
            if (kind.equals("FullClient")) {
                return this.m_bag.getString((Object)PropertyIDs.SI_PROFILE_FCEXPRESSION);
            }
            if (kind.equals("Webi")) {
                return this.m_bag.getString((Object)PropertyIDs.SI_PROFILE_WEBIEXPRESSION);
            }
        }
        return null;
    }

    public void setFormula(String kind, String formula) throws SDKException {
        this.checkDocumentKind(kind);
        this.setTargetType(1);
        if (kind.equals("CrystalReport")) {
            this.m_bag.setProperty((Object)PropertyIDs.SI_PROFILE_CREXPRESSION, (Object)formula);
        } else if (kind.equals("FullClient")) {
            this.m_bag.setProperty((Object)PropertyIDs.SI_PROFILE_FCEXPRESSION, (Object)formula);
        } else if (kind.equals("Webi")) {
            this.m_bag.setProperty((Object)PropertyIDs.SI_PROFILE_WEBIEXPRESSION, (Object)formula);
        }
    }

    public String getInternalFormula(String kind) {
        if (kind == null) {
            return null;
        }
        if (this.getTargetType() == 1 && kind.equals("Webi")) {
            return this.m_bag.getString((Object)PropertyIDs.SI_PROFILE_WEBIINTERNALEXPRESSION);
        }
        return null;
    }

    public void setInternalFormula(String kind, String formula) throws SDKException {
        this.checkDocumentKind(kind);
        this.setTargetType(1);
        if (kind.equals("Webi")) {
            this.m_bag.setProperty((Object)PropertyIDs.SI_PROFILE_WEBIINTERNALEXPRESSION, (Object)formula);
        }
    }

    public int getTargetType() {
        Property type = this.m_bag.getItem((Object)PropertyIDs.SI_TYPE);
        if (type == null) {
            return 1;
        }
        return this.m_bag.getInt((Object)PropertyIDs.SI_TYPE);
    }

    public IProfileValueItems getValues() {
        PropertyBag tBag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_VALUES);
        if (tBag == null) {
            tBag = this.m_bag.addArray((Object)PropertyIDs.SI_VALUES).getPropertyBag();
        }
        return new ProfileValueItems(tBag);
    }

    private void checkDocumentKind(String kind) throws SDKException {
        if (kind == null || kind.length() < 1) {
            throw new SDKException.InvalidArg("Document type did not specify");
        }
        if (!(kind.equals("CrystalReport") || kind.equals("Webi") || kind.equals("FullClient"))) {
            throw new SDKException.InvalidArg("Kind should be one of CrystalReport, Webi and FullClient");
        }
    }

    public void removeFormula(String kind) throws SDKException {
        this.checkDocumentKind(kind);
        this.setTargetType(1);
        if (kind.equals("CrystalReport")) {
            if (this.m_bag.containsKey((Object)PropertyIDs.SI_PROFILE_CREXPRESSION)) {
                this.m_bag.remove((Object)PropertyIDs.SI_PROFILE_CREXPRESSION);
            }
            return;
        }
        if (kind.equals("FullClient")) {
            if (this.m_bag.containsKey((Object)PropertyIDs.SI_PROFILE_FCEXPRESSION)) {
                this.m_bag.remove((Object)PropertyIDs.SI_PROFILE_FCEXPRESSION);
            }
            return;
        }
        if (kind.equals("Webi") && this.m_bag.containsKey((Object)PropertyIDs.SI_PROFILE_WEBIEXPRESSION)) {
            this.m_bag.remove((Object)PropertyIDs.SI_PROFILE_WEBIEXPRESSION);
        }
    }
}

