/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.publication.internal;

import com.businessobjects.sdk.plugin.desktop.common.internal.AbstractPrincipal;
import com.businessobjects.sdk.plugin.desktop.profile.IProfileValue;
import com.businessobjects.sdk.plugin.desktop.profile.IProfileValues;
import com.businessobjects.sdk.plugin.desktop.publication.internal.Publication;
import com.businessobjects.sdk.plugin.desktop.publication.internal.Scope;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.plugin.desktop.user.IUser;
import com.crystaldecisions.sdk.plugin.desktop.usergroup.IUserGroup;
import java.lang.ref.SoftReference;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

class ProfileResolutionEngine {
    private static final int TOP_N = 10000;
    private Publication m_publication;
    private IInternalInfoStore m_infoStore;
    private Set m_effectiveProfiles;
    private Map m_profileValues;
    private Map m_ancestorMap;
    private SoftReference m_cacheRef;

    ProfileResolutionEngine(Publication publication, IInternalInfoStore infoStore) {
        this.m_publication = publication;
        this.m_infoStore = infoStore;
        this.m_cacheRef = new SoftReference<Object>(null);
    }

    public Set findScopes() throws SDKException {
        HashSet scopes = null;
        HashSet explicitSubscribers = new HashSet(this.m_publication.getPrincipals());
        explicitSubscribers.removeAll(this.m_publication.getExcludedPrincipals());
        if (explicitSubscribers.size() > 0) {
            this.getProfileValuesFromAllPrincipals();
            scopes = new HashSet(this.findScopesForAllRecipients(explicitSubscribers));
        } else {
            scopes = Collections.EMPTY_SET;
        }
        return scopes;
    }

    private void getProfileValuesFromAllPrincipals() throws SDKException {
        this.m_profileValues = new HashMap();
        this.m_effectiveProfiles = this.m_publication.getEffectiveProfiles();
        if (this.m_effectiveProfiles.size() > 0) {
            String select = "SI_OBTYPE, SI_PROFILE_VALUES FROM CI_SYSTEMOBJS";
            String where = "Descendents(\"SI_NAME = 'Profile-Principal'\", \"SI_ID in (" + ProfileResolutionEngine.buildIDList(this.m_effectiveProfiles) + ")\")";
            IInfoObjects objs = this.queryNextBatchOfObjects(select, where, null);
            do {
                for (int i = 0; i < objs.size(); ++i) {
                    AbstractPrincipal principal = (AbstractPrincipal)objs.get(i);
                    IProfileValues profileValues = principal.getProfileValues();
                    Iterator iter = profileValues.iterator();
                    while (iter.hasNext()) {
                        IProfileValue v = (IProfileValue)iter.next();
                        if (!this.m_effectiveProfiles.contains(new Integer(v.getProfileID()))) continue;
                        Integer principalID = new Integer(principal.getID());
                        Scope scope = (Scope)this.m_profileValues.get(principalID);
                        if (scope == null) {
                            scope = new Scope();
                            this.m_profileValues.put(principalID, scope);
                        }
                        scope.putProfileValue(v.getProfileID(), v.getFormula());
                    }
                }
            } while ((objs = this.queryNextBatchOfObjects(select, where, objs)).size() > 0);
        }
    }

    private ScopeSet findScopesForAllRecipients(Set explicitSubscribers) throws SDKException {
        String idList = ProfileResolutionEngine.buildIDList(explicitSubscribers);
        String select = "SI_OBTYPE, SI_USERGROUPS FROM CI_SYSTEMOBJS";
        String where = "(SI_ID in (" + idList + ") OR Descendents(\"SI_NAME='UserGroup-User'\", \"SI_ID in (" + idList + ")\"))" + " AND SI_OBTYPE = " + 19;
        ScopeSet finalScopes = new ScopeSet();
        if (this.m_effectiveProfiles.size() > 0) {
            IInfoObjects objs = this.queryNextBatchOfObjects(select, where, null);
            do {
                this.m_ancestorMap = this.getAncestors(objs);
                for (int i = 0; i < objs.size(); ++i) {
                    IUser recipient = (IUser)objs.get(i);
                    if (this.m_publication.getExcludedPrincipals().contains(new Integer(recipient.getID()))) continue;
                    this.addScopes(recipient.getID(), this.findScopesFor(recipient), finalScopes);
                }
            } while ((objs = this.queryNextBatchOfObjects(select, where, objs)).size() > 0);
        } else {
            Scope trivialScope = Scope.emptyScope();
            trivialScope.initPrincipals();
            IInfoObjects objs = this.queryNextBatchOfObjects(select, where, null);
            do {
                for (int i = 0; i < objs.size(); ++i) {
                    IInfoObject obj = (IInfoObject)objs.get(i);
                    if (this.m_publication.getExcludedPrincipals().contains(new Integer(obj.getID()))) continue;
                    trivialScope.putPrincipal(obj.getID());
                }
            } while ((objs = this.queryNextBatchOfObjects(select, where, objs)).size() > 0);
            finalScopes.add(trivialScope);
        }
        return finalScopes;
    }

    private ScopeSet findScopesFor(IUser user) throws SDKException {
        return this.findScopesFor(user, user.getGroups());
    }

    private ScopeSet findScopesFor(IUserGroup group) throws SDKException {
        ScopeSet scopes = this.fetchCachedResult(group.getID());
        if (scopes == null) {
            scopes = this.findScopesFor(group, group.getParentGroups());
            this.cacheResult(group.getID(), scopes);
        }
        return scopes;
    }

    private void cacheResult(int principalID, ScopeSet scopes) {
        HashMap<Integer, ScopeSet> theCache = (HashMap<Integer, ScopeSet>)this.m_cacheRef.get();
        if (theCache == null) {
            theCache = new HashMap<Integer, ScopeSet>();
            this.m_cacheRef = new SoftReference(theCache);
        }
        theCache.put(new Integer(principalID), scopes);
    }

    private ScopeSet fetchCachedResult(int principalID) {
        Map theCache = (Map)this.m_cacheRef.get();
        if (theCache != null) {
            return (ScopeSet)theCache.get(new Integer(principalID));
        }
        return null;
    }

    private ScopeSet findScopesFor(IInfoObject obj, Set parentGroupIDs) throws SDKException {
        ScopeSet scopes = new ScopeSet();
        Scope principalValues = (Scope)this.m_profileValues.get(new Integer(obj.getID()));
        if (parentGroupIDs.size() == 0) {
            if (principalValues != null) {
                scopes.add(principalValues);
            }
        } else {
            Iterator i = parentGroupIDs.iterator();
            while (i.hasNext()) {
                IUserGroup parent = (IUserGroup)this.m_ancestorMap.get(i.next());
                ScopeSet parentScopes = this.findScopesFor(parent);
                if (parentScopes.size() > 0) {
                    if (principalValues != null) {
                        Iterator iter = parentScopes.iterator();
                        while (iter.hasNext()) {
                            Scope parentScope = (Scope)iter.next();
                            Scope mergedScope = parentScope.copyValues();
                            mergedScope.merge(principalValues);
                            scopes.add(mergedScope);
                        }
                        continue;
                    }
                    scopes.addAll(parentScopes);
                    continue;
                }
                if (principalValues == null) continue;
                scopes.add(principalValues);
            }
        }
        return scopes;
    }

    private Map getAncestors(IInfoObjects objs) throws SDKException {
        String select = "SI_OBTYPE, SI_USERGROUPS FROM CI_SYSTEMOBJS";
        String where = "Ancestors(\"SI_NAME = 'UserGroup-User'\", \"SI_ID in (" + ProfileResolutionEngine.buildIDList(objs) + ")\")";
        HashMap<Integer, IUserGroup> ancestorMap = new HashMap<Integer, IUserGroup>();
        IInfoObjects ancestorObjects = this.queryNextBatchOfObjects(select, where, null);
        do {
            for (int i = 0; i < ancestorObjects.size(); ++i) {
                IUserGroup ancestor = (IUserGroup)ancestorObjects.get(i);
                ancestorMap.put(new Integer(ancestor.getID()), ancestor);
            }
        } while ((ancestorObjects = this.queryNextBatchOfObjects(select, where, ancestorObjects)).size() > 0);
        return ancestorMap;
    }

    private void addScopes(int principalID, ScopeSet newScopes, ScopeSet finalScopes) throws SDKException {
        if (newScopes.size() == 0) {
            newScopes.add(Scope.emptyScope());
        } else {
            newScopes = this.m_publication.getProfileResolutionType() == 1 ? this.collapseScopes(this.combineScopes(newScopes)) : newScopes;
        }
        Iterator iter = newScopes.iterator();
        while (iter.hasNext()) {
            Scope s = (Scope)iter.next();
            if (finalScopes.contains(s)) {
                Scope representative = finalScopes.getRepresentative(s);
                representative.putPrincipal(principalID);
                continue;
            }
            s.initPrincipals();
            s.putPrincipal(principalID);
            finalScopes.add(s);
        }
    }

    private ScopeSet combineScopes(ScopeSet scopes) {
        ScopeSet r = new ScopeSet();
        LinkedList<Scope> addQueue = new LinkedList<Scope>();
        Iterator iter = scopes.iterator();
        while (iter.hasNext()) {
            Scope si = (Scope)iter.next();
            if (si.getProfileValues().size() < this.m_effectiveProfiles.size()) {
                Iterator iter2 = r.iterator();
                while (iter2.hasNext()) {
                    Scope sj = (Scope)iter2.next();
                    if (sj.getProfileValues().size() >= this.m_effectiveProfiles.size() || si.conflicts(sj)) continue;
                    Scope merged = sj.copyValues();
                    merged.merge(si);
                    addQueue.add(merged);
                }
            }
            while (addQueue.size() > 0) {
                r.add(addQueue.removeFirst());
            }
            r.add(si);
        }
        return r;
    }

    private ScopeSet collapseScopes(ScopeSet scopes) {
        ScopeSet r = new ScopeSet();
        Iterator iter = r.iterator();
        while (iter.hasNext()) {
            boolean superSetFound = false;
            Scope si = (Scope)iter.next();
            Iterator j = scopes.iterator();
            while (j.hasNext() && !superSetFound) {
                Scope sj = (Scope)j.next();
                if (si == sj || !sj.getProfileValues().entrySet().containsAll(si.getProfileValues().entrySet())) continue;
                superSetFound = true;
            }
            if (superSetFound) continue;
            r.add(si);
        }
        return r;
    }

    private IInfoObjects queryNextBatchOfObjects(String select, String where, IInfoObjects lastBatch) throws SDKException {
        int lastId = lastBatch == null ? 0 : ((IInfoObject)lastBatch.get(lastBatch.size() - 1)).getID();
        String query = "SELECT TOP 10000 " + select + " WHERE " + "(" + where + ") AND SI_ID > " + lastId + " ORDER BY SI_ID";
        return this.m_infoStore.query(query);
    }

    private static String buildIDList(IInfoObjects objs) {
        StringBuffer buff = new StringBuffer(Integer.toString(((IInfoObject)objs.get(0)).getID()));
        for (int i = 1; i < objs.size(); ++i) {
            buff.append(",");
            buff.append(Integer.toString(((IInfoObject)objs.get(i)).getID()));
        }
        return buff.toString();
    }

    private static String buildIDList(Set ids) {
        Iterator itr = ids.iterator();
        StringBuffer buff = new StringBuffer(itr.next().toString());
        while (itr.hasNext()) {
            buff.append(",");
            buff.append(itr.next().toString());
        }
        return buff.toString();
    }

    private static class ScopeSet
    extends AbstractSet {
        HashMap m_map = new HashMap();

        public ScopeSet() {
        }

        public ScopeSet(ScopeSet other) {
            this.m_map.putAll(other.m_map);
        }

        public Scope getRepresentative(Scope scope) {
            return (Scope)this.m_map.get(scope.getProfileValues());
        }

        public boolean add(Scope scope) {
            return this.m_map.put(scope.getProfileValues(), scope) != null;
        }

        public boolean contains(Object o) {
            if (o instanceof Scope) {
                return this.getRepresentative((Scope)o) != null;
            }
            return false;
        }

        public boolean remove(Object o) {
            if (o instanceof Scope) {
                return this.m_map.remove(((Scope)o).getProfileValues()) != null;
            }
            return false;
        }

        public int size() {
            return this.m_map.size();
        }

        public Iterator iterator() {
            Iterator delegate = this.m_map.entrySet().iterator();
            return new Iterator(this, delegate){
                private final /* synthetic */ Iterator val$delegate;
                private final /* synthetic */ ScopeSet this$0;
                {
                    this.this$0 = this$0;
                    this.val$delegate = val$delegate;
                }

                public boolean hasNext() {
                    return this.val$delegate.hasNext();
                }

                public Object next() {
                    return ((Map.Entry)this.val$delegate.next()).getValue();
                }

                public void remove() {
                    this.val$delegate.remove();
                }
            };
        }
    }
}

