/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.publication.internal;

import com.businessobjects.sdk.plugin.desktop.publication.IPublicationState;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.List;

public class PublicationState
implements IPublicationState {
    private PropertyBag m_propBag;

    public PublicationState(PropertyBag bag) {
        this.m_propBag = bag;
    }

    public int getGlobalDeliveryRuleResult() {
        Property prop = this.m_propBag.getItem((Object)PropertyIDs.SI_DELIVERY_RULE_RESULTS);
        if (prop == null) {
            return 0;
        }
        return prop.getInt();
    }

    public void setGlobalDeliveryRuleResult(int statusValue) throws SDKException {
        if (statusValue > 3 || statusValue < 0) {
            throw new SDKException.InvalidArg("global delivery rule status must be one of 0, 1, 2, 3");
        }
        this.m_propBag.setProperty((Object)PropertyIDs.SI_DELIVERY_RULE_RESULTS, statusValue);
    }

    public int getProfileResolutionStatus() {
        Property prop = this.m_propBag.getItem((Object)PropertyIDs.SI_PUBLICATION_LAST_STATE_PROFILERESOLUTION);
        if (prop == null) {
            return 0;
        }
        return prop.getInt();
    }

    public void setProfileResolutionStatus(int statusValue) throws SDKException {
        if (statusValue != 2 && statusValue != 1 && statusValue != 0) {
            throw new SDKException.InvalidArg("Profile resolution status value " + statusValue + " is not valid");
        }
        this.m_propBag.setProperty((Object)PropertyIDs.SI_PUBLICATION_LAST_STATE_PROFILERESOLUTION, statusValue);
    }

    public String getLastDynamicRecipientIdentifier() {
        Property prop = this.m_propBag.getItem((Object)PropertyIDs.SI_LASTCREATEDDYNAMICRECIPIENTSSCOPEBATCHID);
        if (prop == null) {
            return null;
        }
        return prop.getString();
    }

    public void setLastDynamicRecipientIdentifier(String identifierVal) throws SDKException {
        this.m_propBag.setProperty((Object)PropertyIDs.SI_LASTCREATEDDYNAMICRECIPIENTSSCOPEBATCHID, (Object)identifierVal);
    }

    public int getScheduleStatus() {
        Property prop = this.m_propBag.getItem((Object)PropertyIDs.SI_SCHEDULE_STATUS);
        if (prop == null) {
            return 0;
        }
        return prop.getInt();
    }

    public void setScheduleStatus(int value) throws SDKException {
        this.m_propBag.setProperty((Object)PropertyIDs.SI_SCHEDULE_STATUS, value);
    }

    public int getSecuritySettingStatus() {
        Property prop = this.m_propBag.getItem((Object)PropertyIDs.SI_PUBLICATION_LAST_STATE_SECURITY);
        if (prop == null) {
            return 0;
        }
        return prop.getInt();
    }

    public void setSecuritySettingStatus(int value) throws SDKException {
        this.m_propBag.setProperty((Object)PropertyIDs.SI_PUBLICATION_LAST_STATE_SECURITY, value);
    }

    public List getStartedRecipients() {
        PropertyBag startedUserBag = this.m_propBag.getPropertyBag((Object)PropertyIDs.SI_PUBLICATION_STARTED_RECIPIENT_IDS);
        if (startedUserBag == null) {
            startedUserBag = this.m_propBag.addArray((Object)PropertyIDs.SI_PUBLICATION_STARTED_RECIPIENT_IDS).getPropertyBag();
        }
        PropertyArrayHelper arrayHelper = new PropertyArrayHelper(startedUserBag, PropertyIDs.SI_TOTAL);
        return arrayHelper;
    }

    public boolean isReadyForRedistribution() {
        Property prop = this.m_propBag.getItem((Object)PropertyIDs.SI_PUBLICATION_IS_READY_FOR_REDISTRIBUTION);
        if (prop == null) {
            return false;
        }
        return prop.getBoolean();
    }

    public void setIsReadyForRedistribution(boolean value) throws SDKException {
        this.m_propBag.setProperty((Object)PropertyIDs.SI_PUBLICATION_IS_READY_FOR_REDISTRIBUTION, value);
    }

    public void setReachedRecipientLimit(boolean value) {
        this.m_propBag.setProperty((Object)PropertyIDs.SI_HAS_REACHED_PUBLICATION_RECIPIENT_LIMIT, value);
    }

    public boolean hasReachedRecipientLimit() {
        Property prop = this.m_propBag.getItem((Object)PropertyIDs.SI_HAS_REACHED_PUBLICATION_RECIPIENT_LIMIT);
        if (prop == null) {
            return false;
        }
        return prop.getBoolean();
    }
}

