/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.replication.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.replication.IReplication;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IFile;
import com.crystaldecisions.sdk.occa.infostore.IFiles;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.IRemoteFile;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSchedulableObject;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.OutputStream;
import java.util.Collection;

public class Replication
extends AbstractSchedulableObject
implements IReplication {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.desktop.replication.internal.Replication");
    private static final int RESULT_FILE_INDEX = 0;
    private Collection m_refreshAppObjects;

    Replication() {
        this.setProperty((Object)PropertyIDs.SI_SYSTEM_OBJECT, Boolean.TRUE);
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setReplicateRemoteSchedules(true);
        this.setReplicateDocumentTemplates(true);
        this.setReplicateLocalInstances(true);
        this.enableCleanup(true);
    }

    private PropertyBag getProcessingBag() {
        return (PropertyBag)this.getProcessingInfo().properties();
    }

    public void setConflictResolutionMode(int mode) throws SDKException {
        if (mode < 0 || mode > 2) {
            throw new SDKException.InvalidArg(mode);
        }
        this.getProcessingBag().setProperty((Object)PropertyIDs.SI_CONFLICT_RESOLUTION_MODE, mode);
    }

    public int getConflictResolutionMode() {
        Property prop = this.getProcessingBag().getItem((Object)PropertyIDs.SI_CONFLICT_RESOLUTION_MODE);
        if (prop == null) {
            return 0;
        }
        return prop.getInt();
    }

    public void setPushEnabled(boolean enable) {
        this.getProcessingBag().setProperty((Object)PropertyIDs.SI_PUSH_ENABLED, enable);
    }

    public boolean isPushEnabled() {
        Property prop = this.getProcessingBag().getItem((Object)PropertyIDs.SI_PUSH_ENABLED);
        if (prop != null) {
            return prop.getBoolean();
        }
        return false;
    }

    public void setRemoteManifest(String cuid) {
        this.getProcessingBag().setProperty((Object)PropertyIDs.SI_REMOTE_MANIFEST, (Object)cuid);
    }

    public String getRemoteManifest() {
        return this.getProcessingBag().getString((Object)PropertyIDs.SI_REMOTE_MANIFEST);
    }

    public boolean isCleanupEnabled() throws SDKException {
        Property prop = this.getProcessingBag().getItem((Object)PropertyIDs.SI_ENABLED);
        if (prop == null) {
            return false;
        }
        return prop.getBoolean();
    }

    public void enableCleanup(boolean enabled) {
        this.getProcessingBag().setProperty((Object)PropertyIDs.SI_ENABLED, enabled);
    }

    public int getMaxCUIDsReturned() throws SDKException {
        return this.getOptionProperty(PropertyIDs.SI_MAX_CUIDS_RETURNED).getInt();
    }

    public String getNextStartCUID() throws SDKException {
        return this.getOptionProperty(PropertyIDs.SI_NEXT_START_CUID).getString();
    }

    private Property getOptionProperty(int propID) throws SDKException {
        PropertyBag options = this.getProcessingBag().getPropertyBag((Object)PropertyIDs.SI_CLEANUP_OPTIONS);
        if (options == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_CLEANUP_OPTIONS);
        }
        Property prop = options.getItem((Object)new Integer(propID));
        if (prop == null) {
            throw new SDKException.PropertyNotFound(new Integer(propID));
        }
        return prop;
    }

    public void setApplicationRefreshMode(int mode) throws SDKException {
        if (mode < 0 || mode > 2) {
            throw new SDKException.InvalidArg(mode);
        }
        this.getProcessingBag().setProperty((Object)PropertyIDs.SI_APP_REFRESH_MODE, mode);
    }

    public int getApplicationRefreshMode() {
        Property prop = this.getProcessingBag().getItem((Object)PropertyIDs.SI_APP_REFRESH_MODE);
        if (prop == null) {
            return 0;
        }
        return prop.getInt();
    }

    public Collection getRefreshApplicationObjects() {
        if (this.m_refreshAppObjects == null) {
            PropertyBag processBag = this.getProcessingBag();
            PropertyBag refreshObjs = processBag.getPropertyBag((Object)PropertyIDs.SI_REFRESH_APP_OBJECTS);
            if (refreshObjs == null) {
                refreshObjs = processBag.addArray((Object)PropertyIDs.SI_REFRESH_APP_OBJECTS).getPropertyBag();
            }
            this.m_refreshAppObjects = new PropertyArrayHelper(refreshObjs, PropertyIDs.SI_TOTAL){

                public boolean add(Object o) {
                    if (!(o instanceof String)) {
                        throw new UnsupportedOperationException();
                    }
                    if (this.contains(o)) {
                        return false;
                    }
                    return super.add(o);
                }
            };
        }
        return this.m_refreshAppObjects;
    }

    public void setReplicateRemoteSchedules(boolean include) {
        this.getProcessingBag().setProperty((Object)PropertyIDs.SI_REPLICATE_REMOTESCHEDULES, include);
    }

    public boolean getReplicateRemoteSchedules() {
        return this.getProcessingBag().getBoolean((Object)PropertyIDs.SI_REPLICATE_REMOTESCHEDULES);
    }

    public void setReplicateDocumentTemplates(boolean include) {
        this.getProcessingBag().setProperty((Object)PropertyIDs.SI_REPLICATE_DOCUMENTTEMPLATES, include);
    }

    public boolean getReplicateDocumentTemplates() {
        return this.getProcessingBag().getBoolean((Object)PropertyIDs.SI_REPLICATE_DOCUMENTTEMPLATES);
    }

    public void setReplicateLocalInstances(boolean include) {
        this.getProcessingBag().setProperty((Object)PropertyIDs.SI_REPLICATE_LOCALINSTANCES, include);
    }

    public boolean getReplicateLocalInstances() {
        return this.getProcessingBag().getBoolean((Object)PropertyIDs.SI_REPLICATE_LOCALINSTANCES);
    }

    public String getResultMIMEType() {
        try {
            IFiles files = this.getFiles();
            if (files.size() == 0) {
                LOG.assertTrue(false, "getResultMIMEType(): No files associated with replication job");
            } else {
                IFile file = (IFile)files.get(0);
                String fname = file.getName();
                if (fname.endsWith("html")) {
                    return "text/html";
                }
                if (fname.endsWith("xml")) {
                    return "text/xml";
                }
                if (fname.endsWith("log")) {
                    return "text/plain";
                }
            }
        }
        catch (SDKException e) {
            LOG.assertTrue(false, "getResultMimeType(): exception from getFiles: " + e.getDetailMessage());
        }
        return "text/plain";
    }

    public void writeResult(OutputStream out) throws SDKException {
        IRemoteFile remoteFile = this.getResultFile();
        if (remoteFile.download(out)) {
            remoteFile.commit();
        }
    }

    private IRemoteFile getResultFile() throws SDKException {
        IFiles files = this.getFiles();
        LOG.assertTrue(files.size() > 0, "getResultByteStream(): File's size must be greated than 0");
        IFile file = (IFile)files.get(0);
        LOG.assertTrue(file instanceof IRemoteFile, "getResultByteStream(): must be a remote file");
        IRemoteFile remoteFile = (IRemoteFile)file;
        return remoteFile;
    }
}

