/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.scopebatch.internal;

import com.businessobjects.sdk.plugin.desktop.scopebatch.IScopeBatchDistributionPluginState;
import com.businessobjects.sdk.plugin.desktop.scopebatch.IScopeBatchDistributionScopeState;
import com.businessobjects.sdk.plugin.desktop.scopebatch.IScopeBatchDistributionState;
import com.businessobjects.sdk.plugin.desktop.scopebatch.internal.ScopeBatchDistributionPluginStates;
import com.businessobjects.sdk.plugin.desktop.scopebatch.internal.ScopeBatchDistributionScopeStates;
import com.businessobjects.sdk.plugin.desktop.scopebatch.internal.ScopeBatchDistributionStaticDocuments;
import com.businessobjects.sdk.plugin.desktop.scopebatch.internal.StateHelper;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.List;

public class ScopeBatchDistributionState
implements IScopeBatchDistributionState {
    private PropertyBag m_bag;
    private ScopeBatchDistributionScopeStates m_scopeStates;
    private ScopeBatchDistributionPluginStates m_pluginStates;

    public ScopeBatchDistributionState(PropertyBag bag) {
        this.m_bag = bag;
    }

    public int getPhase() {
        Integer status = new Integer(this.m_bag.getInt((Object)PropertyIDs.SI_DISTRIBUTION_STATUS));
        if (status != null) {
            return status;
        }
        return 0;
    }

    public void setPhase(int phase) throws SDKException {
        StateHelper.verifyValidDistributionPhase(phase);
        this.m_bag.setProperty((Object)PropertyIDs.SI_DISTRIBUTION_STATUS, phase);
    }

    public List getStaticDocuments() {
        PropertyBag aliasesBag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_STATIC_DOCUMENTS);
        if (aliasesBag == null) {
            Property prop = this.m_bag.addArray((Object)PropertyIDs.SI_STATIC_DOCUMENTS);
            aliasesBag = prop.getPropertyBag();
        }
        return new ScopeBatchDistributionStaticDocuments(aliasesBag);
    }

    public IScopeBatchDistributionScopeState getScopeState(int scopeIndex) {
        if (this.m_scopeStates == null) {
            PropertyBag targetBag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_DISTRIBUTION_SCOPE_STATE);
            if (targetBag == null) {
                targetBag = this.m_bag.addPropertyBag((Object)PropertyIDs.SI_DISTRIBUTION_SCOPE_STATE, null).getPropertyBag();
            }
            this.m_scopeStates = new ScopeBatchDistributionScopeStates(targetBag);
        }
        return this.m_scopeStates.get(scopeIndex);
    }

    public IScopeBatchDistributionPluginState getPluginState(int pluginIndex) {
        if (this.m_pluginStates == null) {
            PropertyBag targetBag = this.m_bag.getPropertyBag((Object)PropertyIDs.SI_DISTRIBUTION_PLUGIN_STATE);
            if (targetBag == null) {
                targetBag = this.m_bag.addPropertyBag((Object)PropertyIDs.SI_DISTRIBUTION_PLUGIN_STATE, null).getPropertyBag();
            }
            this.m_pluginStates = new ScopeBatchDistributionPluginStates(targetBag);
        }
        return this.m_pluginStates.get(pluginIndex);
    }

    public void clearState() {
        this.m_scopeStates = null;
        this.m_bag.remove((Object)PropertyIDs.SI_DISTRIBUTION_SCOPE_STATE);
        this.m_bag.setProperty((Object)PropertyIDs.SI_DISTRIBUTION_STATUS, 0);
    }
}

