/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.servicecontainer.internal;

import com.businessobjects.sdk.plugin.desktop.common.IConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.IConfiguredContainers;
import com.businessobjects.sdk.plugin.desktop.common.IInstalledObjects;
import com.businessobjects.sdk.plugin.desktop.common.IIntegerProps;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfigProperty;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfiguredContainer;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfiguredContainers;
import com.businessobjects.sdk.plugin.desktop.common.internal.InstalledObject;
import com.businessobjects.sdk.plugin.desktop.common.internal.InstalledObjects;
import com.businessobjects.sdk.plugin.desktop.common.internal.IntegerProps;
import com.businessobjects.sdk.plugin.desktop.servicecontainer.IServiceContainer;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.ObjectRelatives;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.plugin.desktop.server.IServer;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

class ServiceContainer
extends AbstractInfoObject
implements IServiceContainer {
    private Set m_ServicesIDSet;
    protected PropertyArrayHelper m_deltaHelper;
    private ConfiguredContainers m_configuredContainers;
    private InstalledObjects m_installedContainers;
    private Set m_objRels = new HashSet();

    ServiceContainer() {
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setProperty((Object)PropertyIDs.SI_SYSTEM_OBJECT, Boolean.TRUE);
        this.setProperty((Object)PropertyIDs.SI_PARENT_CUID, "AUqIth9qbA9AmPDPV1crYCU");
        this.setProperty((Object)PropertyIDs.SI_PARENTID, 55);
    }

    public IInfoObjectEventListener getInfoObjectEventListener(int type) {
        final IInfoObjectEventListener superListener = super.getInfoObjectEventListener(type);
        if (type == 2) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    IInternalInfoStore infoStore = event.getInfoStore();
                    ServiceContainer.this.pushEdgeProperties(infoStore);
                    if (!ServiceContainer.this.isNew()) {
                        ServiceContainer.this.processObjectRelatives(ServiceContainer.this.m_objRels);
                        ServiceContainer.this.propagateInstalledContainerRemoval(infoStore);
                    }
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        if (type == 5) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    IInternalInfoStore infoStore = event.getInfoStore();
                    ServiceContainer.this.propagateConfiguredContainerRemoval(infoStore);
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        return superListener;
    }

    void pushEdgeProperties(IInternalInfoStore istore) throws SDKException {
        PropertyBag configProps;
        Property cp;
        Property prop = (Property)this.properties().get(PropertyIDs.SI_ADM_ADD_SI_SERVER2SC);
        if (prop != null) {
            PropertyBag bag = prop.getPropertyBag();
            Iterator i = bag.allIterator();
            while (i.hasNext()) {
                Property p = (Property)i.next();
                if (!p.isContainer()) continue;
                PropertyBag pb = p.getPropertyBag();
                this.pushInstallProps(istore, pb);
                if (this.properties().get(PropertyIDs.SI_CONFIG) == null) continue;
                this.pushContainerConfigProps(pb);
            }
        }
        if ((cp = (Property)this.properties().getProperty(PropertyIDs.SI_CONFIG)) != null && (configProps = cp.getPropertyBag()).isDirty()) {
            IConfiguredContainers ccs = this.getContainerInstances();
            Iterator ccsIter = ccs.iterator();
            while (ccsIter.hasNext()) {
                ConfiguredContainer cc = (ConfiguredContainer)ccsIter.next();
                if (!cc.isUsingContainerConfigProps()) continue;
                cc.applyContainerConfigProps();
            }
        }
    }

    void pushContainerConfigProps(PropertyBag destBag) throws SDKException {
        ConfiguredContainer edge = new ConfiguredContainer(destBag, new PropertyBag());
        IConfigProperties configProps = this.getConfigProps();
        if (configProps != null && !configProps.isEmpty()) {
            edge.useCustomConfigProps();
            ConfigProperties edgeConfigProps = (ConfigProperties)edge.getConfigProps();
            String[] names = configProps.getPropNames();
            for (int i = 0; i < names.length; ++i) {
                if (edgeConfigProps.getProp(names[i]) != null) continue;
                ConfigProperty srcConfig = (ConfigProperty)configProps.get(names[i]);
                edgeConfigProps.addProp(srcConfig);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void pushInstallProps(IInternalInfoStore istore, PropertyBag destBag) throws SDKException {
        int serverID = destBag.getInt((Object)PropertyIDs.SI_ID);
        String q = "SELECT SI_ID FROM CI_SYSTEMOBJECTS WHERE PARENTS(\"SI_NAME='EnterpriseNode-Server'\", \"SI_ID=" + serverID + "\")";
        IInfoObjects objs = istore.query(q);
        if (objs.size() <= 0) throw new SDKException.PropagationNotPossible("Enterprise Node", "Server", serverID);
        int enterpriseNodeID = ((IInfoObject)objs.get(0)).getID();
        String q2 = "SELECT SI_ID FROM CI_SYSTEMOBJECTS WHERE PARENTS(\"SI_NAME='Install-EnterpriseNode'\", \"SI_ID=" + enterpriseNodeID + "\")";
        IInfoObjects objs2 = istore.query(q2);
        if (objs2.size() <= 0) throw new SDKException.PropagationNotPossible("Install", "Enterprise Node", enterpriseNodeID);
        int installID = ((IInfoObject)objs2.get(0)).getID();
        InstalledObject instObj = (InstalledObject)this.getContainerInstalls().get(installID);
        if (instObj == null) {
            throw new SDKException.PropagationNotPossible("Install", "ServiceContainer", this.getID());
        }
        PropertyBag origProps = instObj.getPropertyBag();
        Iterator origPropIter = origProps.allIterator();
        while (origPropIter.hasNext()) {
            PropertyBag origPropSubBag;
            Property origProp = (Property)origPropIter.next();
            Integer origPropID = origProp.getID();
            if (origPropID.equals(PropertyIDs.SI_ID) || origPropID.equals(PropertyIDs.SI_OBJ_VERSION)) continue;
            Property destProp = destBag.getItem((Object)origPropID);
            if (destProp == null || destProp.getValue() == null || destProp.getValue() == "") {
                destBag.addItem((Object)origPropID, origProp.getValue(), 0);
                continue;
            }
            if (!origProp.isContainer() || (origPropSubBag = origProp.getPropertyBag()).getItem((Object)PropertyIDs.SI_TOTAL) != null || !destProp.isContainer()) continue;
            PropertyBag destPropSubBag = destProp.getPropertyBag();
            Iterator origPropSubBagIter = origPropSubBag.allIterator();
            while (origPropSubBagIter.hasNext()) {
                Property prop = (Property)origPropSubBagIter.next();
                Property item = destPropSubBag.getItem((Object)prop.getID());
                if (item != null && item.getValue() != null && item.getValue() != "") continue;
                destPropSubBag.addItem((Object)prop.getID(), prop.getValue(), 0);
            }
        }
    }

    void propagateInstalledContainerRemoval(IInternalInfoStore infoStore) throws SDKException {
        Property prop = (Property)this.properties().get(PropertyIDs.SI_ADM_DEL_CONTAINER_INSTALL);
        if (prop != null) {
            PropertyBag bag = prop.getPropertyBag();
            Iterator iter = bag.allIterator();
            HashSet<Integer> ids = new HashSet<Integer>();
            while (iter.hasNext()) {
                Property p = (Property)iter.next();
                if ((p.getFlags() & 0x8000000) == 0) continue;
                PropertyBag pb = p.getPropertyBag();
                ids.add(new Integer(pb.getInt((Object)PropertyIDs.SI_ID)));
            }
            Iterator iter2 = ids.iterator();
            while (iter2.hasNext()) {
                Integer installID = (Integer)iter2.next();
                String query = "select SI_ID from CI_SYSTEMOBJECTS where CHILDREN(\"SI_NAME='EnterpriseNode-Server'\",\"CHILDREN('SI_NAME=''Install-EnterpriseNode''', 'SI_ID=" + installID + "')\")";
                IInfoObjects infoObjs = infoStore.query(query);
                if (infoObjs.size() != 1) continue;
                IServer server = (IServer)infoObjs.get(0);
                server.deleteNow();
            }
        }
    }

    void propagateConfiguredContainerRemoval(IInternalInfoStore infoStore) throws SDKException {
        Property prop = (Property)this.properties().get(PropertyIDs.SI_ADM_DEL_SI_SERVER2SC);
        if (prop != null) {
            PropertyBag bag = prop.getPropertyBag();
            Iterator iter = bag.allIterator();
            HashSet<Integer> ids = new HashSet<Integer>();
            while (iter.hasNext()) {
                Property p = (Property)iter.next();
                if ((p.getFlags() & 0x8000000) == 0) continue;
                PropertyBag pb = p.getPropertyBag();
                ids.add(new Integer(pb.getInt((Object)PropertyIDs.SI_ID)));
            }
            Iterator iter2 = ids.iterator();
            while (iter2.hasNext()) {
                int serverID = (Integer)iter2.next();
                String query = "select SI_ID from CI_SYSTEMOBJECTS where SI_ID = " + serverID;
                IInfoObjects infoObjs = infoStore.query(query);
                if (infoObjs.size() != 1) {
                    throw new SDKException.ObjectNotFound("");
                }
                IServer server = (IServer)infoObjs.get(0);
                server.deleteNow();
            }
        }
    }

    public IConfigProperties getConfigProps() {
        PropertyBag propertyBag = (PropertyBag)this.properties();
        PropertyBag bag = propertyBag.getPropertyBag((Object)PropertyIDs.SI_CONFIG);
        if (bag == null) {
            return null;
        }
        return new ConfigProperties(bag);
    }

    public IConfigProperties addConfigProps() {
        PropertyBag propertyBag = (PropertyBag)this.properties();
        PropertyBag bag = propertyBag.getPropertyBag((Object)PropertyIDs.SI_CONFIG);
        if (bag == null) {
            String name = PropertyIDs.idToName(PropertyIDs.SI_CONFIG);
            bag = propertyBag.addItem((Object)name, null, 0x8000000).getPropertyBag();
        }
        return new ConfigProperties(bag);
    }

    public Set getServices() throws SDKException {
        if (this.m_ServicesIDSet == null) {
            this.m_ServicesIDSet = new ObjectRelatives();
            ((ObjectRelatives)this.m_ServicesIDSet).initialize((Object)PropertyIDs.SI_SERVICE4SC, this.properties(), false, this.isNew());
        }
        return this.m_ServicesIDSet;
    }

    public IConfiguredContainers getContainerInstances() throws SDKException {
        if (this.m_configuredContainers == null) {
            this.m_configuredContainers = new ConfiguredContainers();
            Property configProp = (Property)this.properties().getProperty(PropertyIDs.SI_CONFIG);
            if (configProp == null) {
                configProp = (Property)this.properties().add(PropertyIDs.SI_CONFIG, new Integer(0), 0x8000000);
            }
            PropertyBag configProps = configProp.getPropertyBag();
            this.m_configuredContainers.initialize((Object)PropertyIDs.SI_CONTAINER_INSTANCES, "SI_SERVER2SC", (AbstractInfoObject)this, configProps);
        }
        return this.m_configuredContainers;
    }

    public IInstalledObjects getContainerInstalls() throws SDKException {
        if (this.m_installedContainers == null) {
            this.m_installedContainers = new InstalledObjects();
            this.m_installedContainers.initialize(PropertyIDs.SI_CONTAINER_INSTALLS, "CONTAINER_INSTALL", this);
        }
        return this.m_installedContainers;
    }

    public String getServerKind() {
        return this.properties().getString(PropertyIDs.SI_SERVER_KIND);
    }

    public void setServerKind(String serverKind) {
        this.properties().setProperty((Object)PropertyIDs.SI_SERVER_KIND, serverKind);
    }

    public IIntegerProps getSupportedAuditEvents() {
        PropertyBag propertyBag = (PropertyBag)this.properties();
        PropertyBag bag = propertyBag.getPropertyBag((Object)PropertyIDs.SI_SUPPORTED_AUDIT_EVENTS);
        if (bag == null) {
            bag = propertyBag.addItem((Object)PropertyIDs.SI_SUPPORTED_AUDIT_EVENTS, null, 0x8000000).getPropertyBag();
        }
        return new IntegerProps(bag, true);
    }

    public String getDescription(Locale locale) throws SDKException {
        PropertyBag bag = (PropertyBag)this.properties().getProperties(PropertyIDs.SI_ML_DESCRIPTION);
        if (bag != null) {
            try {
                return bag.getString(locale);
            }
            catch (Exception e) {
                throw new SDKException.PropertyNotFound(PropertyIDs.SI_ML_DESCRIPTION);
            }
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_ML_DESCRIPTION);
    }

    public int getMaxServiceCount() {
        return this.properties().getInt(PropertyIDs.SI_MAX_SERVICE_COUNT);
    }

    public Set getObjectRelatives() {
        return this.m_objRels;
    }
}

