/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.APSServerHandler;
import java.util.Comparator;

class APSComparator
implements Comparator {
    private static final ILogger LOG = LoggerManager.getLogger((Class)APSComparator.class);

    APSComparator() {
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof String && o2 instanceof String) {
            String str1 = (String)o1;
            String str2 = (String)o2;
            if (str1.equalsIgnoreCase(str2)) {
                return 0;
            }
            APSInfo info1 = new APSInfo(str1);
            APSInfo info2 = new APSInfo(str2);
            return info1.compareTo(info2);
        }
        return ((Comparable)o1).compareTo(o2);
    }

    static class APSInfo
    implements Comparable {
        private String m_aps;
        private int m_port;
        private static final int DEFAULT_PORT = 6400;
        private static final int INVALID_PORT = -1;

        APSInfo(String name) {
            int delim = APSServerHandler.findPortIndex(name);
            if (delim == -1) {
                this.m_aps = name;
                this.m_port = 6400;
            } else {
                this.m_aps = name.substring(0, delim);
                String portNumber = name.substring(delim + 1);
                try {
                    this.m_port = Integer.parseInt(portNumber);
                }
                catch (NumberFormatException e) {
                    this.m_port = -1;
                }
            }
        }

        String getAps() {
            return this.m_aps;
        }

        void setAps(String aps) {
            this.m_aps = aps;
        }

        int getPort() {
            return this.m_port;
        }

        void setPort(int port) {
            this.m_port = port;
        }

        public int compareTo(Object obj) {
            if (obj instanceof APSInfo) {
                APSInfo other = (APSInfo)obj;
                if (other.getPort() == this.m_port) {
                    String otherAPS = other.getAps();
                    return this.m_aps.compareToIgnoreCase(otherAPS);
                }
                return this.m_port < other.m_port ? -1 : 1;
            }
            throw new ClassCastException(obj.getClass().getName());
        }

        public String toString() {
            return this.m_aps + ":" + this.m_port;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }
    }
}

