/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.CaseInsensComparator;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.properties.QBSet;
import com.crystaldecisions.enterprise.ocaframework.APSComparator;
import com.crystaldecisions.enterprise.ocaframework.AbstractServerHandler;
import com.crystaldecisions.enterprise.ocaframework.IDirectory;
import com.crystaldecisions.enterprise.ocaframework.IProperty;
import com.crystaldecisions.enterprise.ocaframework.IPropertyBag;
import com.crystaldecisions.enterprise.ocaframework.IServerHandler;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.PersistedClustersInfo;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServersIterator;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactoryHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactoryPackage.connection_failure;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORB;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class APSServerHandler
extends AbstractServerHandler
implements IServerHandler {
    private final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.ServiceMgr.APSServerHandler");
    private IDirectory m_bootstrapDirectory;
    private static final Integer PINGER = PropertyIDs.define("PINGER");
    static final String BOOTSTRAP_CLUSTER = "@____BOOTSTRAPCLUSTER";
    private static final String DEFAULT_PORT_SUFFIX = ":6400";
    private PersistedClustersInfo m_persistedClustersInfo = new PersistedClustersInfo();
    private static final APSComparator APS_COMPARATOR = new APSComparator();
    private static final CaseInsensComparator CASE_INSENS_COMPARATOR = new CaseInsensComparator();

    public APSServerHandler() {
        super(new Integer[]{PropertyIDs.SI_CLUSTER_NAME, AbstractServerHandler.APS_NAME, AbstractServerHandler.SERVER_NAME, PropertyIDs.SI_NAME}, new Comparator[]{CASE_INSENS_COMPARATOR, APS_COMPARATOR, CASE_INSENS_COMPARATOR, CASE_INSENS_COMPARATOR});
        this.m_queryIDsString = IDHelper.toQueryString((Integer[])new Integer[]{PropertyIDs.SI_SERVER_NAME, PropertyIDs.SI_SERVER_IS_ALIVE, PropertyIDs.SI_SERVER_IOR});
    }

    static int findPortIndex(String uri) {
        int lastColon = uri.lastIndexOf(58);
        if (lastColon == -1) {
            return -1;
        }
        int lastCloseBrace = uri.lastIndexOf(93);
        if (lastCloseBrace == -1) {
            int firstColon = uri.indexOf(58);
            if (firstColon != lastColon) {
                return -1;
            }
            return lastColon;
        }
        if (lastCloseBrace < lastColon) {
            return lastColon;
        }
        return -1;
    }

    public void clearServerInfo(ServerSpec spec) {
    }

    public Set queryServer(ServerSpec spec, boolean validOnly) {
        Set svrResults = this.getServerPropertyBag(spec);
        if (validOnly) {
            this.filterServers(svrResults, SERVER_VALID, 0, VALID);
        }
        return svrResults;
    }

    protected Set getServerPropertyBag(ServerSpec spec) {
        String name = spec.getName();
        String cluster = spec.getCluster();
        String aps = spec.getAPS();
        QBSet.Query apsQuery = new QBSet.Query();
        if (!"".equalsIgnoreCase(cluster)) {
            apsQuery.addTerm(PropertyIDs.SI_CLUSTER_NAME, (Object)cluster);
        }
        Set svrResults = !name.equals("") ? this.queryAPSWithName(apsQuery, name) : (!aps.equals("") ? this.queryAPSWithName(apsQuery, aps) : this.getServers().query(apsQuery));
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("queryServer(): results=" + svrResults));
        }
        return svrResults;
    }

    public void buildServerInfo(ServerSpec spec, String uri, IDirectory directory) throws OCAFrameworkException {
        this.buildAPSClusterInfo(spec, directory);
    }

    public Iterator serversIterator(ServerSpec spec, String uri, IDirectory directory) throws OCAFrameworkException {
        return new ServersIterator(spec, this);
    }

    public void fillServerSpec(IPropertyBag bag, ServerSpec spec) {
        String aps = bag.getString(SERVER_NAME);
        String cluster = bag.getString(PropertyIDs.SI_CLUSTER_NAME);
        spec.setAPS(aps);
        spec.setCluster(cluster);
        if ("".equalsIgnoreCase(spec.getKind())) {
            spec.setKind("aps");
        }
        if ("aps".equalsIgnoreCase(spec.getKind())) {
            spec.setName(bag.getString(SERVER_NAME));
        }
    }

    public Set queryCluster(ServerSpec spec, boolean validOnly) {
        ServerSpec copy = new ServerSpec(spec);
        if (!"".equalsIgnoreCase(spec.getCluster())) {
            copy.setName("");
            copy.setAPS("");
            return this.queryServer(copy, validOnly);
        }
        return Collections.EMPTY_SET;
    }

    public void buildClusterInfo(ServerSpec spec, String uri, IDirectory directory) throws OCAFrameworkException {
        this.buildAPSClusterInfo(spec, directory);
    }

    void setBootstrapDirectory(IDirectory bootstrapDirectory) {
        this.m_bootstrapDirectory = bootstrapDirectory;
    }

    void buildBootstrapAPSInfo(String aps) throws OCAFrameworkException {
        ServerSpec spec = new ServerSpec("", "aps", aps);
        IPropertyBag[] found = this.m_bootstrapDirectory.find(spec, "", null, 0);
        this.LOG.assertTrue(found.length == 1, "buildBootstrapAPSInfo(): should find one");
        this.clearBootstrapAPSInfo(aps);
        found[0].setProperty((Object)APS_NAME, aps);
        found[0].setProperty((Object)SERVER_NAME, aps);
        found[0].setProperty((Object)PropertyIDs.SI_CLUSTER_NAME, BOOTSTRAP_CLUSTER);
        found[0].setProperty((Object)PropertyIDs.SI_SERVER_IS_ALIVE, 1);
        found[0].setProperty((Object)SERVER_VALID, VALID);
        this.addServer(found[0]);
    }

    boolean needsMerge(Set servers) {
        Iterator iter = servers.iterator();
        while (iter.hasNext()) {
            PropertyBag bag = (PropertyBag)iter.next();
            ServerSpec spec = new ServerSpec(bag.getString((Object)APS_NAME), "aps", bag.getString((Object)APS_NAME), bag.getString((Object)PropertyIDs.SI_CLUSTER_NAME));
            if (this.queryServer(spec, false).size() != 0) continue;
            return true;
        }
        return false;
    }

    void merge(Set servers) {
        if (this.needsMerge(servers)) {
            Iterator iter = servers.iterator();
            Long now = new Long(System.currentTimeMillis());
            while (iter.hasNext()) {
                IPropertyBag bag = (IPropertyBag)iter.next();
                bag.setProperty((Object)SERVER_TIMESTAMP, now);
                this.clearAPSInfo(bag.getString(APS_NAME));
                this.addServer(bag);
            }
        }
    }

    String getPingerIOR(String aps) {
        PropertyBag apsInfo = this.getAPS(aps);
        if (apsInfo != null) {
            return apsInfo.getString((Object)PINGER);
        }
        return null;
    }

    Map getActivePingerIORs(String aps) {
        String clusterName = "";
        PropertyBag apsInfo = this.getAPS(aps);
        if (apsInfo != null) {
            clusterName = apsInfo.getString((Object)PropertyIDs.SI_CLUSTER_NAME);
        }
        HashMap<String, String> iors = new HashMap<String, String>();
        if (clusterName == null || clusterName.trim().length() == 0) {
            return iors;
        }
        ServerSpec spec = new ServerSpec("", "aps", "", clusterName);
        Set servers = this.queryServer(spec, true);
        Iterator iter = servers.iterator();
        while (iter.hasNext()) {
            apsInfo = (PropertyBag)iter.next();
            if (apsInfo == null) continue;
            iors.put(apsInfo.getString((Object)APS_NAME), apsInfo.getString((Object)PINGER));
        }
        return iors;
    }

    public void refreshClusterInfo(IDirectory directory) {
        ArrayList members;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"APSServerHander.refreshClusterInfo(): begin");
        }
        HashMap<String, ArrayList> cluster2CMSs = new HashMap<String, ArrayList>();
        Iterator iter = this.m_servers.bags().iterator();
        while (iter.hasNext()) {
            PropertyBag server = (PropertyBag)iter.next();
            String clusterName = server.getString((Object)PropertyIDs.SI_CLUSTER_NAME);
            String cmsName = server.getString((Object)APS_NAME);
            members = (ArrayList)cluster2CMSs.get(clusterName);
            if (members == null) {
                members = new ArrayList();
                cluster2CMSs.put(clusterName, members);
            }
            members.add(cmsName);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("APSServerHander.refreshClusterInfo(): refreshing " + cluster2CMSs.size() + " clusters"));
        }
        Iterator iter1 = cluster2CMSs.entrySet().iterator();
        block3: while (iter1.hasNext()) {
            Map.Entry entry = iter1.next();
            String clusterName = (String)entry.getKey();
            members = (ArrayList)entry.getValue();
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("APSServerHander.refreshClusterInfo(): refreshing cluster " + clusterName));
            }
            Iterator iter2 = members.iterator();
            while (iter2.hasNext()) {
                String cmsName = (String)iter2.next();
                ServerSpec spec = new ServerSpec("", "aps", cmsName, clusterName);
                try {
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug((Object)("APSServerHander.refreshClusterInfo(): refresh cluster info from cms " + cmsName));
                    }
                    this.buildClusterInfo(spec, "osca:iiop://;BYPASSSEC=true", directory);
                    continue block3;
                }
                catch (OCAFrameworkException e) {
                    if (!this.LOG.isWarnEnabled()) continue;
                    this.LOG.warn((Object)("refreshClusterInfo(): exception caugh when building cluster info for spec=" + spec), (Throwable)((Object)e));
                }
            }
        }
    }

    private Set queryAPSWithName(QBSet.Query apsQuery, String name) {
        Set svrResults;
        block12: {
            apsQuery.addTerm(SERVER_NAME, (Object)name);
            svrResults = this.getServers().query(apsQuery);
            if (svrResults.size() == 0) {
                apsQuery.removeTerm(SERVER_NAME);
                apsQuery.addTerm(PropertyIDs.SI_NAME, (Object)name);
                svrResults = this.getServers().query(apsQuery);
                if (svrResults.size() == 0) {
                    apsQuery.removeTerm(PropertyIDs.SI_NAME);
                    apsQuery.addTerm(APS_NAME, (Object)name);
                    svrResults = this.getServers().query(apsQuery);
                    if (svrResults.size() == 0) {
                        InetAddress[] addresses;
                        String apsPort;
                        String apsMachineName;
                        int index = APSServerHandler.findPortIndex(name);
                        if (index < 0) {
                            apsMachineName = name;
                            apsPort = DEFAULT_PORT_SUFFIX;
                        } else {
                            apsMachineName = name.substring(0, index);
                            apsPort = name.substring(index);
                        }
                        while (true) {
                            try {
                                addresses = InetAddress.getAllByName(apsMachineName);
                            }
                            catch (UnknownHostException e) {
                                int dot;
                                if (apsMachineName != null && (dot = apsMachineName.indexOf(46)) != -1) {
                                    apsMachineName = apsMachineName.substring(0, dot);
                                    continue;
                                }
                                break block12;
                            }
                            break;
                        }
                        for (int i = 0; i < addresses.length; ++i) {
                            InetAddress address = addresses[i];
                            apsQuery.removeTerm(APS_NAME);
                            apsQuery.addTerm(APS_NAME, (Object)(address.getHostAddress() + apsPort));
                            svrResults = this.getServers().query(apsQuery);
                            if (svrResults.size() != 0) break;
                            if (!address.isLoopbackAddress() && !address.isLinkLocalAddress()) continue;
                            try {
                                apsQuery.removeTerm(APS_NAME);
                                apsQuery.addTerm(APS_NAME, (Object)(InetAddress.getLocalHost().getHostAddress() + apsPort));
                                svrResults = this.getServers().query(apsQuery);
                                if (svrResults.size() == 0) continue;
                                break;
                            }
                            catch (UnknownHostException e) {
                                if (!this.LOG.isInfoEnabled()) continue;
                                this.LOG.info((Object)"(queryAPSWithName:297) ", (Throwable)e);
                            }
                        }
                    }
                }
            }
        }
        return svrResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildAPSClusterInfo(ServerSpec spec, IDirectory directory) throws OCAFrameworkException {
        IPropertyBag[] cluster;
        boolean succeed;
        OCAFrameworkException.NotFoundInDirectory originalEx;
        String aps;
        block13: {
            aps = spec.getAPS();
            if (aps.trim().length() == 0 && !"".equalsIgnoreCase(spec.getCluster())) {
                Set apses = this.m_persistedClustersInfo.getPersistedClusterMembers(spec.getCluster());
                if (apses.size() > 0) {
                    aps = (String)apses.toArray()[0];
                } else {
                    return;
                }
            }
            if (directory == null || this.m_bootstrapDirectory == null) {
                return;
            }
            originalEx = null;
            succeed = false;
            try {
                this.buildBootstrapAPSInfo(aps);
                succeed = true;
            }
            catch (OCAFrameworkException.NotFoundInDirectory e) {
                originalEx = e;
                Set members = this.m_persistedClustersInfo.getPersistedClusterMembers(aps);
                if (members == null || members.size() == 0) break block13;
                Iterator memberIter = members.iterator();
                while (memberIter.hasNext()) {
                    APSComparator comparator = APS_COMPARATOR;
                    String member = (String)memberIter.next();
                    if (comparator.compare(member, aps) == 0) continue;
                    try {
                        this.buildBootstrapAPSInfo(member);
                        aps = member;
                        spec.setAPS(member);
                        spec.setName(member);
                        succeed = true;
                        break;
                    }
                    catch (OCAFrameworkException.NotFoundInDirectory ex) {
                    }
                }
            }
        }
        if (!succeed) {
            throw originalEx;
        }
        try {
            ServerSpec bootStrapSpec = new ServerSpec("", "aps", aps, BOOTSTRAP_CLUSTER);
            cluster = directory.find(bootStrapSpec, "osca:iiop://;BYPASSSEC=true", this.m_queryIDsString, 0);
        }
        finally {
            this.clearBootstrapAPSInfo(aps);
        }
        this.buildAPSInfo(cluster);
        this.m_persistedClustersInfo.updatePersistedClustersInfo(this);
    }

    private void buildAPSInfo(IPropertyBag[] cluster) {
        HashSet<String> validAPSNames = new HashSet<String>(cluster.length);
        Long time = new Long(System.currentTimeMillis());
        ORB orb = ServiceMgrFactory.getServiceMgr().getORB();
        for (int i = 0; i < cluster.length; ++i) {
            boolean retried;
            String portNumber;
            String apsHostName;
            IPropertyBag apsInfo = cluster[i];
            String serverName = apsInfo.getString(PropertyIDs.SI_SERVER_NAME);
            if (serverName == null) continue;
            int index = APSServerHandler.findPortIndex(serverName);
            if (index < 0) {
                apsHostName = serverName;
                portNumber = DEFAULT_PORT_SUFFIX;
                serverName = serverName + DEFAULT_PORT_SUFFIX;
            } else {
                apsHostName = serverName.substring(0, index);
                portNumber = serverName.substring(index);
            }
            apsInfo.setProperty((Object)SERVER_TIMESTAMP, time);
            if (apsInfo.getInt(PropertyIDs.SI_SERVER_IS_ALIVE) == 1) {
                apsInfo.setProperty((Object)SERVER_VALID, VALID);
            } else {
                if (validAPSNames.contains(serverName)) continue;
                apsInfo.setProperty((Object)SERVER_VALID, INVALID);
            }
            apsInfo.setProperty((Object)SERVER_NAME, serverName);
            if (this.isValidServer(apsInfo)) {
                try {
                    String ior = apsInfo.getString(PropertyIDs.SI_SERVER_IOR);
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug((Object)("buildAPSInfo(): ior=" + ior));
                    }
                    OSCAFactory f = OSCAFactoryHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)orb.string_to_object(ior));
                    com.crystaldecisions.thirdparty.org.omg.CORBA.Object pingstub = f.newService("Pinger", "osca:iiop://;BYPASSSEC=true");
                    String pingior = orb.object_to_string(pingstub);
                    apsInfo.setProperty((Object)PINGER, pingior);
                }
                catch (connection_failure connection_failure2) {
                    this.LOG.warn((Object)("buildAPSInfo(): aps=" + apsInfo.getString(APS_NAME) + ",ior=" + apsInfo.getString(PropertyIDs.SI_SERVER_IOR)), (Throwable)connection_failure2);
                }
                catch (SystemException e) {
                    this.LOG.warn((Object)("buildAPSInfo(): aps=" + apsInfo.getString(APS_NAME) + ",ior=" + apsInfo.getString(PropertyIDs.SI_SERVER_IOR)), (Throwable)e);
                    apsInfo.setProperty((Object)SERVER_VALID, INVALID_FAILED);
                }
                validAPSNames.add(serverName);
            }
            HashSet<String> apsNames = new HashSet<String>();
            apsNames.add(serverName);
            String hostName = apsHostName;
            do {
                try {
                    InetAddress[] allAddress = InetAddress.getAllByName(hostName);
                    for (int j = 0; j < allAddress.length; ++j) {
                        InetAddress address = allAddress[j];
                        if (this.LOG.isInfoEnabled()) {
                            this.LOG.info((Object)("(buildAPSInfo:429) address for host " + hostName + ":" + address));
                        }
                        if (this.LOG.isDebugEnabled()) {
                            this.LOG.debug((Object)("(buildAPSInfo:433): address " + address.getHostAddress() + portNumber));
                        }
                        apsNames.add(address.getHostAddress() + portNumber);
                        if (!hostName.equals(address.getHostAddress())) continue;
                        apsNames.add(address.getCanonicalHostName() + portNumber);
                    }
                    retried = false;
                }
                catch (UnknownHostException e) {
                    int dot;
                    if (this.LOG.isInfoEnabled()) {
                        this.LOG.info((Object)("(buildAPSInfo:438) host not found, try short form name " + hostName), (Throwable)e);
                    }
                    if ((dot = hostName.indexOf(46)) != -1) {
                        hostName = hostName.substring(0, dot);
                        retried = true;
                        continue;
                    }
                    retried = false;
                }
            } while (retried);
            Iterator apsIter = apsNames.iterator();
            while (apsIter.hasNext()) {
                String apsName = (String)apsIter.next();
                IPropertyBag apsInfoBag = apsInfo.copyBag();
                apsInfoBag.setProperty((Object)APS_NAME, apsName);
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("(buildAPSInfo:448): removing aps from cache " + apsName));
                }
                this.clearAPSInfo(apsName);
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("(buildAPSInfo:454): adding aps info bag " + apsInfoBag));
                }
                this.addServer(apsInfoBag);
            }
        }
    }

    private void clearAPSInfo(String aps) {
        QBSet.Query apsQuery = new QBSet.Query();
        apsQuery.addTerm(APS_NAME, (Object)aps);
        Set svrResults = this.getServers().query(apsQuery);
        this.getServers().removeAll((Collection)svrResults);
    }

    private void clearBootstrapAPSInfo(String aps) {
        QBSet.Query apsQuery = new QBSet.Query();
        apsQuery.addTerm(APS_NAME, (Object)aps);
        apsQuery.addTerm(PropertyIDs.SI_CLUSTER_NAME, (Object)BOOTSTRAP_CLUSTER);
        Set svrResults = this.getServers().query(apsQuery);
        this.getServers().removeAll((Collection)svrResults);
    }

    private PropertyBag getAPS(String aps) {
        Set results = this.queryServer(new ServerSpec(aps, "aps", aps), false);
        if (results.size() == 0) {
            return null;
        }
        return (PropertyBag)results.iterator().next();
    }

    private boolean isValidServer(IPropertyBag serverInfo) {
        IProperty prop;
        if (serverInfo != null && (prop = serverInfo.getProperty(SERVER_VALID)) != null) {
            return VALID.equals(prop.getValue());
        }
        return false;
    }
}

