/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.classloader.ClassLoaderHelper;
import com.crystaldecisions.celib.properties.CaseInsensComparator;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.properties.QBSet;
import com.crystaldecisions.enterprise.ocaframework.AbstractServerHandler;
import com.crystaldecisions.enterprise.ocaframework.AbstractServiceHandler;
import com.crystaldecisions.enterprise.ocaframework.FrameworkPropertyBag;
import com.crystaldecisions.enterprise.ocaframework.IDirectory;
import com.crystaldecisions.enterprise.ocaframework.IInvocationHandler;
import com.crystaldecisions.enterprise.ocaframework.IProperty;
import com.crystaldecisions.enterprise.ocaframework.IPropertyBag;
import com.crystaldecisions.enterprise.ocaframework.IServerHandler;
import com.crystaldecisions.enterprise.ocaframework.IServiceHandler;
import com.crystaldecisions.enterprise.ocaframework.IServiceHandlerFactory;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.enterprise.ocaframework.ServerHelper;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceDirectory;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactoryHelper;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.UserException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class AbstractSmartServerHandler
extends AbstractServerHandler
implements IServerHandler {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.AbstractSmartServerHandler");
    protected static final Integer SI_STATUS = PropertyIDs.define("SI_STATUS");
    protected static final Integer SI_DISABLED = PropertyIDs.define("SI_DISABLED");
    protected static final Integer SI_CUID = PropertyIDs.define("SI_CUID");
    protected static final Integer SERVER_PINGER = PropertyIDs.define("SERVER_PINGER");
    protected static HashMap s_serviceIDMap = new HashMap();
    protected static HashMap s_serviceCUIDMap = new HashMap();
    protected static Map s_serviceHandlersByClassLoader = new WeakHashMap(1);
    private static ServiceDirectory s_serviceDirectory = new ServiceDirectory();
    private static final String DEFAULT_QUERY_IDS = IDHelper.toQueryString((Integer[])new Integer[]{PropertyIDs.SI_SERVER_NAME, PropertyIDs.SI_SERVER_KIND, PropertyIDs.SI_SERVER_IOR, PropertyIDs.SI_TIMESTAMP, PropertyIDs.SI_DISABLED});
    private IServiceHandler m_defaultServiceHandler = new AbstractServiceHandler(){};
    private QBSet m_services;
    private static final IInvocationHandler s_handler = new GetPingerIORHandler();
    private static final GetServicesHandler s_getServicesHandler = new GetServicesHandler();

    protected QBSet getServices() {
        return this.m_services;
    }

    protected AbstractSmartServerHandler() {
        this.m_services = new QBSet(new Integer[]{PropertyIDs.SI_CLUSTER_NAME, PropertyIDs.SI_SERVICE, SERVER_NAME}, new Comparator[]{new CaseInsensComparator(), new CaseInsensComparator(), new CaseInsensComparator()});
        this.m_queryIDsString = DEFAULT_QUERY_IDS;
    }

    protected AbstractSmartServerHandler(Integer[] indexes, Comparator[] comparators) {
        super(indexes, comparators);
        this.m_services = new QBSet(new Integer[]{PropertyIDs.SI_CLUSTER_NAME, PropertyIDs.SI_SERVICE, SERVER_NAME}, new Comparator[]{new CaseInsensComparator(), new CaseInsensComparator(), new CaseInsensComparator()});
        this.m_queryIDsString = DEFAULT_QUERY_IDS;
    }

    protected AbstractSmartServerHandler(Integer[] indexes, Comparator[] comparators, Integer[] serviceIndexes, Comparator[] serviceComparators) {
        super(indexes, comparators);
        this.m_services = new QBSet(serviceIndexes, serviceComparators);
        this.m_queryIDsString = DEFAULT_QUERY_IDS;
    }

    public Set queryServer(ServerSpec spec, boolean validOnly) {
        Set results = super.queryServer(spec, validOnly);
        String serviceName = spec.getServiceName();
        if (serviceName != null && serviceName.length() > 0) {
            LinkedHashSet<PropertyBag> filtered = new LinkedHashSet<PropertyBag>();
            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                PropertyBag bag = (PropertyBag)iter.next();
                String serverName = bag.getString((Object)SERVER_NAME);
                String clusterName = bag.getString((Object)PropertyIDs.SI_CLUSTER_NAME);
                QBSet.Query query = new QBSet.Query();
                query.addTerm(SERVER_NAME, (Object)serverName);
                query.addTerm(PropertyIDs.SI_CLUSTER_NAME, (Object)clusterName);
                query.addTerm(PropertyIDs.SI_SERVICE, (Object)serviceName);
                if (this.m_services.query(query).size() == 0) continue;
                PropertyBag copy = bag.copy();
                copy.setProperty((Object)PropertyIDs.SI_SERVICE, (Object)serviceName);
                filtered.add(copy);
            }
            return filtered;
        }
        return results;
    }

    public IPropertyBag selectServer(Collection servers) {
        IServiceHandler handler;
        String serviceName;
        Iterator iter = servers.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        IPropertyBag firstServer = (IPropertyBag)iter.next();
        if (firstServer != null && (serviceName = firstServer.getString(PropertyIDs.SI_SERVICE)) != null && (handler = this.getServiceHandler(serviceName)) != null && handler.isServiceBasedServerSelection()) {
            return handler.selectServer(servers);
        }
        return super.selectServer(servers);
    }

    public void clearServerInfo(ServerSpec spec) {
        super.clearServerInfo(spec);
        String serverName = spec.getName();
        String clusterName = spec.getCluster();
        QBSet.Query query = new QBSet.Query();
        if (clusterName != null && clusterName.length() != 0) {
            query.addTerm(PropertyIDs.SI_CLUSTER_NAME, (Object)clusterName);
        }
        if (serverName != null && serverName.length() != 0) {
            query.addTerm(SERVER_NAME, (Object)serverName);
        }
        Set results = this.m_services.query(query);
        this.m_services.removeAll((Collection)results);
    }

    public void buildServerInfo(ServerSpec spec, String uri, IDirectory directory) throws OCAFrameworkException {
        IPropertyBag[] found = directory.find(spec, uri, this.m_queryIDsString, 0);
        Long now = new Long(System.currentTimeMillis());
        for (int i = 0; i < found.length; ++i) {
            IPropertyBag bag = found[i];
            bag.setProperty((Object)SERVER_TIMESTAMP, now);
            String cluster = spec.getCluster();
            bag.setProperty((Object)PropertyIDs.SI_CLUSTER_NAME, cluster);
            bag.setProperty((Object)APS_NAME, spec.getAPS());
            String serverName = bag.getString(PropertyIDs.SI_NAME);
            bag.setProperty((Object)SERVER_NAME, serverName);
            this.clearServerInfo(new ServerSpec(serverName, bag.getString(PropertyIDs.SI_SERVER_KIND), spec.getAPS(), cluster));
            this.setServerValidity(bag);
            if (this.isPingerNeeded() && this.isValidServer(bag)) {
                this.setPinger(bag);
            }
            if (this.isValidServer(bag)) {
                this.addServices(bag, cluster, serverName);
            }
            LOG.assertTrue(this.m_servers.add((PropertyBag)bag), "buildServerInfo(): adding to cache should succeed");
        }
    }

    protected void setServerValidity(IPropertyBag bag) {
        if (!bag.getBoolean(PropertyIDs.SI_DISABLED)) {
            bag.setProperty((Object)SERVER_VALID, VALID);
        } else {
            bag.setProperty((Object)SERVER_VALID, INVALID);
        }
    }

    protected void addServices(IPropertyBag bag, String cluster, String serverName) {
        block6: {
            if (!this.isValidServer(bag)) {
                return;
            }
            String ior = bag.getString(PropertyIDs.SI_SERVER_IOR);
            try {
                String[] services = (String[])ServerHelper.invokeServer(bag, ior, s_getServicesHandler);
                for (int j = 0; j < services.length; ++j) {
                    String serviceName = services[j];
                    FrameworkPropertyBag serviceBag = new FrameworkPropertyBag();
                    serviceBag.setProperty(PropertyIDs.SI_CLUSTER_NAME, cluster);
                    serviceBag.setProperty(SERVER_NAME, serverName);
                    serviceBag.setProperty(PropertyIDs.SI_SERVICE, serviceName);
                    this.m_services.add((PropertyBag)serviceBag);
                }
            }
            catch (UserException connection_failure2) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"(addServices:248) connection failure when getting service, ignore");
                }
            }
            catch (SystemException t) {
                if (!LOG.isInfoEnabled()) break block6;
                LOG.info((Object)"(addServices:253) system exceptiong when getting services, ignore", (Throwable)t);
            }
        }
    }

    protected boolean isPingerNeeded() {
        return false;
    }

    protected boolean isValidServer(IPropertyBag serverInfo) {
        IProperty prop;
        if (serverInfo != null && (prop = serverInfo.getProperty(SERVER_VALID)) != null) {
            return VALID.equals(prop.getValue());
        }
        return false;
    }

    private void setPinger(IPropertyBag bag) {
        block6: {
            if (this.isValidServer(bag)) {
                String ior = bag.getString(PropertyIDs.SI_SERVER_IOR);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("setPinger(): ior=" + ior));
                }
                Object pingerior = null;
                try {
                    pingerior = ServerHelper.invokeServer(bag, ior, s_handler);
                    bag.setProperty((Object)SERVER_PINGER, pingerior);
                }
                catch (UserException e) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)"(setPinger:278) exception during get pinger", (Throwable)e);
                    }
                }
                catch (SystemException e) {
                    if (!LOG.isInfoEnabled()) break block6;
                    LOG.info((Object)"(setPinger:283) system exception during getting pinger", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getServiceName(ServerSpec spec, Integer id) throws OCAFrameworkException {
        String serviceName;
        if (id == null || 0 == id) {
            return null;
        }
        HashMap hashMap = s_serviceIDMap;
        synchronized (hashMap) {
            serviceName = (String)s_serviceIDMap.get(id);
        }
        if (serviceName == null) {
            this.populateServicesMaps(spec);
            hashMap = s_serviceIDMap;
            synchronized (hashMap) {
                serviceName = (String)s_serviceIDMap.get(id);
            }
        }
        return serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateServicesMaps(ServerSpec spec) throws OCAFrameworkException {
        IPropertyBag service;
        int i;
        IPropertyBag[] services = s_serviceDirectory.find(spec, "osca:iiop://;BYPASSSEC=true", "SI_NAME, SI_ID, SI_CUID", 0);
        HashMap hashMap = s_serviceCUIDMap;
        synchronized (hashMap) {
            for (i = 0; i < services.length; ++i) {
                service = services[i];
                String svcName = service.getString(PropertyIDs.SI_NAME);
                String svcCuid = service.getString(PropertyIDs.SI_CUID);
                s_serviceCUIDMap.put(svcCuid, svcName);
            }
        }
        hashMap = s_serviceIDMap;
        synchronized (hashMap) {
            for (i = 0; i < services.length; ++i) {
                service = services[i];
                String name = service.getString(PropertyIDs.SI_NAME);
                int id = service.getInt(PropertyIDs.SI_ID);
                s_serviceIDMap.put(new Integer(id), name);
            }
        }
    }

    synchronized IServiceHandler getServiceHandler(String serviceName) {
        IServiceHandler handler;
        HashMap<String, IServiceHandler> serviceHandlers = (HashMap<String, IServiceHandler>)s_serviceHandlersByClassLoader.get(Thread.currentThread().getContextClassLoader());
        if (serviceHandlers == null) {
            serviceHandlers = new HashMap<String, IServiceHandler>();
            s_serviceHandlersByClassLoader.put(Thread.currentThread().getContextClassLoader(), serviceHandlers);
        }
        if ((handler = (IServiceHandler)serviceHandlers.get(serviceName)) == null) {
            try {
                String propFileName = "META-INF/CrystalEnterprise.Services/" + serviceName + ".properties";
                InputStream propertyStream = ClassLoaderHelper.getResourceAsStream((String)propFileName);
                if (propertyStream != null) {
                    Properties infoProperties = new Properties();
                    infoProperties.load(propertyStream);
                    propertyStream.close();
                    IServiceHandlerFactory factory = null;
                    String factoryName = infoProperties.getProperty("factory");
                    if (factoryName != null) {
                        Class clazz = ClassLoaderHelper.loadClass((String)factoryName);
                        Method method = null;
                        method = clazz.getMethod("getFactory", null);
                        factory = (IServiceHandlerFactory)method.invoke(null, null);
                        handler = factory.makeHandler();
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Service " + serviceName + " does not have a factory.  Use default service handler"));
                        }
                        handler = this.m_defaultServiceHandler;
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Service " + serviceName + " does not have a properties file.  Use default service handler"));
                    }
                    handler = this.m_defaultServiceHandler;
                }
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Service " + serviceName + " does not have ISerivceHandlerFactory implementation.  Use default service handler"));
                }
                handler = this.m_defaultServiceHandler;
            }
            serviceHandlers.put(serviceName, handler);
        }
        return handler;
    }

    private static class GetServicesHandler
    implements IInvocationHandler {
        private GetServicesHandler() {
        }

        public Object invoke(com.crystaldecisions.thirdparty.org.omg.CORBA.Object obj) throws SystemException, UserException {
            OSCAFactory f = OSCAFactoryHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)obj);
            return f.getServices();
        }

        public String toString() {
            return "GetServiceshandler";
        }
    }

    private static class GetPingerIORHandler
    implements IInvocationHandler {
        private GetPingerIORHandler() {
        }

        public Object invoke(com.crystaldecisions.thirdparty.org.omg.CORBA.Object obj) throws SystemException, UserException {
            OSCAFactory f = OSCAFactoryHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)obj);
            com.crystaldecisions.thirdparty.org.omg.CORBA.Object pingstub = f.newService("Pinger", "");
            return ServiceMgrFactory.getServiceMgr().getORB().object_to_string(pingstub);
        }

        public String toString() {
            return "GetPingerIORHandler";
        }
    }
}

