/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.holder.StringHolder;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.uri.OcaURI;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Packer;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.LogonEx4;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.LogonEx4Helper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.net.InetAddress;
import java.net.UnknownHostException;

class FailoverLogonService {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.FailoverLogonService");

    FailoverLogonService() {
    }

    void logonWithToken(String aps, String token, StringHolder uriHolder, StringHolder tokenHolder) throws OCAFrameworkException {
        LOG.debug((Object)"enter: logonWithToken()");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("logonWithToken(): aps=" + aps + ",token=" + token));
        }
        int delim = token.indexOf(64);
        String realToken = token.substring(delim + 1);
        try {
            LOG.debug((Object)"logonWithToken(): Getting unmanaged logon service");
            LogonEx4 stub = LogonEx4Helper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)ServiceMgrFactory.getServiceMgr().getUnmanagedService("Logon", new ServerSpec(aps, "aps", aps), ""));
            com.crystaldecisions.thirdparty.org.omg.CORBA.StringHolder logonPropsHolder = new com.crystaldecisions.thirdparty.org.omg.CORBA.StringHolder();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("logonWithToken(): logoning with token " + realToken));
            }
            String ipInfo = "";
            try {
                InetAddress addr = InetAddress.getLocalHost();
                String ip = addr.getHostAddress();
                String hostname = addr.getCanonicalHostName();
                PropertyBag newbag = new PropertyBag();
                newbag.addItem((Object)"SI_FIRST_IP", (Object)ip, 0);
                newbag.addItem((Object)"SI_FIRST_HOSTNAME", (Object)hostname, 0);
                WireOb3Packer packer = new WireOb3Packer();
                ipInfo = packer.pack(newbag, -1, 0, false, 0, 0);
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            int status = stub.LogonWithTokenEx4(1200, ipInfo, realToken + "FAILVR", logonPropsHolder);
            WireOb3Unpacker unpacker = new WireOb3Unpacker();
            unpacker.initialize(logonPropsHolder.value);
            PropertyBag pbh = new PropertyBag();
            pbh.unpack((IBagUnpacker)unpacker);
            String sessionID = pbh.getString((Object)PropertyIDs.SESSIONID);
            tokenHolder.set(aps + '@' + pbh.getString((Object)PropertyIDs.SI_FAILOVER_TOKEN));
            OcaURI userURI = new OcaURI(aps, PropertyIDs.SESSIONID, sessionID);
            uriHolder.set(userURI.toString());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("logonWithToken(): new uri=" + uriHolder.get() + ", new token=" + tokenHolder.get()));
            }
        }
        catch (oca_abuse e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("logonWithToken(): Failed to relogon, aps=" + aps + ",token=" + realToken + ", errorCode=" + e.errCode), (Throwable)e);
            }
            throw new OCAFrameworkException.LogonFailover(aps, (Exception)((Object)e));
        }
        catch (SystemException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("logonWithToken(): Failed to relogon, aps=" + aps + ",token=" + realToken), (Throwable)e);
            }
            throw new OCAFrameworkException.CommunicationError(aps, e);
        }
        LOG.debug((Object)"exit: logonWithToken()");
    }
}

