/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.IInvocationCallback;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.enterprise.ocaframework.ManagedSession;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgr;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.UNKNOWN;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

class ManagedService
implements IManagedService {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.ManagedService");
    private static final int OK = 1;
    private static final int INVALID = 2;
    private static final int DEAD = 6;
    private static final int SUSPENDED = 7;
    private static final int INVOKE_LOOP_INSANITY = 5;
    static final boolean TESTS_ENABLED = false;
    private ServiceMgr m_mgr;
    private ManagedSession m_session;
    private String m_svc;
    private ServerSpec m_spec;
    private String m_id;
    private Object m_stub;
    private IManagedService.IStubHelper m_helper;
    private int m_state;
    private int m_failoverTicket;
    private Throwable m_causeOfDeath;

    public ManagedService(ServiceMgr mgr, ManagedSession session, String id, String svc, ServerSpec spec, IManagedService.IStubHelper narrower) {
        this.m_mgr = mgr;
        this.m_session = session;
        this.m_svc = svc;
        this.m_spec = spec;
        this.m_helper = narrower;
        this.m_state = 2;
        this.m_id = id;
    }

    public String getSvc() {
        return this.m_svc;
    }

    public ServerSpec getSvr() {
        return this.m_spec;
    }

    public String getAPS() {
        return this.m_spec.getAPS();
    }

    public String getURI() {
        return this.m_session.getURI();
    }

    public String getToken() {
        return this.m_session.getToken();
    }

    public String getID() {
        return this.m_id;
    }

    public synchronized String getCookie() {
        return this.m_spec.getCookie();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCookie(String cookie) {
        ManagedService managedService = this;
        synchronized (managedService) {
            this.m_spec.setCookie(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setID(String id) {
        this.m_session.lock();
        try {
            if (!this.m_id.equals(id)) {
                this.m_session.releaseLock();
                this.m_session.lockModify();
                this.m_session.removeService(this);
                this.m_id = id;
                this.m_session.putService(this.m_spec, this);
            }
        }
        finally {
            this.m_session.releaseLock();
        }
    }

    public IManagedService.IStubHelper getHelper() {
        return this.m_helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDead() {
        this.m_session.lock();
        try {
            boolean bl = this.m_state == 6;
            return bl;
        }
        finally {
            this.m_session.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Method method, Object[] args, Map context) throws Exception {
        boolean attemptRetry;
        int retries = 0;
        Throwable causeOfDeath = null;
        int numofRetries = 5;
        if (context.get("NUM_OF_RETRIES") != null) {
            try {
                numofRetries = (Integer)context.get("NUM_OF_RETRIES");
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (!ServiceMgr.isCleanupThreadActivated()) {
            this.m_mgr.pulse(false);
        }
        do {
            boolean readForRetry;
            block67: {
                int failoverTicket;
                Object stub;
                int state;
                try {
                    this.m_session.lock();
                    try {
                        this.m_session.checkValidity();
                    }
                    catch (OCAFrameworkException e) {
                        if (LOG.isDebugEnabled()) {
                            if (this.m_session != null) {
                                LOG.debug((Object)("invoke: ManagedExpiredException1(): aps=" + this.m_session.getAPS() + ",uri=" + this.m_session.getURI()));
                            } else {
                                LOG.debug((Object)"invoke: ManagedExpiredException1(): session is null");
                            }
                        }
                        if (this.m_session.isExpired()) {
                            throw new IManagedService.ManagedExpiredException(e);
                        }
                        throw new IManagedService.ManagedLogoffException(e);
                    }
                    state = this.m_state;
                    stub = this.m_stub;
                    causeOfDeath = this.m_causeOfDeath;
                    failoverTicket = this.m_failoverTicket;
                }
                finally {
                    this.m_session.releaseLock();
                }
                if (state == 1) {
                    try {
                        IInvocationCallback callback;
                        if (LOG.isDebugEnabled()) {
                            LOG.logEntry(stub.getClass().getName(), method.getName(), args);
                        }
                        long startTime = 0L;
                        if (LOG.isDebugEnabled()) {
                            startTime = System.currentTimeMillis();
                            LOG.debug((Object)("(invoke:405): start time=" + startTime));
                        }
                        Object result = (callback = (IInvocationCallback)context.get("INVOCATION_CALLBACK")) != null ? callback.invoke(method, stub, args, new ServerSpec(this.m_spec)) : method.invoke(stub, args);
                        if (LOG.isDebugEnabled()) {
                            long now = System.currentTimeMillis();
                            LOG.debug((Object)("(invoke:411): end time=" + now + ",duration=" + (now - startTime)));
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.logReturn(stub.getClass().getName(), method.getName(), result);
                        }
                        return result;
                    }
                    catch (IllegalAccessException e) {
                        LOG.error((Object)"invoke(): this should never happen", (Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        LOG.error((Object)"invoke(): this should never happen", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        this.handleRecoverableException(t, retries, numofRetries);
                    }
                    catch (Throwable e) {
                        this.handleRecoverableException(e, retries, numofRetries);
                    }
                } else if (state == 6) break;
                if (state == 1) {
                    this.m_session.lock();
                    try {
                        if (this.m_state == 1 && failoverTicket != this.m_failoverTicket) {
                            readForRetry = true;
                        }
                        readForRetry = false;
                    }
                    finally {
                        this.m_session.releaseLock();
                    }
                } else {
                    readForRetry = false;
                }
                if (!readForRetry) {
                    try {
                        this.m_session.lockModify();
                        if (this.m_state == 1) {
                            if (failoverTicket == this.m_failoverTicket) {
                                try {
                                    if (LOG.isInfoEnabled()) {
                                        LOG.info((Object)("invoke(): Invalidating " + this));
                                    }
                                    this.invalidate();
                                    this.m_state = 2;
                                    if (this.getHelper().isStateful()) {
                                        throw new OCAFrameworkException.CommunicationError(this.m_spec.getName(), null);
                                    }
                                }
                                catch (Throwable e) {
                                    this.m_state = this.getRecoverState();
                                    this.m_causeOfDeath = e;
                                    causeOfDeath = e;
                                    LOG.fatal((Object)("invoke(): the service is dead " + this), e);
                                    this.m_session.remove(this);
                                    readForRetry = false;
                                }
                            } else {
                                readForRetry = true;
                            }
                        }
                        if (this.m_state != 2 && this.m_state != 7) break block67;
                        int waitTimeSeconds = 0;
                        try {
                            Integer waitTimeInteger = (Integer)context.get("WAIT_SECONDS_BETWEEN_RETRIES");
                            if (waitTimeInteger != null) {
                                waitTimeSeconds = waitTimeInteger;
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        if (waitTimeSeconds > 0) {
                            LOG.debug((Object)("Waiting " + String.valueOf(waitTimeSeconds) + " seconds before retrying"));
                            Thread.sleep(waitTimeSeconds * 1000);
                        }
                        try {
                            if (LOG.isInfoEnabled()) {
                                LOG.info((Object)("invoke(): Validating " + this));
                            }
                            boolean enforceLB = this.getSvr().isReplaceable() && !this.getHelper().isStateful();
                            this.m_session.validate(this, enforceLB);
                            this.m_state = 1;
                            ++this.m_failoverTicket;
                            readForRetry = true;
                        }
                        catch (Throwable e) {
                            this.m_state = this.getRecoverState();
                            this.m_causeOfDeath = e;
                            causeOfDeath = e;
                            if (e instanceof OCAFrameworkException.LogonFailover) {
                                if (LOG.isWarnEnabled()) {
                                    LOG.warn((Object)"invoke(): the service is dead ", e);
                                }
                            } else if (LOG.isFatalEnabled()) {
                                LOG.fatal((Object)"invoke(): the service is dead ", e);
                            }
                            this.m_session.remove(this);
                            readForRetry = false;
                        }
                    }
                    finally {
                        this.m_session.releaseLock();
                    }
                }
            }
            if (readForRetry) {
                if (!this.retryAllowed(context)) {
                    throw new IManagedService.ManagedServiceRetryException();
                }
                if (retries < numofRetries) {
                    attemptRetry = true;
                    ++retries;
                    continue;
                }
                attemptRetry = false;
                continue;
            }
            attemptRetry = false;
        } while (attemptRetry);
        try {
            throw causeOfDeath;
        }
        catch (OCAFrameworkException.LogonFailover e) {
            if (LOG.isDebugEnabled()) {
                if (this.m_session != null) {
                    LOG.debug((Object)("invoke: ManagedExpiredException2(): aps=" + this.m_session.getAPS() + ",uri=" + this.m_session.getURI()));
                } else {
                    LOG.debug((Object)"invoke: ManagedExpiredException2(): session is null");
                }
            }
            throw new IManagedService.ManagedLogoffException(e);
        }
        catch (OCAFrameworkException oca) {
            oca_abuse abuse = oca.convertToOcaAbuse();
            if (abuse != null) {
                Class<?>[] exceptions = method.getExceptionTypes();
                for (int i = 0; i < exceptions.length; ++i) {
                    Class<?> exception = exceptions[i];
                    if (!exception.equals(((Object)((Object)abuse)).getClass())) continue;
                    throw abuse;
                }
            }
            throw new IManagedService.ManagedServiceFatalException((Throwable)((Object)oca));
        }
        catch (Throwable t) {
            throw new IManagedService.ManagedServiceFatalException(t);
        }
    }

    private void handleRecoverableException(Throwable t, int retries, int numofRetries) throws Exception {
        if (this.m_helper.isRecoverable(t) && retries < numofRetries) {
            LOG.warn((Object)"invoke(): recoverable exception", t);
        } else {
            LOG.warn((Object)"invoke(): Irrecovrable exception", t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            LOG.assertTrue(false, "invoke(): never will get here");
        }
    }

    private boolean retryAllowed(Map context) {
        return context.get("SERVICE_NO_RETRIES") == null || !Boolean.TRUE.equals(context.get("SERVICE_NO_RETRIES"));
    }

    private int getRecoverState() {
        return this.getHelper().isStateful() ? 6 : 7;
    }

    public String toString() {
        return "ManagedService(" + this.m_state + "," + this.m_svc + ", " + this.m_spec.getName() + ", " + this.m_session.getAPS() + ", " + this.m_session.getURI() + ", " + this.m_session.getToken() + ")";
    }

    ManagedSession getSession() {
        return this.m_session;
    }

    void invalidate() {
        this.invalidateStub();
        this.m_state = 2;
    }

    void kill(Exception cause) {
        this.invalidateStub();
        this.m_state = 6;
        this.m_causeOfDeath = cause == null ? new UNKNOWN() : cause;
    }

    void suspend(Exception cause) {
        this.invalidateStub();
        this.m_state = 7;
        this.m_causeOfDeath = cause == null ? new UNKNOWN() : cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(Exception e) {
        this.m_session.lockModify();
        try {
            this.kill(e);
            this.m_session.remove(this);
        }
        finally {
            this.m_session.releaseLock();
        }
    }

    void release() {
        if (this.m_stub != null) {
            try {
                this.m_helper.release(this.m_stub);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.invalidateStub();
    }

    void expire() {
        block4: {
            if (this.m_stub != null) {
                try {
                    if (this.m_helper instanceof IManagedService.IStubHelperEx) {
                        ((IManagedService.IStubHelperEx)this.m_helper).expire(this.m_stub);
                    }
                }
                catch (Throwable t) {
                    if (!LOG.isInfoEnabled()) break block4;
                    LOG.info((Object)"(expire:680) exception during expiration");
                }
            }
        }
        this.m_state = 2;
        this.invalidateStub();
    }

    private void invalidateStub() {
        this.m_stub = null;
    }

    void setSvc(String svc) {
        this.m_svc = svc;
    }

    void setSvr(ServerSpec svr) {
        this.m_spec = svr;
    }

    void validate() throws OCAFrameworkException {
        LOG.assertTrue(this.m_state == 2, "validate(): must be invald to be validated");
        try {
            com.crystaldecisions.thirdparty.org.omg.CORBA.Object object = this.m_helper.getService(this.m_svc, this.m_spec, this.getURI(), this.getToken());
            if (object == null) {
                throw new OCAFrameworkException.ServiceNotFound(this.m_svc, this.m_spec.getName());
            }
            this.m_stub = this.m_helper.narrow(object);
            this.m_state = 1;
        }
        catch (SystemException e) {
            LOG.warn((Object)"validate(): failed to narrow object", (Throwable)e);
            throw new OCAFrameworkException.CommunicationError(this.m_spec.getName(), e);
        }
    }
}

