/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.properties.QBSet;
import com.crystaldecisions.enterprise.ocaframework.AbstractSmartServerHandler;
import com.crystaldecisions.enterprise.ocaframework.IInvocationHandler;
import com.crystaldecisions.enterprise.ocaframework.IPropertyBag;
import com.crystaldecisions.enterprise.ocaframework.IServerHandler;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.enterprise.ocaframework.ServerHelper;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgr;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactoryHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.PingerEx;
import com.crystaldecisions.enterprise.ocaframework.idl.PingerExHelper;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORB;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.UserException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

class PJSServerHandler
extends AbstractSmartServerHandler
implements IServerHandler {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.PJSServerHandler");
    private static final String DEFAULT_QUERY_IDS = IDHelper.toQueryString((Integer[])new Integer[]{PropertyIDs.SI_SERVER_NAME, PropertyIDs.SI_SERVER_KIND, PropertyIDs.SI_SERVER_IOR, PropertyIDs.SI_DISABLED});

    protected PJSServerHandler() {
        this.m_queryIDsString = DEFAULT_QUERY_IDS;
    }

    protected PJSServerHandler(Integer[] indexes, Comparator[] comparators) {
        super(indexes, comparators);
        this.m_queryIDsString = DEFAULT_QUERY_IDS;
    }

    public String toString() {
        return "PJSServerHandler: servers=" + this.m_servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pingServers() {
        Iterator<Object> iter;
        ServiceMgr svcMgr = (ServiceMgr)ServiceMgrFactory.getServiceMgr();
        HashMap serviceInfoMap = new HashMap();
        LinkedList<String> pingers = new LinkedList<String>();
        svcMgr.lock();
        try {
            iter = this.m_servers.bags().iterator();
            while (iter.hasNext()) {
                Property pingerProp;
                PropertyBag bag = (PropertyBag)iter.next();
                Property validProp = bag.getItem((Object)SERVER_VALID);
                if (validProp == null || !VALID.equals(validProp.getValue()) && !INVALID.equals(validProp.getValue()) || (pingerProp = bag.getItem((Object)SERVER_PINGER)) == null) continue;
                String pingerIOR = pingerProp.getString();
                pingers.add(pingerIOR);
                String server = bag.getString((Object)SERVER_NAME);
                serviceInfoMap.put(server, new HashSet());
            }
        }
        finally {
            svcMgr.releaseLock();
        }
        if (serviceInfoMap.isEmpty()) {
            return;
        }
        svcMgr.getServiceInfo(serviceInfoMap);
        iter = serviceInfoMap.entrySet().iterator();
        int counter = 0;
        while (iter.hasNext()) {
            String pingIOR;
            Map.Entry entry = (Map.Entry)iter.next();
            String server = (String)entry.getKey();
            HashSet serviceInfo = (HashSet)entry.getValue();
            if (serviceInfo == null || serviceInfo.size() == 0 || (pingIOR = (String)pingers.get(counter++)) == null) continue;
            try {
                PingerEx pinger = PingerExHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)svcMgr.getORB().string_to_object(pingIOR));
                if (pinger == null) continue;
                pinger.PingEx(serviceInfo.toArray(new String[serviceInfo.size()]));
            }
            catch (Exception e) {
                LOG.warn((Object)("ping(): when pinging, pjs=" + server), (Throwable)e);
            }
        }
    }

    protected boolean isPingerNeeded() {
        return true;
    }

    protected void addServices(IPropertyBag bag, String cluster, String serverName) {
        block5: {
            super.addServices(bag, cluster, serverName);
            String ior = bag.getString(PropertyIDs.SI_SERVER_IOR);
            ORB orb = ServiceMgrFactory.getServiceMgr().getORB();
            QBSet.Query query = new QBSet.Query();
            query.addTerm(SERVER_NAME, (Object)serverName);
            query.addTerm(PropertyIDs.SI_CLUSTER_NAME, (Object)cluster);
            Set services = this.getServices().query(query);
            LinkedList<PropertyBag> factoryServices = new LinkedList<PropertyBag>();
            LinkedList<String> serviceNames = new LinkedList<String>();
            Iterator iterator = services.iterator();
            while (iterator.hasNext() && this.isValidServer(bag)) {
                PropertyBag serviceBag = (PropertyBag)iterator.next();
                String serviceName = serviceBag.getString((Object)PropertyIDs.SI_SERVICE);
                if (!serviceName.endsWith("_Factory_")) continue;
                factoryServices.add(serviceBag);
                serviceNames.add(serviceName);
            }
            try {
                com.crystaldecisions.thirdparty.org.omg.CORBA.Object[] serviceFactories = (com.crystaldecisions.thirdparty.org.omg.CORBA.Object[])ServerHelper.invokeServer(bag, ior, new NewServicesFactoryInvocationHandler(serviceNames.toArray(new String[serviceNames.size()])));
                Iterator iter = factoryServices.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    PropertyBag serviceBag = (PropertyBag)iter.next();
                    com.crystaldecisions.thirdparty.org.omg.CORBA.Object serviceFactory = serviceFactories[i];
                    if (serviceFactory != null) {
                        String serviceFactoryIOR = orb.object_to_string(serviceFactory);
                        serviceBag.setProperty((Object)PropertyIDs.SI_SERVER_IOR, (Object)serviceFactoryIOR);
                    }
                    ++i;
                }
            }
            catch (UserException connection_failure2) {
                if (!LOG.isInfoEnabled()) break block5;
                LOG.info((Object)("(addServices:156) connection failure when get the service factory: ,serverBag=" + bag));
            }
        }
    }

    public String getServerIOR(IPropertyBag server, ServerSpec spec) {
        String serviceName = spec.getServiceName();
        if (serviceName != null && !serviceName.endsWith("_Factory_")) {
            QBSet.Query query = new QBSet.Query();
            query.addTerm(SERVER_NAME, (Object)server.getString(SERVER_NAME));
            query.addTerm(PropertyIDs.SI_CLUSTER_NAME, (Object)server.getString(PropertyIDs.SI_CLUSTER_NAME));
            query.addTerm(PropertyIDs.SI_SERVICE, (Object)(serviceName + "_Factory_"));
            Set result = this.getServices().query(query);
            if (result.size() == 0) {
                return super.getServerIOR(server, spec);
            }
            PropertyBag bag = (PropertyBag)result.iterator().next();
            return bag.getString((Object)PropertyIDs.SI_SERVER_IOR);
        }
        return super.getServerIOR(server, spec);
    }

    private static class NewServicesFactoryInvocationHandler
    implements IInvocationHandler {
        private final String[] m_services;

        public NewServicesFactoryInvocationHandler(String[] services) {
            this.m_services = services;
        }

        public Object invoke(com.crystaldecisions.thirdparty.org.omg.CORBA.Object obj) throws SystemException, UserException {
            OSCAFactory factory = OSCAFactoryHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)obj);
            Object[] descriptors = new String[this.m_services.length];
            Arrays.fill(descriptors, "");
            return factory.newServices(this.m_services, (String[])descriptors);
        }

        public String toString() {
            return "NewServiceFactoryHandler";
        }
    }
}

