/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.digest.Digest;
import com.crystaldecisions.celib.digest.MD5;
import com.crystaldecisions.celib.exception.SILibException;
import com.crystaldecisions.celib.io.PersistentConfiguration;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.APSComparator;
import com.crystaldecisions.enterprise.ocaframework.APSServerHandler;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class PersistedClustersInfo {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.PersistedClustersInfo");
    private static final String ENABLE_PERSIST_CLUSTERS_INFO_SYSTEM_PROP = "com.businessobjects.enterprise.persistclustersinfo";
    private static final String PREFERENCES_NODE_NAME_CLUSTERSINFO = "clusterinfo.1200";
    private static PersistentConfiguration clustersInfo = new PersistentConfiguration("clusterinfo.1200");
    private static boolean s_isPersistClustersInfoEnabled = false;
    private static final int INITIAL_CAPACITY = 5;
    private static Map s_clustersMap = new HashMap(5);

    PersistedClustersInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePersistedClustersInfo(APSServerHandler handler) {
        if (!s_isPersistClustersInfoEnabled) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Start updating persisted cluster info");
        }
        Set servers = handler.queryServer(new ServerSpec("", "aps", ""), false);
        Map newClustersInfoMap = this.buildNewClustersInfoMap(servers);
        PersistedClustersInfo persistedClustersInfo = this;
        synchronized (persistedClustersInfo) {
            if (!this.isSameClustersInfo(s_clustersMap, newClustersInfoMap)) {
                s_clustersMap = newClustersInfoMap;
                PersistedClustersInfo.writePreferences();
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"End updating persisted cluster info");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getPersistedClusterMembers(String name) {
        if (!s_isPersistClustersInfoEnabled) {
            return Collections.EMPTY_SET;
        }
        PersistedClustersInfo persistedClustersInfo = this;
        synchronized (persistedClustersInfo) {
            Iterator iterator = s_clustersMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                HashSet cmsNames = (HashSet)entry.getValue();
                if (name.startsWith("@")) {
                    String clusterName = (String)entry.getKey();
                    if (!name.equalsIgnoreCase(clusterName)) continue;
                    return cmsNames;
                }
                Iterator cmsIter = cmsNames.iterator();
                while (cmsIter.hasNext()) {
                    APSComparator comparator = new APSComparator();
                    String cmsName = (String)cmsIter.next();
                    if (comparator.compare(cmsName, name) != 0) continue;
                    return cmsNames;
                }
            }
        }
        return Collections.EMPTY_SET;
    }

    private static void loadPersistClustersInfoEnabled() {
        String enabled = System.getProperty(ENABLE_PERSIST_CLUSTERS_INFO_SYSTEM_PROP);
        s_isPersistClustersInfoEnabled = enabled == null || !enabled.equalsIgnoreCase("false");
    }

    private Map buildNewClustersInfoMap(Set servers) {
        HashMap newClustersInfoMap = new HashMap(5);
        Iterator iter = servers.iterator();
        while (iter.hasNext()) {
            Property cmsProp;
            PropertyBag bag = (PropertyBag)iter.next();
            Property prop = bag.getItem((Object)PropertyIDs.SI_CLUSTER_NAME);
            if (prop == null) continue;
            String clusterName = (String)prop.getValue();
            if (!newClustersInfoMap.containsKey(clusterName)) {
                newClustersInfoMap.put(clusterName, new HashSet(5));
            }
            if ((cmsProp = bag.getItem((Object)APSServerHandler.APS_NAME)) == null) continue;
            String cmsName = (String)cmsProp.getValue();
            HashSet cmsNamesSet = (HashSet)newClustersInfoMap.get(clusterName);
            cmsNamesSet.add(cmsName);
        }
        return newClustersInfoMap;
    }

    private boolean isSameClustersInfo(Map old, Map updated) {
        if (old.size() != updated.size()) {
            return false;
        }
        Iterator iterator = old.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String clusterName = (String)entry.getKey();
            if (!updated.containsKey(clusterName)) {
                return false;
            }
            HashSet oldCMSNamesSet = (HashSet)entry.getValue();
            HashSet updatedCMSNamesSet = (HashSet)updated.get(clusterName);
            if (oldCMSNamesSet.size() != updatedCMSNamesSet.size()) {
                return false;
            }
            Iterator oldCMSIterator = oldCMSNamesSet.iterator();
            while (oldCMSIterator.hasNext()) {
                String oldCmsName = (String)oldCMSIterator.next();
                if (updatedCMSNamesSet.contains(oldCmsName)) continue;
                return false;
            }
        }
        return true;
    }

    private static void writePreferences() {
        block11: {
            block10: {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Start writing cluster info to preferences");
                }
                try {
                    clustersInfo.refresh();
                }
                catch (SILibException e) {
                    if (!LOG.isInfoEnabled()) break block10;
                    LOG.info((Object)"An error removing cluster info preferences, ingore it and continue writing, so there might have out of date entries");
                }
            }
            Iterator iterator = s_clustersMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String clusterName = (String)entry.getKey();
                HashSet cmsNames = (HashSet)entry.getValue();
                if (cmsNames == null || cmsNames.size() == 0) continue;
                String cmsNamesString = "";
                Iterator cmsNameIter = cmsNames.iterator();
                while (cmsNameIter.hasNext()) {
                    String cmsName = (String)cmsNameIter.next();
                    cmsNamesString = cmsNamesString + cmsName;
                    cmsNamesString = cmsNamesString + ";";
                }
                try {
                    byte[] cmsNamesBytes = cmsNamesString.getBytes("UTF-8");
                    Digest digest = MD5.digest((byte[])cmsNamesBytes, (int)cmsNamesBytes.length);
                    String strDigest = digest.toString();
                    cmsNamesString = cmsNamesString + strDigest;
                    clustersInfo.setProperty(clusterName, cmsNamesString);
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)("Writing cluster info to preferences for cluster " + clusterName));
                }
                catch (Exception e) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)"An error occured while making digest, no write to preferences for the entry");
                }
            }
            try {
                clustersInfo.flush();
            }
            catch (SILibException e) {
                if (!LOG.isInfoEnabled()) break block11;
                LOG.info((Object)"Flush clusterinfo node failed, ignore it and continue, we won't have updated clusterinfo");
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"End writing cluster info to preferences");
        }
    }

    private static void readPreferences() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Start reading from preferences");
        }
        try {
            clustersInfo.refresh();
            s_clustersMap.clear();
            Iterator iterator = clustersInfo.keySet().iterator();
            while (iterator.hasNext()) {
                String clusterName = (String)iterator.next();
                String cmsNamesString = clustersInfo.getProperty(clusterName, null);
                if (cmsNamesString == null || cmsNamesString.trim().length() == 0) continue;
                int lastIndex = cmsNamesString.lastIndexOf(59);
                String oldStrDigest = cmsNamesString.substring(lastIndex + 1);
                byte[] cmsNamesBytes = (cmsNamesString = cmsNamesString.substring(0, lastIndex + 1)).getBytes("UTF-8");
                Digest newDigest = MD5.digest((byte[])cmsNamesBytes, (int)cmsNamesBytes.length);
                String newStrDigest = newDigest.toString();
                if (newStrDigest.equals(oldStrDigest)) {
                    String[] cmsNames = cmsNamesString.split(";");
                    if (cmsNames == null || cmsNames.length <= 0) continue;
                    HashSet<String> cmsNamesSet = new HashSet<String>(cmsNames.length);
                    for (int j = 0; j < cmsNames.length; ++j) {
                        cmsNamesSet.add(cmsNames[j]);
                    }
                    s_clustersMap.put(clusterName, cmsNamesSet);
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)("Read cluster info from preferences for cluster " + clusterName));
                    continue;
                }
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)"Persisted cluster info are corrupted, ignore them");
            }
        }
        catch (Exception e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"An error occured while reading preferences for cluster info, ignore reading from preferences");
            }
            s_clustersMap.clear();
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"End reading from preferences");
        }
    }

    static {
        PersistedClustersInfo.loadPersistClustersInfoEnabled();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Persist clusters info is enabled:" + s_isPersistClustersInfoEnabled));
        }
        if (s_isPersistClustersInfoEnabled) {
            PersistedClustersInfo.readPreferences();
        }
    }
}

