/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.collections.EmptyCollections;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.FrameworkPropertyBag;
import com.crystaldecisions.enterprise.ocaframework.IDirectory;
import com.crystaldecisions.enterprise.ocaframework.IPropertyBag;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoObjectWireIteratorEx3;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoObjectWireIteratorEx3Holder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoStoreEx3;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoStoreEx3Helper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoWireObjects3Holder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.info_wire_ob3;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.thirdparty.org.omg.CORBA.BooleanHolder;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class RawAPSDirectory
implements IDirectory {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.RawAPSDirectory");
    private static final int CLUSTER_INFO_OBJID = 4;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IPropertyBag[] find(ServerSpec spec, String uri, String queryIDsString, int mode) throws OCAFrameworkException {
        block26: {
            block25: {
                svr = spec.getAPS();
                targetSearchName = spec.getName();
                kind = spec.getKind();
                cluster = spec.getCluster();
                stub = null;
                props = null;
                groupMembers = EmptyCollections.SET;
                try {
                    try {
                        if (RawAPSDirectory.LOG.isDebugEnabled()) {
                            RawAPSDirectory.LOG.debug((Object)("Directory.find() - svr = " + svr + " target = " + targetSearchName + " uri = " + uri));
                        }
                        if ((obj = ServiceMgrFactory.getServiceMgr().getUnmanagedService("InfoStore", new ServerSpec(svr, "aps", svr, cluster), "osca:iiop://;BYPASSSEC=true")) == null) {
                            var13_15 = new IPropertyBag[]{};
                            var19_17 = null;
                            if (stub == null) return var13_15;
                            break block25;
                        }
                        stub = InfoStoreEx3Helper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)obj);
                        RawAPSDirectory.LOG.assertNotNull((Object)stub, "stub is null.");
                        if (spec.getGroupMode() != 0) {
                            groupIDs = new ArrayList<Integer>();
                            groupIDs.add(new Integer(spec.getGroup()));
                            groupMembers = new HashSet<E>(this.buildServerGroupInfo(groupIDs, stub, new HashSet<E>()));
                        }
                        condition = new StringBuffer();
                        if ("".equals(kind) || "aps".equals(kind)) {
                            queryIDsString = queryIDsString + ", SI_CLUSTER_NAME";
                            condition.append("(SI_ID=");
                            condition.append(4);
                            condition.append(") OR ");
                        }
                        condition.append("(SI_PARENTID=16");
                        if (!kind.equals("") && !kind.equals("INVALID")) {
                            condition.append(" AND SI_SERVER_KIND = '");
                            condition.append(kind);
                            condition.append("'");
                        }
                        if (!targetSearchName.equals("")) {
                            if (mode == 0) {
                                condition.append(" AND SI_NAME = '");
                                condition.append(targetSearchName);
                                condition.append("'");
                            } else {
                                condition.append(" AND SI_NAME like '");
                                condition.append(targetSearchName);
                                condition.append("'");
                            }
                        }
                        condition.append(')');
                        query = new StringBuffer();
                        query.append("SELECT ");
                        query.append(queryIDsString);
                        query.append(" FROM CI_SYSTEMOBJS WHERE ");
                        query.append(condition.toString());
                        query.append(" ORDER BY SI_NAME ASC");
                        props = this.doQuery(stub, query.toString());
                        if (props == null) throw new OCAFrameworkException.NotFoundInDirectory(targetSearchName, null);
                        if (props.size() == 0) {
                            throw new OCAFrameworkException.NotFoundInDirectory(targetSearchName, null);
                        }
                        if ("".equals(kind) || "aps".equals(kind)) {
                            iter = props.iterator();
                            clusterName = null;
                            while (iter.hasNext()) {
                                bag = (PropertyBag)iter.next();
                                if (bag.getInt((Object)PropertyIDs.SI_ID) != 4) continue;
                                clusterName = bag.getString((Object)PropertyIDs.SI_CLUSTER_NAME);
                                iter.remove();
                                break;
                            }
                            if (clusterName == null) throw new OCAFrameworkException.NotFoundInDirectory(targetSearchName, null);
                            if (props.size() == 0) {
                                throw new OCAFrameworkException.NotFoundInDirectory(targetSearchName, null);
                            }
                            iter = props.iterator();
                            while (iter.hasNext()) {
                                bag = (PropertyBag)iter.next();
                                bag.setProperty((Object)PropertyIDs.SI_CLUSTER_NAME, (Object)('@' + clusterName));
                            }
                        }
                        itr = props.iterator();
                        while (itr.hasNext()) {
                            bag = (PropertyBag)itr.next();
                            name = bag.getString((Object)PropertyIDs.SI_NAME);
                            if (groupMembers.contains(name)) {
                                bag.setProperty((Object)PropertyIDs.GROUP_ID, spec.getGroup());
                                continue;
                            }
                            bag.setProperty((Object)PropertyIDs.GROUP_ID, 0);
                        }
                        var16_25 = props.toArray(new IPropertyBag[props.size()]);
                        break block26;
                    }
                    catch (oca_abuse abuse) {
                        RawAPSDirectory.LOG.warn((Object)"find(): server error", (Throwable)abuse);
                        throw new OCAFrameworkException.ServerError(svr, (Exception)abuse);
                    }
                    catch (SystemException e) {
                        RawAPSDirectory.LOG.warn((Object)"find(): communication error", (Throwable)e);
                        throw new OCAFrameworkException.CommunicationError(svr, e);
                    }
                }
                catch (Throwable var18_27) {
                    var19_19 = null;
                    if (stub == null) throw var18_27;
                    try {
                        stub.free();
                        throw var18_27;
                    }
                    catch (SystemException e) {
                        RawAPSDirectory.LOG.warn((Object)"find(): failed to release resource", (Throwable)e);
                        throw var18_27;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [7 : 857->867)] { 
lbl122:
            // 1 sources

            stub.free();
            return var13_15;
lbl124:
            // 1 sources

            catch (SystemException e) {
                RawAPSDirectory.LOG.warn((Object)"find(): failed to release resource", (Throwable)e);
            }
            return var13_15;
        }
        var19_18 = null;
        if (stub == null) return var16_25;
        try {}
        catch (SystemException e) {
            RawAPSDirectory.LOG.warn((Object)"find(): failed to release resource", (Throwable)e);
            return var16_25;
        }
        stub.free();
        return var16_25;
    }

    private Collection buildServerGroupInfo(Collection groups, InfoStoreEx3 stub, Collection history) throws oca_abuse, OCAFrameworkException.ServerGroupNotFound {
        ArrayList memberList = new ArrayList();
        StringBuffer idsBuf = new StringBuffer();
        Iterator iterator = groups.iterator();
        while (iterator.hasNext()) {
            Integer id = (Integer)iterator.next();
            if (history.contains(id)) continue;
            idsBuf.append(id);
            idsBuf.append(',');
            history.add(id);
        }
        if (idsBuf.length() > 0) {
            String queryIDs = idsBuf.substring(0, idsBuf.length() - 1);
            StringBuffer groupQuery = new StringBuffer("SELECT SI_GROUP_MEMBERS, SI_SUBGROUPS FROM CI_SYSTEMOBJECTS WHERE SI_OBTYPE = 17 AND SI_ID in (");
            groupQuery.append(queryIDs);
            groupQuery.append(')');
            List groupProps = this.doQuery(stub, groupQuery.toString());
            if (groupProps == null || groupProps.size() == 0) {
                throw new OCAFrameworkException.ServerGroupNotFound(queryIDs, "", null);
            }
            ArrayList subGroups = new ArrayList();
            Iterator iterator2 = groupProps.iterator();
            while (iterator2.hasNext()) {
                PropertyBag serverGroupInfo = (PropertyBag)iterator2.next();
                PropertyBag membersInfo = serverGroupInfo.getPropertyBag((Object)PropertyIDs.SI_GROUP_MEMBERS);
                PropertyBag subGroupsInfo = serverGroupInfo.getPropertyBag((Object)PropertyIDs.SI_SUBGROUPS);
                if (membersInfo != null) {
                    PropertyArrayHelper groupMembersList = new PropertyArrayHelper(membersInfo, PropertyIDs.SI_TOTAL);
                    memberList.addAll(groupMembersList);
                }
                if (subGroupsInfo == null) continue;
                PropertyArrayHelper subGroupMembersList = new PropertyArrayHelper(subGroupsInfo, PropertyIDs.SI_TOTAL);
                subGroups.addAll(subGroupMembersList);
            }
            if (subGroups.size() != 0) {
                memberList.addAll(this.buildServerGroupInfo(subGroups, stub, history));
            }
        }
        return memberList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List doQuery(InfoStoreEx3 stub, String query) throws oca_abuse {
        InfoWireObjects3Holder out = new InfoWireObjects3Holder();
        InfoObjectWireIteratorEx3Holder itrHolder = new InfoObjectWireIteratorEx3Holder();
        ArrayList result = null;
        try {
            stub.queryEx3(1200, 0, query.toString(), out, itrHolder);
            if (out.value.length != 0) {
                InfoObjectWireIteratorEx3 itr = itrHolder.value;
                result = new ArrayList();
                WireOb3Unpacker clsUnpacker = new WireOb3Unpacker();
                this.unpackToBag(out.value, clsUnpacker, result);
                if (itr != null) {
                    BooleanHolder moreData = new BooleanHolder();
                    do {
                        itr.getNextBatchEx3(1200, out, moreData);
                        this.unpackToBag(out.value, clsUnpacker, result);
                    } while (moreData.value);
                }
            }
            Object var10_9 = null;
            if (itrHolder.value == null) return result;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (itrHolder.value == null) throw throwable;
            itrHolder.value.free();
            throw throwable;
        }
        itrHolder.value.free();
        return result;
    }

    private void unpackToBag(info_wire_ob3[] objects, IBagUnpacker unpacker, List props) {
        for (int i = 0; i < objects.length; ++i) {
            info_wire_ob3 obj = objects[i];
            if (obj.uid == 0) continue;
            FrameworkPropertyBag newBag = new FrameworkPropertyBag();
            unpacker.initialize((Object)objects[i].propBag);
            newBag.unpack(unpacker);
            newBag.setProperty(PropertyIDs.SI_NAME, objects[i].name);
            newBag.setProperty(PropertyIDs.SI_ID, new Integer(objects[i].uid));
            props.add(newBag);
        }
    }
}

