/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.classloader.ClassLoaderHelper;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.OCIParameters;
import com.crystaldecisions.enterprise.ocaframework.SSLTrustDecider;
import com.crystaldecisions.thirdparty.com.ooc.FSSL.Certificate;
import com.crystaldecisions.thirdparty.com.ooc.FSSL.FSSL;
import com.crystaldecisions.thirdparty.com.ooc.FSSL.FSSLImpl;
import com.crystaldecisions.thirdparty.com.ooc.FSSL.Manager;
import com.crystaldecisions.thirdparty.com.ooc.FSSL.TrustDecider;
import com.crystaldecisions.thirdparty.org.omg.CORBA.BAD_PARAM;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORB;
import java.util.Properties;
import java.util.StringTokenizer;

class SSLConfig {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.SSLConfig");
    public static final String FSSL_PROVIDER = "businessobjects.enterprise.FSSLProvider";

    SSLConfig() {
    }

    public void initializeSSL(ORB orb, OCIParameters ociParams, String[] args) throws Exception {
        LOG.assertNotNull((Object)orb, "m_orb is null.");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Initializing FSSL");
        }
        FSSLImpl fssl = null;
        String provider = System.getProperty(FSSL_PROVIDER, "com.crystaldecisions.thirdparty.com.ooc.FSSL.rsa.FSSLImpl");
        try {
            Class clazz = ClassLoaderHelper.loadClass((String)provider);
            fssl = (FSSLImpl)clazz.newInstance();
        }
        catch (Exception e) {
            LOG.warn((Object)("Can't load security provider:" + provider), (Throwable)e);
            throw e;
        }
        Manager fsslManager = FSSL.init((ORB)orb, (String[])args, (FSSLImpl)fssl, (Properties)ociParams.getSystemProperties());
        SSLParameters sslParams = new SSLParameters(ociParams);
        Certificate[] rootCAs = sslParams.getTrustedCertificates(fsslManager);
        Certificate[] chain = sslParams.getCertificateChain(fsslManager);
        byte[] privateKey = sslParams.getServerPrivateKey();
        byte[] passphrase = sslParams.getPassPhrase();
        int id = fsslManager.create_context(chain, privateKey, passphrase, (TrustDecider)new SSLTrustDecider(false, rootCAs), FSSL.get_RSA_ciphers());
        fsslManager.set_context(id);
        if (ociParams.isSSLServer()) {
            FSSL.create_poa_manager((String)"RootPOAManager", (ORB)orb, (Manager)fsslManager, (int)id, (boolean)ociParams.isIIOPServer(), (Properties)ociParams.getSystemProperties());
        }
    }

    class SSLParameters {
        private OCIParameters m_parameters;
        private String m_certPath;
        private Certificate[] m_certChain = null;
        private Certificate[] m_rootCerts = null;
        private byte[] m_serverPrivateKey = null;
        private byte[] m_passphrase = null;

        public SSLParameters(OCIParameters parameters) {
            this.m_parameters = parameters;
            this.m_certPath = parameters.getCertDir();
        }

        Certificate[] getCertificateChain(Manager fsslManager) throws OCAFrameworkException {
            if (this.m_certChain == null) {
                this.m_certChain = this.getCertificates(fsslManager, this.m_parameters.getMyCertificate());
            }
            return this.m_certChain;
        }

        Certificate[] getTrustedCertificates(Manager fsslManager) throws OCAFrameworkException {
            if (this.m_rootCerts == null) {
                this.m_rootCerts = this.getCertificates(fsslManager, this.m_parameters.getTrustedCertificate());
            }
            return this.m_rootCerts;
        }

        private Certificate[] getCertificates(Manager fsslManager, String certificatesPath) throws OCAFrameworkException {
            StringTokenizer tokenizer = new StringTokenizer(certificatesPath, ";");
            int chainLen = tokenizer.countTokens();
            if (chainLen > 0) {
                Certificate[] certs = new Certificate[chainLen];
                int i = 0;
                while (tokenizer.hasMoreElements()) {
                    String filename = this.m_certPath + tokenizer.nextToken();
                    try {
                        certs[i++] = fsslManager.create_certificate(FSSL.load_file((String)filename));
                    }
                    catch (BAD_PARAM bad_param) {
                        throw new OCAFrameworkException.SSLFileOpenError(filename, (Exception)((Object)bad_param));
                    }
                }
                return certs;
            }
            throw new OCAFrameworkException.SSLMissingArgument(certificatesPath);
        }

        byte[] getServerPrivateKey() throws OCAFrameworkException {
            if (this.m_serverPrivateKey == null) {
                String key = this.m_parameters.getMyKey();
                if (key != null) {
                    String filename = this.m_certPath + key;
                    try {
                        this.m_serverPrivateKey = FSSL.load_file((String)filename);
                    }
                    catch (BAD_PARAM bad_param) {
                        throw new OCAFrameworkException.SSLFileOpenError(filename, (Exception)((Object)bad_param));
                    }
                } else {
                    throw new OCAFrameworkException.SSLMissingArgument(key);
                }
            }
            return this.m_serverPrivateKey;
        }

        byte[] getPassPhrase() throws OCAFrameworkException {
            if (this.m_passphrase == null) {
                String filename = this.m_parameters.getMyKeyPassphrase();
                if (filename != null) {
                    filename = this.m_certPath + filename;
                    try {
                        this.m_passphrase = FSSL.load_file_trim((String)filename);
                    }
                    catch (BAD_PARAM bad_param) {
                        throw new OCAFrameworkException.SSLFileOpenError(filename, (Exception)((Object)bad_param));
                    }
                } else {
                    throw new OCAFrameworkException.SSLMissingArgument(filename);
                }
            }
            return this.m_passphrase;
        }
    }
}

