/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.classloader.ClassLoaderHelper;
import com.crystaldecisions.enterprise.ocaframework.APSServerHandler;
import com.crystaldecisions.enterprise.ocaframework.AbstractServerHandler;
import com.crystaldecisions.enterprise.ocaframework.IDirectory;
import com.crystaldecisions.enterprise.ocaframework.IPropertyBag;
import com.crystaldecisions.enterprise.ocaframework.IServerHandler;
import com.crystaldecisions.enterprise.ocaframework.IServerHandlerFactory;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgr;
import com.crystaldecisions.enterprise.ocaframework.idl.PingerEx;
import com.crystaldecisions.enterprise.ocaframework.idl.PingerExHelper;
import com.crystaldecisions.sdk.occa.filerepository.internal.FRSHandler;
import com.crystaldecisions.sdk.occa.filerepository.internal.FRSHandlerFactory;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;

class ServerController {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.ServerController");
    static final Integer SERVER_NAME = PropertyIDs.define("SERVER_NAME");
    static final Integer SERVER_VALID = PropertyIDs.define("SERVER_VALID");
    static final Integer VALID = new Integer(0);
    static final Integer INVALID = new Integer(1);
    static final Integer INVALID_FAILED = new Integer(2);
    private Map m_handlersByClassLoader = new WeakHashMap(1);
    private APSServerHandler m_apsHandler = new APSServerHandler();
    private FRSHandler m_frsHandler;
    private IServerHandler m_defaultServerHandler = new AbstractServerHandler(){};
    private ServiceMgr m_mgr;
    private IDirectory m_directory;
    private static final String FRS_PING_ENABLED = "com.businessobjects.enterprise.frsping";
    private boolean m_frs_ping_enabled;
    private static boolean s_sessLogging = false;

    ServerController(ServiceMgr mgr) {
        String sFrsPing = System.getProperties().getProperty(FRS_PING_ENABLED);
        this.m_frs_ping_enabled = sFrsPing != null && sFrsPing.equalsIgnoreCase("TRUE");
        this.m_mgr = mgr;
    }

    void setDirectory(IDirectory directory) {
        this.m_directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateServer(ServerSpec spec, String uri) {
        IServerHandler handler = this.getServerHandler(spec.getKind());
        this.m_mgr.lockModify();
        try {
            handler.invalidateServer(spec);
        }
        finally {
            this.m_mgr.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getOSCAFactoryIOR(ServerSpec spec, String uri) throws OCAFrameworkException {
        String kind = spec.getKind();
        String aps = spec.getAPS();
        String cluster = spec.getCluster();
        boolean upgraded = false;
        this.m_mgr.lock();
        try {
            if (cluster.equals("")) {
                ServerSpec apsSpec = new ServerSpec(aps, "aps", aps);
                Set apsInfo = this.m_apsHandler.queryServer(apsSpec, false);
                if (apsInfo.size() == 0) {
                    this.m_mgr.releaseLock();
                    this.m_mgr.lockModify();
                    upgraded = true;
                    apsInfo = this.m_apsHandler.queryServer(apsSpec, false);
                    if (apsInfo.size() == 0) {
                        this.m_apsHandler.buildServerInfo(apsSpec, uri, this.m_directory);
                        apsInfo = this.m_apsHandler.queryServer(apsSpec, false);
                    }
                }
                if (apsInfo.size() == 0) {
                    LOG.warn((Object)("(getOSCAFactoryIOR:173): not found server " + aps));
                    throw new OCAFrameworkException.NotFoundInDirectory(aps, null);
                }
                IPropertyBag apsBag = (IPropertyBag)apsInfo.iterator().next();
                this.m_apsHandler.fillServerSpec(apsBag, spec);
            } else if (aps.equals("")) {
                Set apsSet = this.m_apsHandler.queryCluster(spec, false);
                if (apsSet.size() == 0) {
                    throw new OCAFrameworkException.ServiceConnection("", spec.getName(), aps, uri);
                }
                IPropertyBag server = this.m_apsHandler.selectServer(apsSet);
                this.m_apsHandler.fillServerSpec(server, spec);
            }
            IServerHandler handler = this.getServerHandler(kind);
            LOG.assertTrue(!aps.equals("") || !cluster.equals(""), "getOSCAFactoryIOR(): both aps and cluster must be specified at this point");
            Set svrResults = handler.queryServer(spec, false);
            if (svrResults.size() == 0) {
                if (!upgraded) {
                    this.m_mgr.releaseLock();
                    this.m_mgr.lockModify();
                    upgraded = true;
                    svrResults = handler.queryServer(spec, false);
                }
                if (svrResults.size() == 0) {
                    handler.buildServerInfo(spec, uri, this.m_directory);
                    svrResults = handler.queryServer(spec, false);
                }
            }
            if (svrResults.size() == 0 && spec.getGroupMode() == 1) {
                ServerSpec noGroupSpec = new ServerSpec(spec);
                noGroupSpec.setGroupMode(0);
                svrResults = handler.queryServer(noGroupSpec, false);
            }
            if (svrResults.size() == 0) {
                LOG.warn((Object)("getOSCAFactoryIOR(): IOR not found, spec=" + spec));
                throw new OCAFrameworkException.NotFoundInDirectory(spec.getName(), null);
            }
            IPropertyBag server = handler.selectServer(svrResults);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getOSCAFactoryIOR(): pick " + server));
            }
            handler.fillServerSpec(server, spec);
            String string = handler.getServerIOR(server, spec);
            return string;
        }
        finally {
            this.m_mgr.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getOSCAFactoryIORInfo(ServerSpec spec, String uri) throws OCAFrameworkException {
        String kind = spec.getKind();
        String aps = spec.getAPS();
        String cluster = spec.getCluster();
        boolean upgraded = false;
        this.m_mgr.lock();
        try {
            if (cluster.equals("")) {
                ServerSpec apsSpec = new ServerSpec(aps, "aps", aps);
                Set apsInfo = this.m_apsHandler.queryServer(apsSpec, false);
                if (apsInfo.size() == 0) {
                    this.m_mgr.releaseLock();
                    this.m_mgr.lockModify();
                    upgraded = true;
                    apsInfo = this.m_apsHandler.queryServer(apsSpec, false);
                    if (apsInfo.size() == 0) {
                        this.m_apsHandler.buildServerInfo(apsSpec, uri, this.m_directory);
                        apsInfo = this.m_apsHandler.queryServer(apsSpec, false);
                    }
                }
                IPropertyBag apsBag = (IPropertyBag)apsInfo.iterator().next();
                this.m_apsHandler.fillServerSpec(apsBag, spec);
            } else if (aps.equals("")) {
                Set apsSet = this.m_apsHandler.queryCluster(spec, false);
                if (apsSet.size() == 0) {
                    throw new OCAFrameworkException.ServiceConnection("", spec.getName(), aps, uri);
                }
                IPropertyBag server = this.m_apsHandler.selectServer(apsSet);
                this.m_apsHandler.fillServerSpec(server, spec);
            }
            IServerHandler handler = this.getServerHandler(kind);
            LOG.assertTrue(!aps.equals("") || !cluster.equals(""), "getOSCAFactoryIOR(): both aps and cluster must be specified at this point");
            Set svrResults = handler.queryServer(spec, false);
            if (svrResults.size() == 0) {
                if (!upgraded) {
                    this.m_mgr.releaseLock();
                    this.m_mgr.lockModify();
                    upgraded = true;
                    svrResults = handler.queryServer(spec, false);
                }
                if (svrResults.size() == 0) {
                    handler.buildServerInfo(spec, uri, this.m_directory);
                    svrResults = handler.queryServer(spec, false);
                }
            }
            if (svrResults.size() == 0 && spec.getGroupMode() == 1) {
                ServerSpec noGroupSpec = new ServerSpec(spec);
                noGroupSpec.setGroupMode(0);
                svrResults = handler.queryServer(noGroupSpec, false);
            }
            if (svrResults.size() == 0) {
                LOG.warn((Object)("getOSCAFactoryIOR(): IOR not found, spec=" + spec));
                throw new OCAFrameworkException.NotFoundInDirectory(spec.getName(), null);
            }
            Set set = svrResults;
            return set;
        }
        finally {
            this.m_mgr.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String validateServer(ServerSpec spec, String uri) throws OCAFrameworkException {
        IPropertyBag serverInfo;
        Object querySpec;
        Iterator iter;
        Set svrResults;
        IServerHandler handler = this.getServerHandler(spec.getKind());
        this.m_mgr.lock();
        try {
            svrResults = handler.queryServer(spec, true);
            if (svrResults.size() == 0 && spec.isReplaceable() && (svrResults = handler.queryCluster(spec, true)).size() == 0) {
                iter = handler.serversIterator(spec, uri, this.m_directory);
                while (iter.hasNext() && svrResults.size() == 0) {
                    querySpec = (ServerSpec)iter.next();
                    svrResults = handler.queryCluster((ServerSpec)querySpec, true);
                }
            }
            if (svrResults.size() != 0) {
                serverInfo = handler.selectServer(svrResults);
                querySpec = serverInfo.getString(SERVER_NAME);
                return querySpec;
            }
        }
        finally {
            this.m_mgr.releaseLock();
        }
        this.m_mgr.lockModify();
        try {
            svrResults = handler.queryServer(spec, true);
            if (svrResults.size() == 0) {
                if (spec.isReplaceable()) {
                    svrResults = handler.queryCluster(spec, true);
                }
                if (svrResults.size() == 0) {
                    try {
                        handler.buildClusterInfo(spec, uri, this.m_directory);
                    }
                    catch (OCAFrameworkException e) {
                        LOG.warn((Object)("validateServer(): exception caugh when building cluster info for spec=" + spec), (Throwable)((Object)e));
                    }
                    if (spec.isReplaceable()) {
                        Set apsInfo;
                        if (spec.getKind().equals("aps") && spec.getCluster().equalsIgnoreCase("") && (apsInfo = handler.queryServer(spec, true)).size() != 0) {
                            handler.fillServerSpec((IPropertyBag)apsInfo.iterator().next(), spec);
                        }
                        if ((svrResults = this.queryPreferredServer(spec, handler)).size() == 0 && (svrResults = handler.queryCluster(spec, true)).size() == 0) {
                            iter = handler.serversIterator(spec, uri, this.m_directory);
                            while (iter.hasNext() && svrResults.size() == 0) {
                                querySpec = (ServerSpec)iter.next();
                                svrResults = handler.queryCluster((ServerSpec)querySpec, true);
                                if (svrResults.size() != 0) continue;
                                try {
                                    handler.buildClusterInfo((ServerSpec)querySpec, uri, this.m_directory);
                                    svrResults = this.queryPreferredServer((ServerSpec)querySpec, handler);
                                    if (svrResults.size() != 0) continue;
                                    svrResults = handler.queryCluster((ServerSpec)querySpec, true);
                                }
                                catch (OCAFrameworkException e) {
                                    LOG.warn((Object)("validateServer(): exception caught when validating " + spec + ",querySpec=" + querySpec), (Throwable)((Object)e));
                                }
                                catch (SystemException e) {
                                    LOG.warn((Object)("validateServer(): exception caught when validating " + spec + ",querySpec=" + querySpec), (Throwable)e);
                                }
                            }
                        }
                    } else {
                        svrResults = handler.queryServer(spec, true);
                    }
                }
                if (svrResults.size() == 0) {
                    String kind = spec.getKind();
                    if ("aps".equals(kind)) {
                        kind = "cms";
                    }
                    throw new OCAFrameworkException.AllServicesDown(spec.getAPS(), spec.getCluster(), kind, spec.getCriteria(), null);
                }
            }
            serverInfo = handler.selectServer(svrResults);
            handler.fillServerSpec(serverInfo, spec);
            String string = serverInfo.getString(SERVER_NAME);
            return string;
        }
        finally {
            this.m_mgr.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushServer(ServerSpec spec) {
        IServerHandler handler = this.getServerHandler(spec.getKind());
        this.m_mgr.lockModify();
        try {
            handler.clearServerInfo(spec);
        }
        finally {
            this.m_mgr.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isServerValid(ServerSpec spec) {
        IServerHandler handler = this.getServerHandler(spec.getKind());
        this.m_mgr.lock();
        try {
            Set servers = handler.queryServer(spec, true);
            boolean bl = servers.size() != 0;
            return bl;
        }
        finally {
            this.m_mgr.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isServerFailed(ServerSpec spec) {
        IServerHandler handler = this.getServerHandler(spec.getKind());
        this.m_mgr.lock();
        try {
            Set servers = handler.queryServer(spec, false);
            Iterator iterator = servers.iterator();
            while (iterator.hasNext()) {
                IPropertyBag bag = (IPropertyBag)iterator.next();
                if (bag.getInt(SERVER_VALID) != INVALID_FAILED.intValue()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.m_mgr.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void manageCache(boolean bRefreshCluster) {
        Iterator handlers = this.getAllHandlers();
        this.m_mgr.lockModify();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"manageCache(): invalidating servers");
            }
            while (handlers.hasNext()) {
                IServerHandler handler = (IServerHandler)handlers.next();
                try {
                    handler.manageCache();
                }
                catch (Throwable t) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)"manageCache(): unknown exception", t);
                }
            }
            if (bRefreshCluster) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"ServerController.manageCache(): refresh cluster info");
                }
                this.m_apsHandler.refreshClusterInfo(this.m_directory);
            }
        }
        finally {
            this.m_mgr.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getServerCount(ServerSpec spec, boolean validOnly) {
        IServerHandler handler = this.getServerHandler(spec.getKind());
        this.m_mgr.lock();
        try {
            Set servers = handler.queryServer(spec, validOnly);
            int n = servers.size();
            return n;
        }
        finally {
            this.m_mgr.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redirectServer(ServerSpec spec, String uri) throws OCAFrameworkException {
        block27: {
            ServerSpec copy = new ServerSpec(spec);
            String kind = copy.getKind();
            String aps = copy.getAPS();
            String cluster = copy.getCluster();
            boolean upgraded = false;
            this.m_mgr.lock();
            try {
                Set servers;
                IServerHandler handler;
                IPropertyBag server;
                block26: {
                    if (cluster.equals("")) {
                        ServerSpec apsSpec = new ServerSpec(aps, "aps", aps);
                        Set apsInfo = this.m_apsHandler.queryServer(apsSpec, false);
                        if (apsInfo.size() == 0) {
                            this.m_mgr.releaseLock();
                            this.m_mgr.lockModify();
                            upgraded = true;
                            apsInfo = this.m_apsHandler.queryServer(apsSpec, false);
                            if (apsInfo.size() == 0) {
                                this.m_apsHandler.buildServerInfo(apsSpec, uri, this.m_directory);
                                apsInfo = this.m_apsHandler.queryServer(apsSpec, false);
                                if (apsInfo.size() == 0) {
                                    throw new OCAFrameworkException.AllServicesDown(aps, cluster, "cms", apsSpec.getCriteria(), null);
                                }
                            }
                        }
                        server = (IPropertyBag)apsInfo.iterator().next();
                        this.m_apsHandler.fillServerSpec(server, copy);
                        spec.setCluster(copy.getCluster());
                    } else if (aps.equals("")) {
                        Set apsSet = this.m_apsHandler.queryCluster(spec, false);
                        if (apsSet.size() == 0) {
                            this.m_mgr.releaseLock();
                            this.m_mgr.lockModify();
                            upgraded = true;
                            apsSet = this.m_apsHandler.queryCluster(spec, false);
                            if (apsSet.size() == 0) {
                                this.m_apsHandler.buildClusterInfo(spec, uri, this.m_directory);
                                apsSet = this.m_apsHandler.queryCluster(spec, false);
                                if (apsSet.size() == 0) {
                                    throw new OCAFrameworkException.ServiceConnection("", spec.getName(), aps, uri);
                                }
                            }
                        }
                        IPropertyBag server2 = this.m_apsHandler.selectServer(apsSet);
                        this.m_apsHandler.fillServerSpec(server2, spec);
                    }
                    handler = this.getServerHandler(kind);
                    LOG.assertNotNull((Object)handler, "handler is null.");
                    servers = this.queryPreferredServer(copy, handler);
                    if (servers.size() == 0 && (servers = handler.queryCluster(copy, true)).size() == 0) {
                        if (!upgraded) {
                            this.m_mgr.releaseLock();
                            this.m_mgr.lockModify();
                            servers = handler.queryCluster(copy, true);
                        }
                        if (servers.size() == 0) {
                            try {
                                handler.buildClusterInfo(copy, uri, this.m_directory);
                                servers = this.queryPreferredServer(copy, handler);
                                if (servers.size() == 0) {
                                    servers = handler.queryCluster(copy, true);
                                }
                            }
                            catch (OCAFrameworkException e) {
                                Iterator iter = this.m_apsHandler.serversIterator(copy, uri, this.m_directory);
                                while (iter.hasNext()) {
                                    ServerSpec apsSpec = (ServerSpec)iter.next();
                                    if (apsSpec.getName().equalsIgnoreCase(copy.getAPS())) continue;
                                    ServerSpec querySpec = new ServerSpec(copy);
                                    querySpec.setAPS(apsSpec.getName());
                                    try {
                                        handler.buildClusterInfo(querySpec, uri, this.m_directory);
                                        break;
                                    }
                                    catch (OCAFrameworkException e1) {
                                        LOG.warn((Object)("redirectServer(): exception caught when validating " + querySpec + ",querySpec=" + querySpec), (Throwable)((Object)e));
                                    }
                                    catch (SystemException e1) {
                                        LOG.warn((Object)("redirectServer(): exception caught when validating " + querySpec + ",querySpec=" + querySpec), (Throwable)((Object)e));
                                    }
                                }
                                if ((servers = this.queryPreferredServer(copy, handler)).size() == 0) {
                                    servers = handler.queryCluster(copy, true);
                                }
                                if (servers.size() != 0) break block26;
                                LOG.warn((Object)"redirectServer(): failed to build cluster info", (Throwable)((Object)e));
                                throw e;
                            }
                        }
                    }
                }
                if (servers.size() == 0 && copy.getGroupMode() == 1) {
                    copy.setGroupMode(0);
                    servers = this.queryPreferredServer(copy, handler);
                    if (servers.size() == 0) {
                        servers = handler.queryCluster(copy, true);
                    }
                }
                if (servers.size() != 0) {
                    server = handler.selectServer(servers);
                    handler.fillServerSpec(server, spec);
                    break block27;
                }
                throw new OCAFrameworkException.AllServicesDown(aps, cluster, kind, copy.getServiceName(), null);
            }
            finally {
                this.m_mgr.releaseLock();
            }
        }
    }

    Set queryPreferredServer(ServerSpec copy, IServerHandler handler) {
        if (copy.isPreferred() && !"".equals(copy.getName())) {
            return handler.queryServer(copy, true);
        }
        return Collections.EMPTY_SET;
    }

    Set getAPSCache() {
        return this.m_apsHandler.getServers().bags();
    }

    void bootstrapAPS(String aps) throws OCAFrameworkException {
        this.m_apsHandler.buildBootstrapAPSInfo(aps);
    }

    void buildAPSInfo(ServerSpec spec, String uri) throws OCAFrameworkException {
        this.m_apsHandler.buildServerInfo(spec, uri, this.m_directory);
    }

    void setBootstrapDirectory(IDirectory directory) {
        this.m_apsHandler.setBootstrapDirectory(directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void merge(Set servers) {
        this.m_mgr.lock();
        try {
            if (this.m_apsHandler.needsMerge(servers)) {
                this.m_mgr.releaseLock();
                this.m_mgr.lockModify();
                this.m_apsHandler.merge(servers);
            }
        }
        finally {
            this.m_mgr.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map ping(String aps, String[] sessionIDs) {
        boolean retry;
        Set frsPingiors;
        String pingior;
        HashMap<String, String> failoverMap;
        block23: {
            if (aps == null || sessionIDs == null) {
                return null;
            }
            failoverMap = null;
            pingior = null;
            frsPingiors = null;
            this.m_mgr.lock();
            try {
                pingior = this.m_apsHandler.getPingerIOR(aps);
                if (this.m_frs_ping_enabled) {
                    frsPingiors = this.m_frsHandler.getPingerIORs(aps);
                }
            }
            finally {
                this.m_mgr.releaseLock();
            }
            retry = true;
            if (pingior != null) {
                try {
                    PingerEx pinger = PingerExHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)this.m_mgr.getORB().string_to_object(pingior));
                    if (pinger != null) {
                        if (s_sessLogging) {
                            String allids = "";
                            for (int i = 0; i < sessionIDs.length; ++i) {
                                allids = allids + sessionIDs[i];
                                allids = allids + " ";
                            }
                            LOG.error((Object)("ping sessions: aps=" + aps + " allids=" + allids));
                        }
                        pinger.PingEx(sessionIDs);
                        retry = false;
                    }
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block23;
                    LOG.warn((Object)("ping(): when pinging, aps=" + aps), (Throwable)e);
                }
            }
        }
        if (retry) {
            Map pingerIORs = this.m_apsHandler.getActivePingerIORs(aps);
            Iterator iorIter = pingerIORs.entrySet().iterator();
            while (iorIter.hasNext()) {
                PingerEx activePinger;
                Map.Entry entry = iorIter.next();
                String failoverCMS = (String)entry.getKey();
                String activePingerIOR = (String)entry.getValue();
                if (activePingerIOR.equals(pingior) || (activePinger = PingerExHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)this.m_mgr.getORB().string_to_object(activePingerIOR))) == null) continue;
                if (s_sessLogging) {
                    String allids = "";
                    for (int i = 0; i < sessionIDs.length; ++i) {
                        allids = allids + sessionIDs[i];
                        allids = allids + " ";
                    }
                    LOG.error((Object)("ping failover:  allids=" + allids));
                }
                try {
                    activePinger.PingEx(sessionIDs);
                    if (failoverCMS.equalsIgnoreCase(aps) || (failoverMap = new HashMap<String, String>(sessionIDs.length)) == null) break;
                    for (int i = 0; i < sessionIDs.length; ++i) {
                        failoverMap.put(sessionIDs[i], failoverCMS);
                    }
                    break;
                }
                catch (Exception ec) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)"Ping failover failed, continue try the next available pinger");
                }
            }
        }
        if (this.m_frs_ping_enabled) {
            Iterator iter = frsPingiors.iterator();
            while (iter.hasNext()) {
                try {
                    String frsPingiorStr = (String)iter.next();
                    PingerEx pinger = PingerExHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)this.m_mgr.getORB().string_to_object(frsPingiorStr));
                    if (pinger == null) continue;
                    pinger.PingEx(sessionIDs);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)("ping(): when pinging, frs of aps=" + aps), (Throwable)e);
                }
            }
        }
        return failoverMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getClusterMembers(ServerSpec spec, boolean alive) {
        this.m_mgr.lock();
        try {
            APSServerHandler apsHandler = this.m_apsHandler;
            Set members = apsHandler.queryCluster(spec, alive);
            HashSet<String> result = new HashSet<String>(members.size());
            Iterator iterator = members.iterator();
            while (iterator.hasNext()) {
                IPropertyBag bag = (IPropertyBag)iterator.next();
                result.add(bag.getString(SERVER_NAME));
            }
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        finally {
            this.m_mgr.releaseLock();
        }
    }

    private synchronized IServerHandler getServerHandler(String kind) {
        IServerHandler handler;
        HashMap<String, IServerHandler> handlers = (HashMap<String, IServerHandler>)this.m_handlersByClassLoader.get(Thread.currentThread().getContextClassLoader());
        if (handlers == null) {
            handlers = new HashMap<String, IServerHandler>();
            handlers.put("aps", this.m_apsHandler);
            handlers.put("", this.m_defaultServerHandler);
            if (this.m_frs_ping_enabled) {
                this.m_frsHandler = (FRSHandler)((FRSHandlerFactory)FRSHandlerFactory.getFactory()).makeHandler();
                handlers.put("fileserver", this.m_frsHandler);
            }
            this.m_handlersByClassLoader.put(Thread.currentThread().getContextClassLoader(), handlers);
        }
        if ((handler = (IServerHandler)handlers.get(kind)) == null) {
            try {
                String propFileName = "META-INF/CrystalEnterprise.Servers/" + kind + ".properties";
                InputStream propertyStream = ClassLoaderHelper.getResourceAsStream((String)propFileName);
                if (propertyStream != null) {
                    Properties infoProperties = new Properties();
                    infoProperties.load(propertyStream);
                    propertyStream.close();
                    IServerHandlerFactory factory = null;
                    String factoryName = infoProperties.getProperty("factory");
                    if (factoryName != null) {
                        Class clazz = ClassLoaderHelper.loadClass((String)factoryName);
                        Method method = null;
                        method = clazz.getMethod("getFactory", null);
                        factory = (IServerHandlerFactory)method.invoke(null, null);
                        handler = factory.makeHandler();
                    } else {
                        handler = this.m_defaultServerHandler;
                    }
                } else {
                    handler = this.m_defaultServerHandler;
                }
            }
            catch (Exception e) {
                handler = this.m_defaultServerHandler;
            }
            handlers.put(kind, handler);
        }
        return handler;
    }

    public void pingServers() {
        Iterator handlersIter = this.getAllHandlers();
        while (handlersIter.hasNext()) {
            IServerHandler handler = (IServerHandler)handlersIter.next();
            handler.pingServers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator getAllHandlers() {
        LinkedList allHhandlers = new LinkedList();
        ServerController serverController = this;
        synchronized (serverController) {
            Iterator iterator = this.m_handlersByClassLoader.values().iterator();
            while (iterator.hasNext()) {
                Map handlers = (Map)iterator.next();
                allHhandlers.addAll(handlers.values());
            }
        }
        Iterator handlersIter = allHhandlers.iterator();
        return handlersIter;
    }

    static {
        try {
            String sessLogging = System.getenv("SESSION_LOGGING");
            if (sessLogging != null && sessLogging.trim().equals("1")) {
                s_sessLogging = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

