/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.AbstractServerHandler;
import com.crystaldecisions.enterprise.ocaframework.IInvocationHandler;
import com.crystaldecisions.enterprise.ocaframework.IPropertyBag;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgr;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.thirdparty.org.omg.CORBA.NO_RESPONSE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Object;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.TRANSIENT;
import com.crystaldecisions.thirdparty.org.omg.CORBA.UNKNOWN;
import com.crystaldecisions.thirdparty.org.omg.CORBA.UserException;

public class ServerHelper {
    private static final ILogger LOG = LoggerManager.getLogger((Class)ServerHelper.class);
    static /* synthetic */ Class class$java$net$ConnectException;

    public static java.lang.Object invokeServer(IPropertyBag bag, String ior, IInvocationHandler handler) throws UserException, SystemException {
        boolean retry;
        int timeout;
        ServiceMgr serviceMgr = (ServiceMgr)ServiceMgrFactory.getServiceMgr();
        if (System.getProperty("bobje.buildserver.timeout") != null) {
            try {
                timeout = Integer.parseInt(System.getProperty("bobje.buildserver.timeout"));
            }
            catch (NumberFormatException e) {
                timeout = 20000;
            }
        } else {
            timeout = 20000;
        }
        int retries = 0;
        Throwable exception = null;
        do {
            retry = false;
            try {
                Object object = serviceMgr.getORB().string_to_object(ior);
                object = serviceMgr.setTimeoutPolicy(timeout, object);
                if (LOG.isInfoEnabled()) {
                    LOG.info((java.lang.Object)("(invokeServer:50) retries=" + retries + ",handler=" + handler));
                }
                return handler.invoke(object);
            }
            catch (UserException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((java.lang.Object)("(invokeServer:283) user exception, not considered server is down, just rethrow: cms=" + bag.getString(AbstractServerHandler.APS_NAME) + ",name=" + bag.getString(AbstractServerHandler.SERVER_NAME)), (Throwable)e);
                }
                throw e;
            }
            catch (TRANSIENT e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((java.lang.Object)("(invokeServer:289) server is down? cms=" + bag.getString(AbstractServerHandler.APS_NAME) + ",name=" + bag.getString(AbstractServerHandler.SERVER_NAME)), (Throwable)e);
                }
                if (e.getMessage().indexOf((class$java$net$ConnectException == null ? ServerHelper.class$("java.net.ConnectException") : class$java$net$ConnectException).getName()) != -1) {
                    bag.setProperty((java.lang.Object)AbstractServerHandler.SERVER_VALID, AbstractServerHandler.INVALID_FAILED);
                    throw e;
                }
                retry = true;
                exception = e;
            }
            catch (NO_RESPONSE t) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((java.lang.Object)("(invokeServer:295) server is down? cms=" + bag.getString(AbstractServerHandler.APS_NAME) + ",name=" + bag.getString(AbstractServerHandler.SERVER_NAME)), (Throwable)t);
                }
                if (t.completed.value() == 2) {
                    timeout *= 2;
                    retry = true;
                    exception = t;
                    continue;
                }
                bag.setProperty((java.lang.Object)AbstractServerHandler.SERVER_VALID, AbstractServerHandler.INVALID_FAILED);
                throw t;
            }
            catch (SystemException t) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((java.lang.Object)("(invokeServer:76) server is down? cms=" + bag.getString(AbstractServerHandler.APS_NAME) + ",name=" + bag.getString(AbstractServerHandler.SERVER_NAME)));
                }
                bag.setProperty((java.lang.Object)AbstractServerHandler.SERVER_VALID, AbstractServerHandler.INVALID_FAILED);
                throw t;
            }
        } while (retry && retries++ < 2);
        if (retries >= 2) {
            LOG.warn((java.lang.Object)("(invokeServer:308): exceeding retry limit. Mark server as down.  cms=" + bag.getString(AbstractServerHandler.APS_NAME) + ",name=" + bag.getString(AbstractServerHandler.SERVER_NAME)));
            bag.setProperty((java.lang.Object)AbstractServerHandler.SERVER_VALID, AbstractServerHandler.INVALID_FAILED);
        }
        if (exception != null) {
            throw exception;
        }
        throw new UNKNOWN();
    }
}

