/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.crystaldecisions.enterprise.ocaframework.IPropertyBag;
import com.crystaldecisions.enterprise.ocaframework.IServerHandler;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ServersIterator
implements Iterator {
    private Iterator m_clusters = null;
    private final ServerSpec m_spec;
    private IServerHandler m_handler;

    public ServersIterator(ServerSpec spec, IServerHandler handler) {
        this.m_spec = spec;
        this.m_handler = handler;
    }

    public boolean hasNext() {
        if (this.m_spec == null) {
            return false;
        }
        this.ensureClusters();
        return this.m_clusters.hasNext();
    }

    private void ensureClusters() {
        if (this.m_clusters == null) {
            Set clusters = this.m_handler.queryCluster(this.m_spec, false);
            this.m_clusters = clusters.iterator();
        }
    }

    public Object next() {
        if (this.hasNext()) {
            IPropertyBag bag = (IPropertyBag)this.m_clusters.next();
            ServerSpec spec = new ServerSpec("", "", "");
            this.m_handler.fillServerSpec(bag, spec);
            return spec;
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

