/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.conversion.DateConversion;
import com.crystaldecisions.celib.conversion.EncodeUtils;
import com.crystaldecisions.celib.io.URLEncodingWriter;
import com.crystaldecisions.celib.properties.FlagHelper;
import com.crystaldecisions.celib.properties.IBagPacker;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.IStreamBagPacker;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.WireOb2;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;

public class WireOb2Packer
implements IStreamBagPacker,
WireOb2 {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.WireOb2Packer");
    private static final String BASE64 = "0123456789?@ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    public IBagPacker getNestedPacker() {
        return this;
    }

    public String pack(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, int clearMask, int setMask) {
        CharArrayWriter sw = new CharArrayWriter();
        this.packToStream(properties, includeMask, excludeMask, recursive, sw, clearMask, setMask);
        return sw.toString();
    }

    public void packToStream(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, Writer w, int clearMask, int setMask) {
        try {
            if (properties.isEmpty()) {
                return;
            }
            w.write("2:");
            URLEncodingWriter uw = new URLEncodingWriter(w);
            Iterator iter = properties.allIterator();
            boolean firstOne = true;
            while (iter.hasNext()) {
                Property property = (Property)iter.next();
                int flags = property.getFlags();
                if (FlagHelper.isPropertyExcluded((int)includeMask, (int)excludeMask, (int)flags)) continue;
                if (!firstOne) {
                    w.write(38);
                } else {
                    firstOne = false;
                }
                w.write(IDHelper.idToName((Integer)property.getID()));
                w.write(61);
                int type = 0;
                if (property.isContainer()) {
                    PropertyBag nested = (PropertyBag)property.getValue();
                    IBagPacker packer = this.getNestedPacker();
                    int nestedIncludeMask = recursive ? includeMask : 0;
                    int nestedExcludeMask = recursive ? excludeMask : 0;
                    w.write(123);
                    if (packer instanceof IStreamBagPacker) {
                        ((IStreamBagPacker)packer).packToStream(nested, nestedIncludeMask, nestedExcludeMask, recursive, w, clearMask, setMask);
                    } else {
                        w.write(packer.packToChar(nested, nestedIncludeMask, nestedExcludeMask, recursive, clearMask, setMask));
                    }
                    w.write(125);
                    type = 63;
                } else {
                    Object value = property.getValue();
                    if (value == null) {
                        type = 0;
                    } else if (value instanceof Integer) {
                        type = 3;
                        w.write(value.toString());
                    } else if (value instanceof Boolean) {
                        type = 8;
                        w.write((Boolean)value != false ? 49 : 48);
                    } else if (value instanceof String) {
                        type = 27;
                        uw.write((String)value);
                    } else if (value instanceof Date) {
                        type = 7;
                        double variantDate = DateConversion.convertToVariantDate((Date)((Date)value), null);
                        w.write(Double.toString(variantDate));
                    } else if (value instanceof Long) {
                        type = 23;
                        w.write(value.toString());
                    } else if (value instanceof Double) {
                        type = 7;
                        w.write(value.toString());
                    } else if (value instanceof byte[]) {
                        type = 27;
                        String encoded = EncodeUtils.base64EncodeCxlib((byte[])((byte[])value));
                        uw.write(encoded);
                    }
                }
                w.write(44);
                flags &= ~clearMask;
                this.packFlags(flags |= setMask, type, w);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"packToStream(): this shouldn't happen", (Throwable)e);
        }
    }

    private void packFlags(int flags, int type, Writer w) throws IOException {
        flags &= 0xFFFFFF00;
        do {
            int bits = (flags & 0xFC000000) >>> 26;
            w.write(BASE64.charAt(bits));
        } while ((flags <<= 6) != 0);
        w.write(BASE64.charAt(type));
    }

    public void packToStream(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, Writer w) {
        this.packToStream(properties, includeMask, excludeMask, recursive, w, 0, 0);
    }

    public String pack(PropertyBag properties, int includeMask, int excludeMask, boolean recursive) {
        return this.pack(properties, includeMask, excludeMask, recursive, 0, 0);
    }

    public char[] packToChar(PropertyBag properties, int includeMask, int excludeMask, boolean recursive) {
        return this.packToChar(properties, includeMask, excludeMask, recursive);
    }

    public char[] packToChar(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, int clearMask, int setMask) {
        CharArrayWriter sw = new CharArrayWriter();
        this.packToStream(properties, includeMask, excludeMask, recursive, sw, clearMask, setMask);
        return sw.toCharArray();
    }
}

