/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.conversion.DateConversion;
import com.crystaldecisions.celib.conversion.EncodeUtils;
import com.crystaldecisions.celib.io.URLEncodingWriter;
import com.crystaldecisions.celib.properties.FlagHelper;
import com.crystaldecisions.celib.properties.IBagPacker;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.IStreamBagPacker;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.WireOb3;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;

public class WireOb3Packer
implements IStreamBagPacker,
WireOb3 {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.WireOb3Packer");
    private static final char[] BASE64 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final int BITS = 6;
    private static final char NAME_VALUE_SEPARATOR = '=';

    public IBagPacker getNestedPacker() {
        return this;
    }

    public String pack(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, int clearMask, int setMask) {
        CharArrayWriter sw = new CharArrayWriter();
        this.packToStream(properties, includeMask, excludeMask, recursive, sw, clearMask, setMask);
        return sw.toString();
    }

    public char[] packToChar(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, int clearMask, int setMask) {
        CharArrayWriter sw = new CharArrayWriter();
        this.packToStream(properties, includeMask, excludeMask, recursive, sw, clearMask, setMask);
        return sw.toCharArray();
    }

    public void packToStream(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, Writer w, int clearMask, int setMask) {
        try {
            if (properties.isEmpty()) {
                return;
            }
            URLEncodingWriter uw = new URLEncodingWriter(w);
            Iterator iter = properties.allIterator();
            boolean first = true;
            while (iter.hasNext()) {
                int wiredID;
                Property property = (Property)iter.next();
                int flags = property.getFlags();
                if (FlagHelper.isPropertyExcluded((int)includeMask, (int)excludeMask, (int)flags)) continue;
                if (first) {
                    w.write(51);
                    first = false;
                }
                w.write(38);
                int id = property.getID();
                if (IDHelper.isRegular((int)id)) {
                    wiredID = IDHelper.toWiredRegular((int)id);
                    this.encode64(wiredID, w);
                } else if (IDHelper.isIndex((int)id)) {
                    wiredID = IDHelper.toWiredIndex((int)id);
                    w.write(46);
                    this.encode64(wiredID, w);
                } else if (IDHelper.isArray((int)id)) {
                    int[] array = IDHelper.toWiredArray((int)id);
                    w.write(48);
                    this.encode64(array[0], w);
                    this.encode64(array[1], w);
                } else {
                    w.write(95);
                    w.write(IDHelper.idToName((Integer)property.getID()));
                }
                int type = 0;
                if (property.isContainer()) {
                    int nestedIncludeMask;
                    w.write(61);
                    PropertyBag nested = (PropertyBag)property.getValue();
                    IBagPacker packer = this.getNestedPacker();
                    int n = nestedIncludeMask = recursive ? includeMask : 0;
                    int nestedExcludeMask = nested.isTopLevel() ? (recursive ? excludeMask : 0) : (recursive ? excludeMask : 0x4000000);
                    w.write(123);
                    if (packer instanceof IStreamBagPacker) {
                        ((IStreamBagPacker)packer).packToStream(nested, nestedIncludeMask, nestedExcludeMask, recursive, w, clearMask, setMask);
                    } else {
                        w.write(packer.packToChar(nested, nestedIncludeMask, nestedExcludeMask, recursive, clearMask, setMask));
                    }
                    w.write(125);
                    type = 63;
                } else {
                    Object value = property.getValue();
                    if (value == null) {
                        type = 27;
                        w.write(61);
                        w.write(48);
                    } else if (value instanceof Integer) {
                        type = 3;
                        Integer val = (Integer)value;
                        if (val != 0) {
                            w.write(61);
                            w.write(value.toString());
                        }
                    } else if (value instanceof Boolean) {
                        type = 8;
                        Boolean val = (Boolean)value;
                        if (val.booleanValue()) {
                            w.write(61);
                            w.write(49);
                        }
                    } else if (value instanceof String) {
                        type = 27;
                        String val = (String)value;
                        if (val.length() != 0) {
                            w.write(61);
                            uw.write(val);
                        }
                    } else if (value instanceof char[]) {
                        type = 27;
                        char[] val = (char[])value;
                        if (val.length != 0) {
                            w.write(61);
                            uw.write(val);
                        }
                    } else if (value instanceof Long) {
                        type = 23;
                        Long val = (Long)value;
                        if (val != 0L) {
                            w.write(61);
                            w.write(value.toString());
                        }
                    } else {
                        w.write(61);
                        if (value instanceof Date) {
                            type = 7;
                            double variantDate = DateConversion.convertToVariantDate((Date)((Date)value), null);
                            w.write(Double.toString(variantDate));
                        } else if (value instanceof Double) {
                            type = 7;
                            w.write(value.toString());
                        } else if (value instanceof Float) {
                            type = 6;
                            w.write(value.toString());
                        } else if (value instanceof byte[]) {
                            type = 27;
                            String encoded = EncodeUtils.base64Encode((byte[])((byte[])value));
                            uw.write(encoded);
                        }
                    }
                }
                w.write(44);
                flags &= ~clearMask;
                this.packFlags(flags |= setMask, type, w);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"packToStream(): this shouldn't happen", (Throwable)e);
        }
    }

    private void packFlags(int flags, int type, Writer w) throws IOException {
        flags &= 0xFFFFFF00;
        do {
            int bits = (flags & 0xFC000000) >>> 26;
            w.write(BASE64[bits]);
        } while ((flags <<= 6) != 0);
        w.write(BASE64[type]);
    }

    private void encode64(int value, Writer w) throws IOException {
        int shiftBits = 18;
        boolean firstNonZero = false;
        int bitmask = 0xFC0000;
        while (bitmask > 0) {
            int b64char = (value & bitmask) >> shiftBits;
            if (b64char > 0 || firstNonZero) {
                w.write(BASE64[b64char]);
                firstNonZero = true;
            }
            bitmask >>>= 6;
            shiftBits -= 6;
        }
    }

    public void packToStream(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, Writer w) {
        this.packToStream(properties, includeMask, excludeMask, recursive, w, 0, 0);
    }

    public String pack(PropertyBag properties, int includeMask, int excludeMask, boolean recursive) {
        return this.pack(properties, includeMask, excludeMask, recursive, 0, 0);
    }

    public char[] packToChar(PropertyBag properties, int includeMask, int excludeMask, boolean recursive) {
        return this.packToChar(properties, includeMask, excludeMask, recursive, 0, 0);
    }
}

