/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.crystaldecisions.celib.conversion.DateConversion;
import com.crystaldecisions.celib.properties.FlagHelper;
import com.crystaldecisions.celib.properties.IBagPacker;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Packer;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.property;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Any;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORB;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class WirePacker {
    private static final ORB s_orb = ServiceMgrFactory.getServiceMgr().getORB();

    public IBagPacker getNestedPacker() {
        return new WireOb3Packer();
    }

    public property[] pack(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, int clearMask, int setMask) {
        ArrayList<property> output = new ArrayList<property>(properties.size());
        Iterator iter = properties.allIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            int flags = prop.getFlags();
            if (FlagHelper.isPropertyExcluded((int)includeMask, (int)excludeMask, (int)flags)) continue;
            Object value = null;
            if (prop.isContainer()) {
                IBagPacker packer = this.getNestedPacker();
                PropertyBag nested = (PropertyBag)prop.getValue();
                int nestedIncludeMask = recursive ? includeMask : 0;
                int nestedExcludeMask = recursive ? excludeMask : 0;
                value = packer.pack(nested, nestedIncludeMask, nestedExcludeMask, recursive, clearMask, setMask);
            } else {
                value = prop.getValue();
            }
            Any any = s_orb.create_any();
            if (value != null) {
                if (value instanceof Integer) {
                    any.insert_long(((Integer)value).intValue());
                } else if (value instanceof Long) {
                    any.insert_longlong(((Long)value).longValue());
                } else if (value instanceof Boolean) {
                    any.insert_boolean(((Boolean)value).booleanValue());
                } else if (value instanceof Double) {
                    any.insert_double(((Double)value).doubleValue());
                } else if (value instanceof String) {
                    any.insert_wstring((String)value);
                } else if (value instanceof char[]) {
                    any.insert_wstring(((char[])value).toString());
                } else if (value instanceof Date) {
                    double variantDate = DateConversion.convertToVariantDate((Date)((Date)value), null);
                    any.insert_double(variantDate);
                } else if (value instanceof Float) {
                    any.insert_float(((Float)value).floatValue());
                }
            }
            flags &= ~clearMask;
            property wireProp = new property(IDHelper.idToName((Integer)prop.getID()), any, flags |= setMask);
            output.add(wireProp);
        }
        return output.toArray(new property[output.size()]);
    }

    public property[] pack(PropertyBag properties, int includeMask, int excludeMask, boolean recursive) {
        return this.pack(properties, includeMask, excludeMask, recursive, 0, 0);
    }
}

