/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.conversion.DateConversion;
import com.crystaldecisions.celib.conversion.IntegerConversion;
import com.crystaldecisions.celib.conversion.LongConversion;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.enterprise.ocaframework.CORBASeqHelper;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.property;
import com.crystaldecisions.thirdparty.org.omg.CORBA.TypeCodePackage.BadKind;

public class WireUnpacker
implements IBagUnpacker {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.WireUnpacker");
    private static final IBagUnpacker.IBagUnpackerFactory s_unpackerFactory = new WireUnpackerFactory();
    private property[] m_properties = null;
    private int m_index;

    public void initialize(Object src) {
        LOG.assertTrue(src instanceof property[], "initialize(): source must be CORBA property array");
        this.m_properties = (property[])src;
        this.m_index = 0;
    }

    public IBagUnpacker.IBagUnpackerFactory getNestedUnpackerFactory() {
        return s_unpackerFactory;
    }

    public boolean hasNext() {
        return this.m_index < this.m_properties.length;
    }

    public Object next() {
        IBagUnpacker.Output result;
        if (this.hasNext()) {
            property prop = this.m_properties[this.m_index];
            Object value = null;
            int type = prop.value.type().kind().value();
            switch (type) {
                case 3: {
                    value = IntegerConversion.getDefaultInteger((int)prop.value.extract_long());
                    break;
                }
                case 2: {
                    value = IntegerConversion.getDefaultInteger((int)prop.value.extract_short());
                    break;
                }
                case 23: {
                    value = LongConversion.getDefaultLong((long)prop.value.extract_longlong());
                    break;
                }
                case 8: {
                    value = prop.value.extract_boolean() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 7: {
                    if ((prop.flag & 0x10000000) != 0) {
                        double dbl = prop.value.extract_double();
                        value = DateConversion.convertVariantDate((double)dbl, null);
                        break;
                    }
                    value = new Double(prop.value.extract_double());
                    break;
                }
                case 6: {
                    value = new Float(prop.value.extract_float());
                    break;
                }
                case 18: {
                    value = prop.value.extract_string();
                    break;
                }
                case 27: {
                    value = prop.value.extract_wstring();
                    break;
                }
                case 19: {
                    try {
                        switch (prop.value.type().content_type().kind().value()) {
                            case 18: {
                                value = CORBASeqHelper.extractString(prop.value);
                                break;
                            }
                            case 27: {
                                value = CORBASeqHelper.extractWString(prop.value);
                            }
                        }
                        break;
                    }
                    catch (BadKind badKind) {
                        // empty catch block
                    }
                }
            }
            ++this.m_index;
            result = value != null ? new IBagUnpacker.Output(IDHelper.nameToID((String)prop.name), value, prop.flag) : IBagUnpacker.Output.UNSUPPORTEDTYPE;
        } else {
            result = null;
        }
        return result;
    }

    public void remove() {
    }

    private static class WireUnpackerFactory
    implements IBagUnpacker.IBagUnpackerFactory {
        private WireUnpackerFactory() {
        }

        public IBagUnpacker makeUnpacker() {
            return new WireOb3Unpacker();
        }
    }
}

