/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.conversion.DateConversion;
import com.crystaldecisions.celib.io.URLEncodingWriter;
import com.crystaldecisions.celib.properties.FlagHelper;
import com.crystaldecisions.celib.properties.IBagPacker;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.IStreamBagPacker;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;

public class XRLPacker
implements IStreamBagPacker {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.XRLPacker");
    protected static final String XRL_PREFIX = "wireob01://";

    public IBagPacker getNestedPacker() {
        return this;
    }

    public String pack(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, int clearMask, int setMask) {
        CharArrayWriter sw = new CharArrayWriter();
        this.packToStream(properties, includeMask, excludeMask, recursive, sw, clearMask, setMask);
        return sw.toString();
    }

    public void packToStream(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, Writer w, int clearMask, int setMask) {
        try {
            w.write(XRL_PREFIX);
            URLEncodingWriter uw = new URLEncodingWriter(w);
            Iterator iter = properties.allIterator();
            boolean firstOne = true;
            while (iter.hasNext()) {
                Property property2 = (Property)iter.next();
                if (FlagHelper.isPropertyExcluded((int)includeMask, (int)excludeMask, (int)property2.getFlags())) continue;
                if (firstOne) {
                    firstOne = false;
                } else {
                    w.write(38);
                }
                w.write(IDHelper.idToName((Integer)property2.getID()));
                w.write(61);
                int type = 0;
                if (property2.isContainer()) {
                    int nestedExcludeMask;
                    PropertyBag nested = (PropertyBag)property2.getValue();
                    IBagPacker packer = this.getNestedPacker();
                    int nestedIncludeMask = recursive ? includeMask : 0;
                    int n = nestedExcludeMask = recursive ? excludeMask : 0;
                    if (packer instanceof IStreamBagPacker) {
                        ((IStreamBagPacker)packer).packToStream(nested, nestedIncludeMask, nestedExcludeMask, recursive, (Writer)uw, clearMask, setMask);
                    } else {
                        uw.write(packer.packToChar(nested, nestedIncludeMask, nestedExcludeMask, recursive, clearMask, setMask));
                    }
                    type = 27;
                } else {
                    Object value = property2.getValue();
                    if (value == null) {
                        type = 0;
                    } else if (value instanceof Integer) {
                        type = 3;
                        w.write(value.toString());
                    } else if (value instanceof Long) {
                        type = 23;
                        w.write(value.toString());
                    } else if (value instanceof Boolean) {
                        type = 8;
                        w.write((Boolean)value != false ? 49 : 48);
                    } else if (value instanceof Double) {
                        type = 7;
                        w.write(value.toString());
                    } else if (value instanceof String) {
                        type = 27;
                        uw.write((String)value);
                    } else if (value instanceof Date) {
                        type = 7;
                        double variantDate = DateConversion.convertToVariantDate((Date)((Date)value), null);
                        w.write(Double.toString(variantDate));
                    }
                }
                w.write(44);
                w.write(Integer.toString(property2.getFlags()));
                w.write(44);
                w.write(Integer.toString(type));
            }
        }
        catch (IOException e) {
            LOG.error((Object)"packToStream(): this shouldn't happen", (Throwable)e);
        }
    }

    public void packToStream(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, Writer w) {
        this.packToStream(properties, includeMask, excludeMask, recursive, w, 0, 0);
    }

    public String pack(PropertyBag properties, int includeMask, int excludeMask, boolean recursive) {
        return this.pack(properties, includeMask, excludeMask, recursive, 0, 0);
    }

    public char[] packToChar(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, int clearMask, int setMask) {
        CharArrayWriter sw = new CharArrayWriter();
        this.packToStream(properties, includeMask, excludeMask, recursive, sw, clearMask, setMask);
        return sw.toCharArray();
    }

    public char[] packToChar(PropertyBag properties, int includeMask, int excludeMask, boolean recursive) {
        return this.packToChar(properties, includeMask, excludeMask, recursive, 0, 0);
    }
}

