/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.conversion.DateConversion;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.URLDecoder;

public class XRLUnpacker
implements IBagUnpacker {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.XRLUnpacker");
    private static final IBagUnpacker.IBagUnpackerFactory s_bagUnpackerFactory = new XRLUnpackerFactory();
    protected static final String XRL_PREFIX = "wireob01://";
    private String m_xrl = null;
    private int m_offset;

    public void initialize(Object src) {
        LOG.assertTrue(src instanceof String, "initialize(): source must be string");
        String xrl = (String)src;
        LOG.assertTrue(xrl.startsWith(XRL_PREFIX), "initialize(): this should really an XRL");
        this.m_xrl = xrl;
        this.m_offset = XRL_PREFIX.length();
    }

    public IBagUnpacker.IBagUnpackerFactory getNestedUnpackerFactory() {
        return s_bagUnpackerFactory;
    }

    public boolean hasNext() {
        LOG.assertNotNull((Object)this.m_xrl, "m_xrl is null.");
        return this.m_offset < this.m_xrl.length();
    }

    public Object next() {
        if (this.hasNext()) {
            int eq = this.m_xrl.indexOf(61, this.m_offset);
            LOG.assertTrue(eq != -1, "next(): must have non-empty value");
            int comma1 = this.m_xrl.indexOf(44, eq + 1);
            LOG.assertTrue(comma1 != -1, "next(): there should always be 3 parts to the value");
            int comma2 = this.m_xrl.indexOf(44, comma1 + 1);
            int amp = this.m_xrl.indexOf(38, comma2);
            if (amp == -1) {
                amp = this.m_xrl.length();
            }
            String name = this.m_xrl.substring(this.m_offset, eq);
            String valueStr = URLDecoder.decode((String)this.m_xrl.substring(eq + 1, comma1));
            String flagStr = this.m_xrl.substring(comma1 + 1, comma2);
            String typeStr = this.m_xrl.substring(comma2 + 1, amp);
            int flag = Integer.parseInt(flagStr);
            int type = Integer.parseInt(typeStr);
            Object value = null;
            switch (type) {
                case 2: 
                case 3: {
                    value = Integer.valueOf(valueStr);
                    break;
                }
                case 23: {
                    value = Long.valueOf(valueStr);
                    break;
                }
                case 8: {
                    value = Integer.parseInt(valueStr) != 0 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 7: {
                    if ((flag & 0x10000000) != 0) {
                        value = DateConversion.convertVariantDate((double)Double.parseDouble(valueStr), null);
                        break;
                    }
                    value = Double.valueOf(valueStr);
                    break;
                }
                case 18: 
                case 27: {
                    value = valueStr;
                }
            }
            Integer id = IDHelper.nameToID((String)name);
            this.m_offset = amp + 1;
            return new IBagUnpacker.Output(id, value, flag);
        }
        return null;
    }

    public void remove() {
    }

    private static class XRLUnpackerFactory
    implements IBagUnpacker.IBagUnpackerFactory {
        private XRLUnpackerFactory() {
        }

        public IBagUnpacker makeUnpacker() {
            return new XRLUnpacker();
        }
    }
}

