/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.exception;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKExceptionCode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class SDKBatchException
extends SDKException {
    private List m_exceptions;
    private static final String RESOURCE_ID = "com/crystaldecisions/sdk/exception/SDKBatchExceptionResources";

    SDKBatchException(List exceptions) {
        super(RESOURCE_ID, "description", new String[]{Integer.toString(exceptions.size())}, null, SDKExceptionCode.Error_SDKBatchException_Undefined);
        this.m_exceptions = new ArrayList(exceptions);
    }

    public List getExceptions() {
        return this.m_exceptions;
    }

    public String getMessage(Locale locale) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.getMessage(locale));
        buffer.append('\n');
        for (int i = 0; i < this.m_exceptions.size(); ++i) {
            SDKException e = (SDKException)((Object)this.m_exceptions.get(i));
            String format = ResourceBundle.getBundle(RESOURCE_ID, locale).getString("message");
            String message = MessageFormat.format(format, Integer.toString(i + 1), e.getMessage(locale));
            buffer.append(message);
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public String getDetail() {
        return this.getDetailMessage();
    }

    public String getDetailMessage(Locale locale) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.getMessage(locale));
        buffer.append('\n');
        for (int i = 0; i < this.m_exceptions.size(); ++i) {
            SDKException e = (SDKException)((Object)this.m_exceptions.get(i));
            String format = ResourceBundle.getBundle(RESOURCE_ID, locale).getString("detail");
            String message = MessageFormat.format(format, Integer.toString(i + 1), e.getDetailMessage(locale));
            buffer.append(message);
            buffer.append('\n');
        }
        return buffer.toString();
    }
}

