/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.exception;

import com.businessobjects.foundation.exception.IException;
import com.businessobjects.foundation.exception.IInternalException;
import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.exception.AbstractException;
import com.crystaldecisions.celib.exception.CEException;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKExceptionCode;
import com.crystaldecisions.sdk.exception.SDKServerException;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.UserException;
import java.io.ObjectStreamException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class SDKException
extends AbstractException {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.exception.SDKException");

    protected SDKException(String[] message, Throwable cause) {
        super(message, cause, String.valueOf(SDKException.getExceptionCode(cause, SDKExceptionCode.Error_Undefined)));
    }

    protected SDKException(String resourceID, String locID, String[] messageParams, Throwable cause) {
        super(resourceID, locID, String.valueOf(SDKException.getExceptionCode(cause, SDKExceptionCode.Error_Undefined)), messageParams, cause);
    }

    protected SDKException(String[] message, Throwable cause, int errorCode) {
        super(message, cause, String.valueOf(errorCode));
    }

    protected SDKException(String resourceID, String locID, String[] messageParams, Throwable cause, int errorCode) {
        super(resourceID, locID, String.valueOf(errorCode), messageParams, cause);
    }

    protected SDKException(String resourceID, String locID, String[] messageParams, Throwable cause, String errorCode) {
        super(resourceID, locID, errorCode, messageParams, cause);
    }

    protected static int getExceptionCode(Throwable cause, int defaultCode) {
        return cause != null && cause instanceof CEException ? ((CEException)cause).getExceptionCode() : defaultCode;
    }

    public static SDKException map(SystemException ex) {
        return new CORBASystem((Exception)((Object)ex));
    }

    public static SDKException map(UserException ex) {
        return new CORBAUser((Exception)((Object)ex));
    }

    public static SDKException map(oca_abuse ex) {
        if (ex.errCode != 0) {
            return SDKServerException.map(ex);
        }
        try {
            Throwable e = IException.Factory.deserialize((String)ex.details);
            return new SDKServerExceptionWrapper(e);
        }
        catch (Exception e) {
            return SDKServerException.map(ex);
        }
    }

    public static SDKException map(OCAFrameworkException ex) {
        if (ex instanceof OCAFrameworkException.ServerError) {
            return SDKServerException.map((oca_abuse)ex.getCause());
        }
        return new OCAFramework(ex);
    }

    public static SDKException map(RemoteException ex) {
        for (Throwable e = ex.getCause(); e != null; e = e.getCause()) {
            if (e instanceof SDKException) {
                return (SDKException)((Object)e);
            }
            if (!(e instanceof IException)) continue;
            return new SDKServerExceptionWrapper(e);
        }
        return new SDKServerExceptionWrapper(ex);
    }

    public static class ErrorCode {
        public static final int Error_Unknown = 0;
        public static final int Error_ServiceFailure = 1;
        public static final int Error_CORBASystem = 2;
        public static final int Error_CORBAUser = 3;
        public static final int Error_URIFormat = 4;
        public static final int Error_FileRead = 5;
        public static final int Error_StreamRead = 6;
        public static final int Error_FileWrite = 7;
        public static final int Error_Unexpected = 8;
        public static final int Error_InvalidPagingIndex = 9;
        public static final int Error_InvalidObjectID = 10;
        public static final int Error_PluginNotFound = 11;
        public static final int Error_PluginNotFoundAtCMS = 12;
        public static final int Error_PluginInitialization = 13;
        public static final int Error_PluginCategory = 14;
        public static final int Error_PropertyNotFound = 15;
        public static final int Error_PropertyReadOnly = 16;
        public static final int Error_InvalidCopyMode = 17;
        public static final int Error_InvalidArg = 18;
        public static final int Error_InvalidOperation = 19;
        public static final int Error_UnexpectedValue = 20;
        public static final int Error_ServiceNotFound = 21;
        public static final int Error_SecurityError = 22;
        public static final int Error_NoRight = 23;
        public static final int Error_InvalidRightKind = 24;
        public static final int Error_NativeError = 25;
        public static final int Error_TimeOut = 26;
        public static final int Error_PageServerError = 27;
        public static final int Error_ConfigurationError = 28;
        public static final int Error_Serialization = 29;
        public static final int Error_UnsupportedEnterpriseVersion = 30;
        public static final int Error_DifferentEnterpriseVersion = 31;
        public static final int Error_DifferentDeployment = 32;
        public static final int Error_NotImplemented = 33;
        public static final int Error_NoRightChildren = 34;
        public static final int Error_ObjectNotFound = 35;
        public static final int Error_SameDeployment = 36;
        public static final int Error_EndOfFile = 37;
        public static final int Error_InvalidCMSSyntax = 38;
        public static final int Error_OutOfRange = 39;
        public static final int Error_ContradictingValues = 40;
        public static final int Error_MultiplePublicationDocumentsNotSupported = 41;
        public static final int Error_OCAFramework = 42;
        public static final int Error_AmbiguousDestinationUpdate = 43;
        public static final int Error_TrustedPrincipalConfigError = 44;
        public static final int Error_EncryptionError = 44;
        public static final int Error_SerializationError = 45;
        public static final int Error_InvalidFileError = 46;
        public static final int Error_InvalidType = 47;
        public static final int Error_OriginalObjectHasChanged = 48;
        public static final int Error_InvalidNewPropertyValueNonNegativeOnly = 49;
    }

    public static class SecurityCommitError
    extends CommitError {
        public SecurityCommitError(String ids, Set idSet) {
            super(new String[]{ids}, null, idSet);
        }
    }

    public static class FileCommitError
    extends CommitError {
        public FileCommitError(int infoObjID, Throwable cause) {
            super(null, cause, infoObjID);
        }
    }

    public static class CommitError
    extends SDKException {
        protected int m_infoObjID = 0;
        protected Set m_infoObjIDs = new HashSet();

        protected CommitError(String[] msg, Throwable cause) {
            super(msg, cause);
        }

        protected CommitError(String[] msg, Throwable cause, int infoObjID) {
            super(msg, cause);
            this.m_infoObjID = infoObjID;
            this.m_infoObjIDs.add(new Integer(infoObjID));
        }

        protected CommitError(String[] msg, Throwable cause, Set ids) {
            super(msg, cause);
            Iterator iter;
            this.m_infoObjIDs = ids;
            if (ids != null && (iter = ids.iterator()).hasNext()) {
                this.m_infoObjID = (Integer)iter.next();
            }
        }

        public int getFailedID() {
            return this.m_infoObjID;
        }

        public Set getFailedIDs() {
            return this.m_infoObjIDs;
        }
    }

    public static class WinADNotSupported
    extends SDKException {
        public WinADNotSupported() {
            super(null, null);
        }
    }

    public static class IndexWriteException
    extends SDKException {
        public IndexWriteException(Throwable cause) {
            super(new String[]{cause.getLocalizedMessage()}, cause);
        }
    }

    public static class FailedIndexingTaskException
    extends SDKException {
        public FailedIndexingTaskException(Throwable cause) {
            super(new String[]{cause.getLocalizedMessage()}, cause);
        }
    }

    public static class IndexingFailure
    extends SDKException {
        public IndexingFailure(Throwable cause) {
            super(new String[]{cause.getLocalizedMessage()}, cause);
        }
    }

    public static class AlreadyIndexing
    extends SDKException {
        public AlreadyIndexing() {
            super(null, null);
        }
    }

    public static class EmptyQuery
    extends SDKException {
        public EmptyQuery() {
            super(null, null);
        }
    }

    public static class InvalidSearch
    extends SDKException {
        public InvalidSearch(String queryStr, Throwable cause) {
            super(new String[]{queryStr}, cause);
        }
    }

    public static class PJSServerShutDown
    extends SDKException {
        public PJSServerShutDown() {
            super(null, null);
        }
    }

    public static class SearchServiceNotReady
    extends SDKException {
        public SearchServiceNotReady() {
            super(null, null);
        }
    }

    public static class NoSearcher
    extends SDKException {
        public NoSearcher() {
            super(null, null);
        }
    }

    public static class IndexNotReady
    extends SDKException {
        public IndexNotReady(Throwable cause) {
            super(new String[]{cause.getLocalizedMessage()}, cause);
        }
    }

    public static class FailedToCreateDoc
    extends SDKException {
        public FailedToCreateDoc(Throwable cause) {
            super(new String[]{cause.getLocalizedMessage()}, cause);
        }
    }

    public static class CMSDatabaseUnavailable
    extends SDKException {
        public CMSDatabaseUnavailable(OCAFrameworkException cause) {
            super(null, (Throwable)((Object)cause));
        }
    }

    public static class InvalidLocale
    extends SDKException {
        public InvalidLocale() {
            super(null, null);
        }
    }

    public static class InvalidFilesStructure
    extends SDKException {
        public InvalidFilesStructure() {
            super(null, null);
        }
    }

    public static class FileNotFound
    extends SDKException {
        public FileNotFound(String filename) {
            super(new String[]{filename}, null);
        }
    }

    public static class InvalidLogonToken
    extends SDKException {
        public InvalidLogonToken(String token) {
            super(new String[]{token}, null);
        }
    }

    public static class ServiceDisabled
    extends SDKException {
        public ServiceDisabled(String serviceName) {
            super(new String[]{serviceName}, null);
        }
    }

    public static class ServerAdminError
    extends SDKException {
        public ServerAdminError(Exception cause) {
            super(null, cause);
        }
    }

    public static class ServiceAdminError
    extends SDKException {
        public ServiceAdminError(Exception cause) {
            super(null, cause);
        }
    }

    public static class FailedToBuildAxisService
    extends SDKException {
        public FailedToBuildAxisService(String serviceName, Exception cause) {
            super(new String[]{serviceName}, cause);
        }
    }

    public static class ApplicationObjectCUIDNotSet
    extends SDKException {
        public ApplicationObjectCUIDNotSet() {
            super(new String[0], null);
        }
    }

    public static class AuditServiceDisabled
    extends SDKException {
        public AuditServiceDisabled() {
            super(new String[0], null);
        }
    }

    public static class InvalidEventValues
    extends SDKException {
        public InvalidEventValues() {
            super(new String[0], null);
        }
    }

    public static class EventTypeNotSupported
    extends SDKException {
        public EventTypeNotSupported(int eventType, String appKind) {
            super(new String[]{Integer.toString(eventType), appKind}, null);
        }
    }

    public static class EventTypeDisabled
    extends SDKException {
        public EventTypeDisabled(String ids) {
            super(new String[]{ids}, null);
        }
    }

    public static class AuditFailure
    extends SDKException {
        public AuditFailure(Throwable cause) {
            super(new String[0], null, SDKExceptionCode.Error_BatchFailure);
        }
    }

    public static class AuditBatchTooLarge
    extends SDKException {
        public AuditBatchTooLarge(long currentSize, long expectedSize) {
            super(new String[]{String.valueOf(currentSize), String.valueOf(expectedSize)}, null);
        }
    }

    public static class DuplicateEntry
    extends SDKException {
        public DuplicateEntry() {
            super(new String[0], null);
        }
    }

    public static class DuplicateDestinationStaticDocument
    extends InvalidPublicationConfiguration {
        public DuplicateDestinationStaticDocument(int documentID) {
            super(new String[]{Integer.toString(documentID)}, null);
        }
    }

    public static class InvalidDestinationStaticDocument
    extends InvalidPublicationConfiguration {
        public InvalidDestinationStaticDocument(int documentID) {
            super(new String[]{Integer.toString(documentID)}, null);
        }
    }

    public static class DuplicateDestinationMergeFormat
    extends InvalidPublicationConfiguration {
        public DuplicateDestinationMergeFormat(String format) {
            super(new String[]{format}, null);
        }
    }

    public static class InvalidDestinationFormat
    extends InvalidPublicationConfiguration {
        public InvalidDestinationFormat(int documentID, String documentKind, int format) {
            super(new String[]{Integer.toString(documentID), documentKind, Integer.toString(format)}, null);
        }
    }

    public static class InvalidDestinationDocument
    extends InvalidPublicationConfiguration {
        public InvalidDestinationDocument(int documentID) {
            super(new String[]{Integer.toString(documentID)}, null);
        }
    }

    public static class DuplicateFormatInfo
    extends InvalidPublicationConfiguration {
        public DuplicateFormatInfo(String documentKind, int format) {
            super(new String[]{documentKind, Integer.toString(format)}, null);
        }
    }

    public static class InvalidFormatKind
    extends InvalidPublicationConfiguration {
        public InvalidFormatKind(String documentKind) {
            super(new String[]{documentKind}, null);
        }
    }

    public static class MissingProcessingInfo
    extends InvalidPublicationConfiguration {
        public MissingProcessingInfo(int documentID, String documentKind) {
            super(new String[]{Integer.toString(documentID), documentKind}, null);
        }
    }

    public static class MultipleDocumentKinds
    extends InvalidPublicationConfiguration {
        public MultipleDocumentKinds() {
            super(new String[0], null);
        }
    }

    public static class InvalidPublicationConfiguration
    extends SDKException {
        protected InvalidPublicationConfiguration(String[] message, Exception cause, int errorCode) {
            super(message, cause, errorCode);
        }

        protected InvalidPublicationConfiguration(String[] message, Exception cause) {
            super(message, cause);
        }
    }

    public static class ServiceNotSupported
    extends SDKException {
        public ServiceNotSupported(int serverID, int serviceID) {
            super(new String[]{Integer.toString(serverID), Integer.toString(serviceID)}, null);
        }
    }

    public static class MissingSessionInfo
    extends SDKException {
        public MissingSessionInfo(String info) {
            super(new String[]{info}, null);
        }
    }

    public static class ServiceContainerInUse
    extends SDKException {
        public ServiceContainerInUse(int serviceContainerID) {
            super(new String[]{Integer.toString(serviceContainerID)}, null);
        }
    }

    public static class ServiceInUse
    extends SDKException {
        public ServiceInUse(int serviceID) {
            super(new String[]{Integer.toString(serviceID)}, null);
        }
    }

    public static class MissingEdge
    extends SDKException {
        public MissingEdge(int parentID, int childID) {
            super(new String[]{Integer.toString(parentID), Integer.toString(childID)}, null);
        }

        public MissingEdge(String parentCUID, String childCUID) {
            super(new String[]{parentCUID, childCUID}, null);
        }
    }

    public static class PropagationNotPossible
    extends SDKException {
        public PropagationNotPossible(String missingObject, String queryObject, int id) {
            super(new String[]{missingObject, queryObject, Integer.toString(id)}, null);
        }
    }

    public static class RightsAdmin
    extends SDKException {
        public RightsAdmin() {
            super(new String[0], null);
        }
    }

    public static class InvalidNewPropertyValueNonNegativeOnly
    extends SDKException {
        public InvalidNewPropertyValueNonNegativeOnly(String setterMethodName, Integer propertyID, int invalidValue) {
            super(new String[]{setterMethodName, PropertyIDs.idToName(propertyID), Integer.toString(invalidValue)}, null, SDKExceptionCode.Error_InvalidNewPropertyValueNonNegativeOnly);
        }
    }

    public static class OriginalObjectHasChanged
    extends SDKException {
        public OriginalObjectHasChanged(Integer objID, String objTitle, String objKind) {
            super(new String[]{objID.toString(), objTitle, objKind}, null, SDKExceptionCode.Error_OriginalObjectHasChanged);
        }
    }

    public static class InvalidType
    extends SDKException {
        public InvalidType(Object value, String expectedType) {
            super(new String[]{value.toString(), expectedType}, null, SDKExceptionCode.Error_SerializationError);
        }
    }

    public static class InvalidFileError
    extends SDKException {
        public InvalidFileError() {
            super(new String[0], null, SDKExceptionCode.Error_InvalidFileError);
        }
    }

    public static class SerializationError
    extends SDKException {
        public SerializationError(Exception cause) {
            super(new String[0], cause, SDKExceptionCode.Error_SerializationError);
        }
    }

    public static class EncryptionError
    extends SDKException {
        public EncryptionError(Exception cause) {
            super(new String[0], cause, SDKExceptionCode.Error_EncryptionError);
        }
    }

    public static class TrustedPrincipalConfigError
    extends SDKException {
        public TrustedPrincipalConfigError() {
            super(new String[0], null, SDKExceptionCode.Error_TrustedPrincipalConfigError);
        }
    }

    public static class AmbiguousDestinationUpdate
    extends SDKException {
        public AmbiguousDestinationUpdate() {
            super(new String[0], null, SDKExceptionCode.Error_AmbiguousDestinationUpdate);
        }
    }

    public static class MultiplePublicationDocumentsNotSupported
    extends SDKException {
        public MultiplePublicationDocumentsNotSupported() {
            super(new String[0], null, SDKExceptionCode.Error_MultiplePublicationDocumentsNotSupported);
        }
    }

    public static class ContradictingValues
    extends SDKException {
        public ContradictingValues(Object prop1, Object value1, Object prop2, Object value2) {
            super(new String[]{prop1.toString(), value1.toString(), prop2.toString(), value2.toString()}, null, SDKExceptionCode.Error_ContradictingValues);
        }
    }

    public static class OutOfRange
    extends SDKException {
        public OutOfRange(int invalidValue, int lowerBound, int upperBound) {
            super(new String[]{Integer.toString(invalidValue), Integer.toString(lowerBound), Integer.toString(upperBound)}, null, SDKExceptionCode.Error_OutOfRange);
        }
    }

    public static class InvalidCMSSyntax
    extends SDKException {
        public InvalidCMSSyntax(String value) {
            super(new String[]{value}, null, SDKExceptionCode.Error_InvalidCMSSyntax);
        }
    }

    public static class EndOfFile
    extends SDKException {
        public EndOfFile() {
            super(null, null, SDKExceptionCode.Error_EndOfFile);
        }
    }

    public static class SameDeployment
    extends SDKException {
        public SameDeployment() {
            super(null, null, SDKExceptionCode.Error_SameDeployment);
        }
    }

    public static class ObjectNotFound
    extends SDKException {
        public ObjectNotFound(String cuid) {
            super(new String[]{cuid}, null, SDKExceptionCode.Error_ObjectNotFound);
        }
    }

    public static class NoRightChildren
    extends SDKException {
        public NoRightChildren(int secID, int parentObjectID) {
            super(new String[]{Integer.toString(secID), Integer.toString(parentObjectID)}, null, SDKExceptionCode.Error_NoRightChildren);
        }

        public NoRightChildren(int secID) {
            super(new String[]{Integer.toString(secID), ""}, null, SDKExceptionCode.Error_NoRightChildren);
        }
    }

    public static class NotImplemented
    extends SDKException {
        public NotImplemented(String name) {
            super(new String[]{name}, null, SDKExceptionCode.Error_NotImplemented);
        }
    }

    public static class DifferentDeployment
    extends SDKException {
        public DifferentDeployment(String cluster1, String cluster2) {
            super(new String[]{cluster1, cluster2}, null, SDKExceptionCode.Error_DifferentDeployment);
        }
    }

    public static class DifferentEnterpriseVersion
    extends SDKException {
        public DifferentEnterpriseVersion(int ver1, int ver2) {
            super(new String[]{Integer.toString(ver1), Integer.toString(ver2)}, null, SDKExceptionCode.Error_DifferentEnterpriseVersion);
        }
    }

    public static class UnsupportedEnterpriseVersion
    extends SDKException {
        public UnsupportedEnterpriseVersion(int sdkVersion, int cmsVersion) {
            super(new String[]{Integer.toString(sdkVersion), Integer.toString(cmsVersion)}, null, SDKExceptionCode.Error_UnsupportedEnterpriseVersion);
        }
    }

    public static class Serialization
    extends ObjectStreamException {
        private SDKException m_cause;

        public Serialization(SDKException cause) {
            this.m_cause = cause;
        }

        public Serialization(OCAFrameworkException cause) {
            this.m_cause = SDKException.map(cause);
        }

        public Throwable getCause() {
            return this.m_cause;
        }

        public String getMessage() {
            return this.m_cause.getMessage(Locale.getDefault());
        }
    }

    public static class ConfigurationError
    extends SDKException {
        public ConfigurationError(String systemProperty, String propertyValue) {
            super(new String[]{systemProperty, propertyValue}, null, SDKExceptionCode.Error_ConfigurationError);
        }

        public ConfigurationError(String systemProperty, String propertyValue, Exception cause) {
            super(new String[]{systemProperty, propertyValue}, cause, ConfigurationError.getExceptionCode(cause, SDKExceptionCode.Error_ConfigurationError));
        }
    }

    public static class PageServerError
    extends SDKException {
        public PageServerError(String resourceID, String locID, String[] messageParams, Exception cause) {
            super(resourceID, locID, messageParams, (Throwable)cause, PageServerError.getExceptionCode(cause, SDKExceptionCode.Error_PageServerError));
        }
    }

    public static class TimeOut
    extends SDKException {
        public TimeOut(int seconds) {
            super(new String[]{Integer.toString(seconds)}, null, SDKExceptionCode.Error_TimeOut);
        }

        public TimeOut(int seconds, Exception cause) {
            super(new String[]{Integer.toString(seconds)}, cause, TimeOut.getExceptionCode(cause, SDKExceptionCode.Error_TimeOut));
        }
    }

    public static class NativeError
    extends SDKException {
        public NativeError(int errorCode, String errorMsg) {
            super(new String[]{Integer.toString(errorCode), errorMsg}, null, SDKExceptionCode.Error_NativeError);
        }
    }

    public static class InvalidRightKind
    extends SDKException {
        public InvalidRightKind(int secID, int objectID) {
            super(new String[]{Integer.toString(secID), Integer.toString(objectID)}, null, SDKExceptionCode.Error_InvalidRightKind);
        }

        public InvalidRightKind(int secID) {
            super(new String[]{Integer.toString(secID), ""}, null, SDKExceptionCode.Error_InvalidRightKind);
        }
    }

    public static class NoRight
    extends SDKException {
        public NoRight(int secID, int objectID) {
            super(new String[]{Integer.toString(secID), Integer.toString(objectID)}, null, SDKExceptionCode.Error_NoRight);
        }

        public NoRight(int secID) {
            super(new String[]{Integer.toString(secID), ""}, null, SDKExceptionCode.Error_NoRight);
        }
    }

    public static class SecurityError
    extends SDKException
    implements IInternalException {
        public SecurityError(String resourceID, String locID, String[] messageParams, Exception cause) {
            super(resourceID, locID, messageParams, (Throwable)cause, SecurityError.getExceptionCode(cause, SDKExceptionCode.Error_SecurityError));
        }

        public String constructErrorMessage(ResourceBundle bundle, Locale locale, String strID) {
            String errorCode;
            String message;
            block7: {
                block6: {
                    message = "";
                    errorCode = null;
                    try {
                        message = bundle.getString(strID);
                    }
                    catch (MissingResourceException e) {
                        if (!LOG.isDebugEnabled()) break block6;
                        LOG.debug((Object)("cannot obtain string. bundle: " + bundle + ", strID: " + strID));
                    }
                }
                try {
                    errorCode = bundle.getString(strID + "_code");
                }
                catch (MissingResourceException e) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug((Object)("getErrorMessage(): cannot obtain string. strID: " + strID + "_code"), (Throwable)e);
                }
            }
            if (errorCode == null || errorCode.length() == 0) {
                return message;
            }
            errorCode = '(' + errorCode + ')';
            if (message.trim().endsWith(errorCode)) {
                return message;
            }
            return message + ' ' + errorCode;
        }
    }

    public static class ServiceNotFound
    extends SDKException {
        public ServiceNotFound(String name, Exception cause) {
            super(new String[]{name}, cause, ServiceNotFound.getExceptionCode(cause, SDKExceptionCode.Error_ServiceNotFound));
        }
    }

    public static class UnexpectedValue
    extends SDKException {
        public UnexpectedValue(String propName, Object value) {
            super(new String[]{propName, value == null ? "null" : value.toString()}, null, SDKExceptionCode.Error_UnexpectedValue);
        }

        public UnexpectedValue(String propName, int value) {
            super(new String[]{propName, Integer.toString(value)}, null, SDKExceptionCode.Error_UnexpectedValue);
        }

        public UnexpectedValue(Integer propID, Object value) {
            this(PropertyIDs.idToName(propID), value);
        }

        public UnexpectedValue(Integer propID, int value) {
            this(PropertyIDs.idToName(propID), value);
        }
    }

    public static class InvalidOperation
    extends SDKException {
        public InvalidOperation() {
            super(null, null, SDKExceptionCode.Error_InvalidOperation);
        }
    }

    public static class InvalidArg
    extends SDKException {
        public InvalidArg() {
            super(new String[]{""}, null, SDKExceptionCode.Error_InvalidArg);
        }

        public InvalidArg(String value) {
            super(new String[]{value}, null, SDKExceptionCode.Error_InvalidArg);
        }

        public InvalidArg(int value) {
            super(new String[]{Integer.toString(value)}, null, SDKExceptionCode.Error_InvalidArg);
        }

        public InvalidArg(long value) {
            super(new String[]{Long.toString(value)}, null, SDKExceptionCode.Error_InvalidArg);
        }

        public InvalidArg(Exception e) {
            super(new String[0], e);
        }
    }

    public static class InvalidCopyMode
    extends SDKException {
        public InvalidCopyMode() {
            super(null, null, SDKExceptionCode.Error_InvalidCopyMode);
        }
    }

    public static class PropertyReadOnly
    extends SDKException {
        public PropertyReadOnly(Integer id) {
            super(new String[]{PropertyIDs.idToName(id)}, null, SDKExceptionCode.Error_PropertyReadOnly);
        }
    }

    public static class PVLNotSet
    extends PropertyNotFound {
        public PVLNotSet(String userid, String username) {
            super(new String[]{userid, username}, null);
        }
    }

    public static class LocaleNotSet
    extends PropertyNotFound {
        public LocaleNotSet(String userid, String username) {
            super(new String[]{userid, username}, null);
        }
    }

    public static class PropertyNotFound
    extends SDKException {
        public PropertyNotFound(String propname) {
            super(new String[]{propname}, null, SDKExceptionCode.Error_PropertyNotFound);
        }

        public PropertyNotFound(Integer id) {
            this(PropertyIDs.idToName(id));
        }

        protected PropertyNotFound(String[] message, Throwable cause, int errorCode) {
            super(message, cause, errorCode);
        }

        protected PropertyNotFound(String[] message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class PluginCategory
    extends SDKException {
        public PluginCategory(String category, Exception cause) {
            super(new String[]{category}, cause, PluginCategory.getExceptionCode(cause, SDKExceptionCode.Error_PluginCategory));
        }

        public PluginCategory(String category) {
            super(new String[]{category}, null, SDKExceptionCode.Error_PluginCategory);
        }
    }

    public static class PluginInitialization
    extends SDKException {
        public PluginInitialization(String progid) {
            super(new String[]{progid}, null, SDKExceptionCode.Error_PluginInitialization);
        }

        public PluginInitialization(String progid, Exception cause) {
            super(new String[]{progid}, cause, PluginInitialization.getExceptionCode(cause, SDKExceptionCode.Error_PluginInitialization));
        }
    }

    public static class PluginNotFoundAtCMS
    extends SDKException {
        public PluginNotFoundAtCMS(String progid, Exception cause) {
            super(new String[]{progid}, cause, PluginNotFoundAtCMS.getExceptionCode(cause, SDKExceptionCode.Error_PluginNotFoundAtCMS));
        }
    }

    public static class PluginNotFound
    extends SDKException {
        public PluginNotFound(String progid, Exception cause) {
            super(new String[]{progid}, cause, PluginNotFound.getExceptionCode(cause, SDKExceptionCode.Error_PluginNotFound));
        }

        public PluginNotFound(String progid) {
            super(new String[]{progid}, null, SDKExceptionCode.Error_PluginNotFound);
        }
    }

    public static class InvalidObjectID
    extends SDKException {
        public InvalidObjectID(int id) {
            super(new String[]{Integer.toString(id)}, null, SDKExceptionCode.Error_InvalidObjectID);
        }

        public InvalidObjectID(String cuidOrId) {
            super(new String[]{cuidOrId}, null, SDKExceptionCode.Error_InvalidObjectID);
        }
    }

    public static class InvalidPagingIndex
    extends SDKException {
        public InvalidPagingIndex(Exception cause) {
            super(null, cause, InvalidPagingIndex.getExceptionCode(cause, SDKExceptionCode.Error_InvalidPagingIndex));
        }

        public InvalidPagingIndex() {
            super(null, null, SDKExceptionCode.Error_InvalidPagingIndex);
        }
    }

    public static class Unexpected
    extends SDKException {
        public Unexpected(Exception cause) {
            super(null, cause, Unexpected.getExceptionCode(cause, SDKExceptionCode.Error_Unexpected));
        }

        public Unexpected() {
            super(null, null, SDKExceptionCode.Error_Unexpected);
        }
    }

    public static class GenericFileStoreError
    extends SDKException {
        public GenericFileStoreError(Exception cause) {
            super(null, cause);
        }
    }

    public static class StreamSeekError
    extends SDKException {
        public StreamSeekError(Exception cause) {
            super(null, cause);
        }
    }

    public static class FileRemoveError
    extends SDKException {
        public FileRemoveError(String filename, Exception cause) {
            super(new String[]{filename}, cause);
        }
    }

    public static class FileWriterError
    extends SDKException {
        public FileWriterError(Exception cause) {
            super(null, cause);
        }
    }

    public static class FileReaderError
    extends SDKException {
        public FileReaderError(Exception cause) {
            super(null, cause);
        }
    }

    public static class FileCopyError
    extends SDKException {
        public FileCopyError(String source, String destination, Exception cause) {
            super(new String[]{source, destination}, cause);
        }
    }

    public static class StreamWrite
    extends SDKException {
        public StreamWrite(Exception cause) {
            super(null, cause);
        }
    }

    public static class FileWrite
    extends SDKException {
        public FileWrite(String filename, Exception cause) {
            super(new String[]{filename}, cause, FileWrite.getExceptionCode(cause, SDKExceptionCode.Error_FileWrite));
        }
    }

    public static class StreamRead
    extends SDKException {
        public StreamRead() {
            super(null, null, SDKExceptionCode.Error_StreamRead);
        }

        public StreamRead(Exception cause) {
            super(null, cause);
        }
    }

    public static class FileRead
    extends SDKException {
        public FileRead(String filename, Exception cause) {
            super(new String[]{filename}, cause, FileRead.getExceptionCode(cause, SDKExceptionCode.Error_FileRead));
        }
    }

    public static class URIFormat
    extends SDKException {
        public URIFormat(String uri, Exception cause) {
            super(new String[]{uri}, cause, URIFormat.getExceptionCode(cause, SDKExceptionCode.Error_URIFormat));
        }
    }

    public static class CORBAUser
    extends SDKException {
        public CORBAUser(Exception cause) {
            super(null, cause, CORBAUser.getExceptionCode(cause, SDKExceptionCode.Error_CORBAUser));
        }
    }

    public static class CORBASystem
    extends SDKException {
        public CORBASystem(Exception cause) {
            super(null, cause, CORBASystem.getExceptionCode(cause, SDKExceptionCode.Error_CORBASystem));
        }
    }

    public static class ServiceFailure
    extends SDKException {
        public ServiceFailure(String serviceName, String server, Exception cause) {
            super(new String[]{serviceName, server}, cause, ServiceFailure.getExceptionCode(cause, SDKExceptionCode.Error_ServiceFailure));
        }

        public ServiceFailure(String serviceName, String server) {
            super(new String[]{serviceName, server}, null, SDKExceptionCode.Error_ServiceFailure);
        }
    }

    public static class ExceptionWrapper
    extends SDKException {
        public ExceptionWrapper(Throwable cause) {
            super(new String[]{cause.getClass().getName(), cause.getLocalizedMessage()}, cause);
        }

        public String getErrorCodeString() {
            Throwable t = this.getCause();
            if (t instanceof IException) {
                IException bobjException = (IException)t;
                return bobjException.getErrorCodeString();
            }
            return super.getErrorCodeString();
        }

        public String getMessage(Locale locale) {
            Throwable t = this.getCause();
            if (t instanceof IException) {
                IException bobjException = (IException)t;
                return bobjException.getMessage(locale);
            }
            return super.getMessage(locale);
        }

        public String getDetailMessage(Locale locale) {
            Throwable t = this.getCause();
            if (t instanceof IException) {
                IException bobjException = (IException)t;
                return bobjException.getDetailMessage(locale);
            }
            return super.getDetailMessage(locale);
        }

        public String serialize() {
            Throwable t = this.getCause();
            if (t instanceof IException) {
                IException bobjException = (IException)t;
                return bobjException.serialize();
            }
            return super.serialize();
        }
    }

    public static class SDKServerExceptionWrapper
    extends SDKException {
        public SDKServerExceptionWrapper(Throwable cause) {
            super(new String[]{cause.getClass().getName(), cause.getMessage()}, (Exception)cause);
        }

        public String getErrorCodeString() {
            Throwable t = this.getCause();
            if (t instanceof IException) {
                IException bobjException = (IException)t;
                return bobjException.getErrorCodeString();
            }
            return super.getErrorCodeString();
        }

        public String getMessage(Locale locale) {
            Throwable t = this.getCause();
            if (t instanceof IException) {
                IException bobjException = (IException)t;
                return bobjException.getMessage(locale);
            }
            return super.getMessage(locale);
        }

        public String getDetailMessage(Locale locale) {
            Throwable t = this.getCause();
            if (t instanceof IException) {
                IException bobjException = (IException)t;
                return bobjException.getDetailMessage(locale);
            }
            return super.getDetailMessage(locale);
        }

        public String serialize() {
            Throwable t = this.getCause();
            if (t instanceof IException) {
                IException bobjException = (IException)t;
                return bobjException.serialize();
            }
            return super.serialize();
        }

        public void printStackTrace() {
            Throwable t = this.getCause();
            t.printStackTrace();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printStackTrace(PrintStream s) {
            Throwable t = this.getCause();
            PrintStream printStream = s;
            synchronized (printStream) {
                s.println("SDKServerExceptionWrapper:");
                t.printStackTrace(s);
            }
        }
    }

    public static class OCAFramework
    extends SDKException {
        public OCAFramework(OCAFrameworkException cause) {
            super(new String[]{((Object)((Object)cause)).getClass().getName(), cause.getMessage()}, (Throwable)((Object)cause), OCAFramework.getExceptionCode((Throwable)((Object)cause), SDKExceptionCode.Error_OCAFramework));
        }

        public String getErrorCodeString() {
            Throwable t = this.getCause();
            if (t instanceof IException) {
                IException bobjException = (IException)t;
                return bobjException.getErrorCodeString();
            }
            return super.getErrorCodeString();
        }

        public String getMessage(Locale locale) {
            Throwable t = this.getCause();
            if (t instanceof IException) {
                IException bobjException = (IException)t;
                return bobjException.getMessage(locale);
            }
            return super.getMessage(locale);
        }

        public String getDetailMessage(Locale locale) {
            Throwable t = this.getCause();
            if (t instanceof IException) {
                IException bobjException = (IException)t;
                return bobjException.getDetailMessage(locale);
            }
            return super.getDetailMessage(locale);
        }

        public String serialize() {
            Throwable t = this.getCause();
            if (t instanceof IException) {
                IException bobjException = (IException)t;
                return bobjException.serialize();
            }
            return super.serialize();
        }

        public void printStackTrace() {
            Throwable t = this.getCause();
            t.printStackTrace();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printStackTrace(PrintStream s) {
            Throwable t = this.getCause();
            PrintStream printStream = s;
            synchronized (printStream) {
                s.println("SDKServerExceptionWrapper:");
                t.printStackTrace(s);
            }
        }
    }
}

